/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.server.monitor;

import com.iplanet.ias.admin.monitor.BaseMonitorMBean;
import com.iplanet.ias.admin.monitor.MonitoredObjectType;
import com.iplanet.ias.admin.monitor.types.Gauge;
import com.iplanet.ias.admin.monitor.types.MonitoredAttributeType;
import com.iplanet.ias.server.monitor.ProcessMonitorMBean;
import com.iplanet.ias.server.monitor.StatsDtdResolver;
import com.iplanet.ias.server.monitor.VirtualServerMonitorMBean;
import com.iplanet.ias.server.monitor.beans.ProcessMonitorBean;
import com.iplanet.ias.server.monitor.beans.ServerMonitorBean;
import com.iplanet.ias.server.monitor.beans.StatsMonitorBean;
import com.iplanet.ias.server.monitor.beans.VirtualServerMonitorBean;
import com.sun.logging.LogDomains;
import java.io.ByteArrayInputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanInfo;
import javax.management.RuntimeOperationsException;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class HttpServerMonitorMBean
extends BaseMonitorMBean {
    private static Logger _logger = null;
    private static ResourceBundle _rb = null;
    private Map _attrNameTypeMap;
    private MBeanInfo _mBeanInfo;
    private StatsMonitorBean _serverStats;
    private BaseMonitorMBean _vs;
    private BaseMonitorMBean _process;

    public HttpServerMonitorMBean() {
        if (_logger == null) {
            _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
            _rb = _logger.getResourceBundle();
        }
        this._attrNameTypeMap = new HashMap(1);
        try {
            this._attrNameTypeMap.put("summary", new Gauge(Class.forName("java.lang.StringBuffer")));
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "web.monitor.exception", exception);
        }
        this._mBeanInfo = BaseMonitorMBean.createMBeanInfo(this._attrNameTypeMap);
    }

    public void createChildren() {
        this._vs = new VirtualServerMonitorMBean(this);
        try {
            this.addChild(MonitoredObjectType.VIRTUAL_SERVER.getTypeName(), MonitoredObjectType.VIRTUAL_SERVER, this._vs);
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "web.monitor.exception", exception);
        }
        this._process = new ProcessMonitorMBean(this);
        try {
            this.addChild(MonitoredObjectType.PROCESS.getTypeName(), MonitoredObjectType.PROCESS, this._process);
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "web.monitor.exception", exception);
        }
    }

    public MBeanInfo getMBeanInfo() {
        return this._mBeanInfo;
    }

    public Map getMonitoringMetaData() {
        return this._attrNameTypeMap;
    }

    public MonitoredAttributeType getAttributeType(String string) {
        MonitoredAttributeType monitoredAttributeType = null;
        if (this._attrNameTypeMap != null && string != null) {
            monitoredAttributeType = (MonitoredAttributeType)this._attrNameTypeMap.get(string);
        }
        return monitoredAttributeType;
    }

    public Object getAttribute(String string) throws AttributeNotFoundException {
        if (string.equals("summary")) {
            this.updateNewStats();
            if (this._serverStats != null) {
                ServerMonitorBean serverMonitorBean = this._serverStats.getServer(0);
                StringBuffer stringBuffer = new StringBuffer(200);
                this.dumpSummary(stringBuffer, serverMonitorBean);
                return stringBuffer;
            }
        }
        String string2 = _rb.getString("web.monitor.attribute_not_found");
        Object[] objectArray = new Object[]{string};
        string2 = MessageFormat.format(string2, objectArray);
        throw new AttributeNotFoundException(string2);
    }

    public AttributeList getAttributes(String[] stringArray) {
        if (stringArray == null) {
            String string = _rb.getString("web.monitor.attribute_cannot_be_null");
            throw new RuntimeOperationsException(new IllegalArgumentException(string));
        }
        AttributeList attributeList = new AttributeList();
        if (stringArray.length == 0) {
            return attributeList;
        }
        int n = 0;
        while (n < stringArray.length) {
            try {
                Object object = this.getAttribute(stringArray[n]);
                attributeList.add(new Attribute(stringArray[n], object));
            }
            catch (Exception exception) {
                _logger.log(Level.WARNING, "web.monitor.error_while_getting_monitor_attr", exception);
            }
            ++n;
        }
        return attributeList;
    }

    public StatsMonitorBean getServerStats() {
        return this._serverStats;
    }

    public void dumpSummary(StringBuffer stringBuffer, ServerMonitorBean serverMonitorBean) {
        String string = "    ";
        stringBuffer.append("\nServer");
        this._serverStats.dumpAttributes("Server", 0, stringBuffer, "\n");
        stringBuffer.append("\n \n");
        boolean[] blArray = serverMonitorBean.getConnectionQueue();
        stringBuffer.append(string + "Number of Connection Queues = " + blArray.length);
        int n = 0;
        while (n < blArray.length) {
            stringBuffer.append("\n");
            stringBuffer.append(string + "Connection Queue #" + (n + 1) + ":");
            serverMonitorBean.dumpAttributes("ConnectionQueue", n, stringBuffer, "\n" + string);
            ++n;
        }
        stringBuffer.append("\n \n");
        boolean[] blArray2 = serverMonitorBean.getThreadPool();
        stringBuffer.append(string + "Number of Thread Pools = " + blArray2.length);
        int n2 = 0;
        while (n2 < blArray2.length) {
            stringBuffer.append("\n");
            stringBuffer.append(string + "Thread Pool #" + (n2 + 1) + ":");
            serverMonitorBean.dumpAttributes("ThreadPool", n2, stringBuffer, "\n" + string);
            ++n2;
        }
        stringBuffer.append("\n \n");
        boolean[] blArray3 = serverMonitorBean.getProfile();
        stringBuffer.append(string + "Number of Profiles = " + blArray3.length);
        int n3 = 0;
        while (n3 < blArray3.length) {
            stringBuffer.append("\n");
            stringBuffer.append(string + "Profile #" + (n3 + 1) + ":");
            serverMonitorBean.dumpAttributes("Profile", n3, stringBuffer, "\n" + string);
            ++n3;
        }
        stringBuffer.append("\n \n");
        VirtualServerMonitorBean[] virtualServerMonitorBeanArray = serverMonitorBean.getVirtualServer();
        stringBuffer.append(string + "Number of Virtual Servers = " + virtualServerMonitorBeanArray.length);
        int n4 = 0;
        while (n4 < virtualServerMonitorBeanArray.length) {
            stringBuffer.append("\n");
            stringBuffer.append(string + "Virtual Server #" + (n4 + 1) + ":");
            serverMonitorBean.dumpAttributes("VirtualServer", n4, stringBuffer, "\n" + string);
            ++n4;
        }
        stringBuffer.append("\n \n");
        ProcessMonitorBean[] processMonitorBeanArray = serverMonitorBean.getProcess();
        stringBuffer.append(string + "Number of Processes = " + processMonitorBeanArray.length);
        int n5 = 0;
        while (n5 < processMonitorBeanArray.length) {
            stringBuffer.append("\n");
            stringBuffer.append(string + "Process #" + (n5 + 1) + ":");
            serverMonitorBean.dumpAttributes("Process", n5, stringBuffer, "\n" + string);
            ++n5;
        }
        stringBuffer.append("\n ");
    }

    public StatsMonitorBean updateNewStats() {
        Object[] objectArray = this.jniGetHttpServerStats();
        byte[] byArray = (byte[])objectArray[0];
        byte[] byArray2 = (byte[])objectArray[1];
        if (byArray != null) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            InputSource inputSource = new InputSource(byteArrayInputStream);
            inputSource.setSystemId("iwsstats.xml");
            StatsDtdResolver statsDtdResolver = new StatsDtdResolver(byArray2);
            this._serverStats = StatsMonitorBean.createGraph(inputSource, false, (EntityResolver)statsDtdResolver);
        }
        return this._serverStats;
    }

    private native Object[] jniGetHttpServerStats();
}

