/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.server;

import com.iplanet.ias.deployment.backend.DeployableObjectType;
import com.iplanet.ias.deployment.backend.Deployer;
import com.iplanet.ias.deployment.backend.DeployerFactory;
import com.iplanet.ias.deployment.backend.DeploymentCommand;
import com.iplanet.ias.deployment.backend.DeploymentRequest;
import com.iplanet.ias.deployment.backend.IASDeploymentException;
import com.iplanet.ias.instance.InstanceEnvironment;
import com.iplanet.ias.server.ApplicationServer;
import com.iplanet.ias.server.MonitorListener;
import com.iplanet.ias.server.MonitorableEntry;
import com.iplanet.ias.util.io.FileUtils;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

class AutoDeployer
implements MonitorListener {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core");

    AutoDeployer() {
    }

    public boolean reload(MonitorableEntry monitorableEntry) {
        return false;
    }

    public boolean deploy(MonitorableEntry monitorableEntry, File file) {
        boolean bl = false;
        try {
            DeploymentRequest deploymentRequest = this.deploy(file);
            bl = true;
        }
        catch (IASDeploymentException iASDeploymentException) {
            _logger.log(Level.WARNING, "core.exception", iASDeploymentException);
            bl = false;
        }
        return bl;
    }

    private DeploymentRequest deploy(File file) throws IASDeploymentException {
        InstanceEnvironment instanceEnvironment = ApplicationServer.getServerContext().getInstanceEnvironment();
        DeployableObjectType deployableObjectType = null;
        if (FileUtils.isEar(file)) {
            deployableObjectType = DeployableObjectType.APP;
        } else if (FileUtils.isJar(file)) {
            deployableObjectType = DeployableObjectType.EJB;
        } else if (FileUtils.isWar(file)) {
            deployableObjectType = DeployableObjectType.WEB;
        } else if (FileUtils.isRar(file)) {
            deployableObjectType = DeployableObjectType.CONN;
        }
        DeploymentRequest deploymentRequest = new DeploymentRequest(instanceEnvironment, deployableObjectType, DeploymentCommand.DEPLOY);
        deploymentRequest.setFileSource(file);
        String string = file.getName();
        int n = string.indexOf(string);
        String string2 = string.substring(0, n);
        deploymentRequest.setName(string2);
        if (deployableObjectType.isWEB()) {
            deploymentRequest.setContextRoot(string2);
        }
        deploymentRequest.setForced(true);
        deploymentRequest.iAmNotAnAdminServer();
        Deployer deployer = DeployerFactory.getDeployer(deploymentRequest);
        deployer.doRequest();
        deployer.cleanup();
        return deploymentRequest;
    }
}

