/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.security.auth.realm.ldap;

import com.iplanet.ias.security.auth.login.LDAPLoginModule;
import com.iplanet.ias.security.auth.realm.IASRealm;
import com.sun.enterprise.security.auth.realm.BadRealmException;
import com.sun.enterprise.security.auth.realm.InvalidOperationException;
import com.sun.enterprise.security.auth.realm.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchUserException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;

public class LDAPRealm
extends IASRealm {
    public static final String LDAP_METACHARS = "*&|!()=<>";
    public static final String AUTH_TYPE = "ldap";
    public static final String PARAM_DIRURL = "directory";
    public static final String PARAM_USERDN = "base-dn";
    public static final String PARAM_SEARCH_FILTER = "search-filter";
    public static final String PARAM_GRPDN = "group-base-dn";
    public static final String PARAM_GRP_SEARCH_FILTER = "group-search-filter";
    public static final String PARAM_GRP_TARGET = "group-target";
    public static final String PARAM_MODE = "mode";
    public static final String PARAM_JNDICF = "jndiCtxFactory";
    public static final String PARAM_POOLSIZE = "pool-size";
    public static final String PARAM_AUTH_MECH = "authentication";
    public static final String PARAM_BINDDN = "search-bind-dn";
    public static final String PARAM_BINDPWD = "search-bind-password";
    public static final String MODE_FIND_BIND = "find-bind";
    public static final String SUBST_SUBJECT_NAME = "%s";
    public static final String SUBST_SUBJECT_DN = "%d";
    private static final String SEARCH_FILTER_DEFAULT = "uid=%s";
    private static final String GRP_SEARCH_FILTER_DEFAULT = "uniquemember=%d";
    private static final String GRP_TARGET_DEFAULT = "cn";
    private static final String MODE_DEFAULT = "find-bind";
    private static final String JNDICF_DEFAULT = "com.sun.jndi.ldap.LdapCtxFactory";
    private static final String POOLSIZE_DEFAULT = "5";
    private static final String AUTH_MECH_DEFAULT = "simple";
    private HashMap groupCache;
    private Vector emptyVector;

    public synchronized void init(Properties properties) throws BadRealmException, NoSuchRealmException {
        String string = properties.getProperty(PARAM_DIRURL);
        String string2 = properties.getProperty(PARAM_USERDN);
        String string3 = properties.getProperty("jaas-context");
        if (string == null || string2 == null || string3 == null) {
            String string4 = IASRealm.sm.getString("ldaprealm.badconfig", string, string2, string3);
            throw new BadRealmException(string4);
        }
        String string5 = properties.getProperty(PARAM_MODE, "find-bind");
        if (!"find-bind".equals(string5)) {
            String string6 = IASRealm.sm.getString("ldaprealm.badmode", string5);
            throw new BadRealmException(string6);
        }
        String string7 = properties.getProperty(PARAM_JNDICF, JNDICF_DEFAULT);
        String string8 = properties.getProperty(PARAM_SEARCH_FILTER, SEARCH_FILTER_DEFAULT);
        String string9 = properties.getProperty(PARAM_GRPDN, string2);
        String string10 = properties.getProperty(PARAM_GRP_SEARCH_FILTER, GRP_SEARCH_FILTER_DEFAULT);
        String string11 = properties.getProperty(PARAM_GRP_TARGET, GRP_TARGET_DEFAULT);
        String string12 = properties.getProperty(PARAM_POOLSIZE, POOLSIZE_DEFAULT);
        String string13 = properties.getProperty(PARAM_AUTH_MECH, AUTH_MECH_DEFAULT);
        this.setProperty(PARAM_DIRURL, string);
        this.setProperty(PARAM_USERDN, string2);
        this.setProperty("jaas-context", string3);
        if (properties.getProperty(PARAM_BINDDN) != null) {
            this.setProperty(PARAM_BINDDN, properties.getProperty(PARAM_BINDDN));
        }
        if (properties.getProperty(PARAM_BINDPWD) != null) {
            this.setProperty(PARAM_BINDPWD, properties.getProperty(PARAM_BINDPWD));
        }
        this.setProperty(PARAM_MODE, string5);
        this.setProperty(PARAM_JNDICF, string7);
        this.setProperty(PARAM_SEARCH_FILTER, string8);
        this.setProperty(PARAM_GRPDN, string9);
        this.setProperty(PARAM_GRP_SEARCH_FILTER, string10);
        this.setProperty(PARAM_GRP_TARGET, string11);
        this.setProperty(PARAM_POOLSIZE, string12);
        this.setProperty(PARAM_AUTH_MECH, string13);
        if (IASRealm._logger.isLoggable(Level.FINE)) {
            IASRealm._logger.fine("LDAPRealm : directory=" + string);
            IASRealm._logger.fine("LDAPRealm : base-dn=" + string2);
            IASRealm._logger.fine("LDAPRealm : jndiCtxFactory=" + string7);
            IASRealm._logger.fine("LDAPRealm : jaas-context=" + string3);
            IASRealm._logger.fine("LDAPRealm : mode=" + string5);
            IASRealm._logger.fine("LDAPRealm : search-filter=" + string8);
            IASRealm._logger.fine("LDAPRealm : group-base-dn=" + string9);
            IASRealm._logger.fine("LDAPRealm : group-search-filter=" + string10);
            IASRealm._logger.fine("LDAPRealm : group-target=" + string11);
            IASRealm._logger.fine("LDAPRealm : search-bind-dn=" + this.getProperty(PARAM_BINDDN));
            IASRealm._logger.fine("LDAPRealm : search-bind-password=" + (this.getProperty(PARAM_BINDPWD) == null ? null : "******"));
            IASRealm._logger.fine("LDAPRealm : pool-size=" + string12);
            IASRealm._logger.fine("LDAPRealm : authentication=" + string13);
        }
        this.groupCache = new HashMap();
        this.emptyVector = new Vector();
        Properties properties2 = this.getLdapBindProp();
        int n = 1;
        String string14 = this.getProperty(PARAM_POOLSIZE);
        if (string14 != null) {
            n = Integer.parseInt(string14);
        }
        LDAPLoginModule.createConnectionPool(properties2, n);
    }

    public String getAuthType() {
        return AUTH_TYPE;
    }

    public Properties getLdapBindProp() {
        Properties properties = new Properties();
        String string = this.getProperty(PARAM_JNDICF);
        String string2 = this.getProperty(PARAM_DIRURL);
        properties.put("java.naming.factory.initial", string);
        properties.put("java.naming.provider.url", string2);
        String string3 = this.getProperty(PARAM_BINDDN);
        String string4 = this.getProperty(PARAM_BINDPWD);
        if (string3 != null && string4 != null) {
            properties.put("java.naming.security.principal", string3);
            properties.put("java.naming.security.credentials", string4);
        }
        return properties;
    }

    public Enumeration getGroupNames(String string) throws InvalidOperationException, NoSuchUserException {
        Vector vector = (Vector)this.groupCache.get(string);
        if (vector == null) {
            IASRealm._logger.fine("No groups available for: " + string);
            return this.emptyVector.elements();
        }
        return vector.elements();
    }

    public void setGroupNames(String string, String[] stringArray) {
        Vector<String> vector = new Vector<String>(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            vector.add(stringArray[n]);
            ++n;
        }
        this.groupCache.put(string, vector);
    }
}

