/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.jms;

import com.iplanet.ias.config.serverbeans.ElementProperty;
import com.iplanet.ias.config.serverbeans.JmsService;
import com.iplanet.ias.jms.IASJmsConfig;
import com.iplanet.ias.jms.JmsProviderLifecycle;
import com.iplanet.ias.util.i18n.StringManager;
import com.sun.appserv.server.util.Version;
import com.sun.enterprise.repository.J2EEResourceBase;
import com.sun.enterprise.repository.J2EEResourceCollection;
import com.sun.enterprise.repository.JmsCnxFactoryResource;
import com.sun.enterprise.repository.JmsDestinationResource;
import com.sun.enterprise.repository.ResourceProperty;
import com.sun.logging.LogDomains;
import com.sun.messaging.jmq.jmsspi.JMSAdmin;
import com.sun.messaging.jmq.jmsspi.JMSAdminFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Topic;

public class IASJmsUtil {
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.jms");
    public static final String MDB_CONTAINER_QUEUE_XACF = "MDB_CONTAINER_QUEUE_CF__jmsxa_default";
    public static final String MDB_CONTAINER_TOPIC_XACF = "MDB_CONTAINER_TOPIC_CF__jmsxa_default";
    private static StringManager _sm = StringManager.getManager(class$com$iplanet$ias$jms$IASJmsUtil == null ? (class$com$iplanet$ias$jms$IASJmsUtil = IASJmsUtil.class$("com.iplanet.ias.jms.IASJmsUtil")) : class$com$iplanet$ias$jms$IASJmsUtil);
    private static final boolean debug = false;
    static /* synthetic */ Class class$com$iplanet$ias$jms$IASJmsUtil;

    public static String getXAConnectionFactoryName(String string) {
        return "JMSXA" + string + "__jmsxa";
    }

    public static String getDestinationName(Destination destination) {
        String string = null;
        try {
            string = destination instanceof Queue ? ((Queue)destination).getQueueName() : ((Topic)destination).getTopicName();
        }
        catch (Exception exception) {}
        return string;
    }

    public static void checkVersion(JMSAdmin jMSAdmin) {
        float f = 0.0f;
        String string = "?.?";
        try {
            string = jMSAdmin.getVersion();
            f = Float.parseFloat(string);
        }
        catch (Exception exception) {
            throw new RuntimeException("Error detected while parsing JMS provider SPI version string (" + string + ").");
        }
        if ((double)f < 2.0 || (double)f >= 3.0) {
            throw new RuntimeException("Incorrect JMS Provider SPI version detected (" + string + ")." + " Please make sure that you are using the correct" + " version of the JMS provider.");
        }
    }

    public static JMSAdminFactory getJMSAdminFactory() throws Exception {
        JMSAdminFactory jMSAdminFactory = null;
        Class<?> clazz = Class.forName("com.sun.messaging.jmq.admin.jmsspi.JMSAdminFactoryImpl");
        jMSAdminFactory = (JMSAdminFactory)clazz.newInstance();
        IASJmsUtil.checkVersion(jMSAdminFactory.getJMSAdmin());
        return jMSAdminFactory;
    }

    protected static JMSAdmin getJMSAdmin() throws Exception {
        JMSAdmin jMSAdmin = JmsProviderLifecycle.getJMSAdmin();
        if (jMSAdmin == null) {
            jMSAdmin = IASJmsUtil.getJMSAdminFactory().getJMSAdmin();
        }
        return jMSAdmin;
    }

    public static void validateJMSSelector(String string) throws Exception, JMSException {
        IASJmsUtil.getJMSAdmin().validateJMSSelector(string);
    }

    public static String clientIDPropertyName() throws Exception {
        return IASJmsUtil.getJMSAdmin().clientIDPropertyName();
    }

    public static Object wrapJMSConnectionFactoryObject(Object object) throws Exception, JMSException {
        return IASJmsUtil.getJMSAdmin().wrapJMSConnectionFactoryObject(object);
    }

    public static void createDefaultXAConnectionFactory(String string, boolean bl) throws Exception {
        IASJmsConfig iASJmsConfig = new IASJmsConfig(1);
        iASJmsConfig.createXAConnectionFactory(IASJmsUtil.getXAConnectionFactoryName(string), bl);
    }

    public static void installJMSResources(J2EEResourceCollection j2EEResourceCollection) {
        _logger.log(Level.INFO, "jms.install_resources");
        try {
            Object object;
            String string;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            IASJmsConfig iASJmsConfig = new IASJmsConfig(1);
            iASJmsConfig.createXAConnectionFactory(MDB_CONTAINER_QUEUE_XACF, true, null);
            iASJmsConfig.createXAConnectionFactory(MDB_CONTAINER_TOPIC_XACF, false, null);
            Set set = j2EEResourceCollection.getResourcesByType(1);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                object5 = (JmsDestinationResource)iterator.next();
                try {
                    if (!((J2EEResourceBase)object5).isEnabled()) {
                        _logger.log(Level.INFO, "jms.resource_disabled", new Object[]{((J2EEResourceBase)object5).getName(), ((JmsDestinationResource)object5).getTypeString()});
                        continue;
                    }
                    if (((J2EEResourceBase)object5).getName() == null || ((J2EEResourceBase)object5).getName().equals("")) {
                        String string2 = _sm.getStringWithDefault("jms.resource_noname", "Resource name not specified: " + ((J2EEResourceBase)object5).getName());
                        throw new Exception(string2);
                    }
                    object4 = new HashMap();
                    object3 = ((J2EEResourceBase)object5).getProperties().iterator();
                    while (object3.hasNext()) {
                        object2 = (ResourceProperty)object3.next();
                        string = object2.getName();
                        object = object2.getValue();
                        if (string == null || string.equals("")) {
                            String string3 = _sm.getStringWithDefault("jms.resource_badpropname", "Bad property name " + string + " for " + ((J2EEResourceBase)object5).getName(), new Object[]{((J2EEResourceBase)object5).getName()});
                            throw new Exception(string3);
                        }
                        if (object == null) {
                            String string4 = _sm.getStringWithDefault("jms.resource_badpropvalue", "Bad property value " + object + " for " + ((J2EEResourceBase)object5).getName(), new Object[]{((J2EEResourceBase)object5).getName()});
                            throw new Exception(string4);
                        }
                        object4.put(string, object);
                    }
                    _logger.log(Level.INFO, "jms.binding", ((JmsDestinationResource)object5).toString());
                    iASJmsConfig.createDestination(((J2EEResourceBase)object5).getName(), ((JmsDestinationResource)object5).getIsQueue(), (Map)object4);
                }
                catch (Exception exception) {
                    _logger.log(Level.SEVERE, "jms.create_dest_obj_error", new Object[]{((J2EEResourceBase)object5).getName(), exception.getMessage()});
                    _logger.log(Level.SEVERE, "jms.create_dest_obj_exception", exception);
                }
            }
            object5 = j2EEResourceCollection.getResourcesByType(2);
            object4 = object5.iterator();
            while (object4.hasNext()) {
                object3 = (JmsCnxFactoryResource)object4.next();
                try {
                    if (!((J2EEResourceBase)object3).isEnabled()) {
                        _logger.log(Level.INFO, "jms.resource_disabled", new Object[]{((J2EEResourceBase)object3).getName(), ((JmsCnxFactoryResource)object3).getTypeString()});
                        continue;
                    }
                    if (((J2EEResourceBase)object3).getName() == null || ((J2EEResourceBase)object3).getName().equals("")) {
                        String string5 = _sm.getStringWithDefault("jms.resource_noname", "Resource name not specified: " + ((J2EEResourceBase)object3).getName());
                        throw new Exception(string5);
                    }
                    object2 = new HashMap();
                    Iterator iterator2 = ((J2EEResourceBase)object3).getProperties().iterator();
                    while (iterator2.hasNext()) {
                        ResourceProperty resourceProperty = (ResourceProperty)iterator2.next();
                        string = resourceProperty.getName();
                        object = resourceProperty.getValue();
                        if (string == null || string.equals("")) {
                            String string6 = _sm.getStringWithDefault("jms.resource_badpropname", "Bad property name " + string + " for " + ((J2EEResourceBase)object3).getName(), new Object[]{((J2EEResourceBase)object3).getName()});
                            throw new Exception(string6);
                        }
                        if (object == null) {
                            String string7 = _sm.getStringWithDefault("jms.resource_badpropvalue", "Bad property value " + object + " for " + ((J2EEResourceBase)object3).getName(), new Object[]{((J2EEResourceBase)object3).getName()});
                            throw new Exception(string7);
                        }
                        object2.put(string, object);
                    }
                    _logger.log(Level.INFO, "jms.binding", ((JmsCnxFactoryResource)object3).toString());
                    iASJmsConfig.createConnectionFactory(((J2EEResourceBase)object3).getName(), ((JmsCnxFactoryResource)object3).getIsQueue(), (Map)object2);
                }
                catch (Exception exception) {
                    _logger.log(Level.SEVERE, "jms.create_connfactory_resource_error", new Object[]{((J2EEResourceBase)object3).getName(), exception.getMessage()});
                    _logger.log(Level.SEVERE, "jms.create_connfactory_resource_exception", exception);
                }
            }
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "jms.install_resources_error", exception.getMessage());
            _logger.log(Level.SEVERE, "jms.install_resources_exception", exception);
        }
    }

    public static String getBrokerInstanceName(String string, String string2, JmsService jmsService) {
        ElementProperty[] elementPropertyArray = jmsService.getElementProperty();
        String string3 = null;
        String string4 = null;
        if (elementPropertyArray != null) {
            int n = 0;
            while (n < elementPropertyArray.length) {
                ElementProperty elementProperty = elementPropertyArray[n];
                String string5 = elementProperty.getName();
                if (string5.equals("instance-name")) {
                    string3 = elementProperty.getValue();
                }
                if (string5.equals("instance-name-suffix")) {
                    string4 = elementProperty.getValue();
                }
                if (string5.equals("append-version") && Boolean.valueOf(elementProperty.getValue()).booleanValue()) {
                    string4 = Version.getMajorVersion() + "_" + Version.getMinorVersion();
                }
                ++n;
            }
        }
        if (string3 != null) {
            return string3;
        }
        string3 = string + "_" + string2;
        if (string4 != null) {
            string3 = string3 + "_" + string4;
        }
        return string3;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

