/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.deployment.backend;

import com.iplanet.ias.deployment.backend.DeploymentCleaner;
import com.iplanet.ias.deployment.backend.DeploymentLogger;
import com.iplanet.ias.deployment.backend.IASDeploymentException;
import com.iplanet.ias.instance.InstanceEnvironment;
import com.iplanet.ias.util.i18n.StringManager;
import java.util.logging.Logger;

class DeploymentCleanerManager {
    private static long lastCleaning = 0L;
    private static Thread cleanerThread = null;
    private static final Logger logger = DeploymentLogger.get();
    private static final long minimumTimeBetweenCleaning = 900000L;
    private static StringManager localStrings = StringManager.getManager(class$com$iplanet$ias$deployment$backend$DeploymentCleanerManager == null ? (class$com$iplanet$ias$deployment$backend$DeploymentCleanerManager = DeploymentCleanerManager.class$("com.iplanet.ias.deployment.backend.DeploymentCleanerManager")) : class$com$iplanet$ias$deployment$backend$DeploymentCleanerManager);
    static /* synthetic */ Class class$com$iplanet$ias$deployment$backend$DeploymentCleanerManager;

    private DeploymentCleanerManager() {
    }

    static synchronized void clean(InstanceEnvironment instanceEnvironment) throws IASDeploymentException {
        if (instanceEnvironment == null) {
            String string = localStrings.getString("enterprise.deployment.backend.null_instanceenvironment");
            throw new IASDeploymentException(string);
        }
        long l = System.currentTimeMillis();
        if (l - lastCleaning < 900000L) {
            return;
        }
        if (cleanerThread != null && cleanerThread.isAlive()) {
            logger.warning("Cleaner thread is still alive after 15 minutes.");
            return;
        }
        lastCleaning = l;
        DeploymentCleaner deploymentCleaner = new DeploymentCleaner(instanceEnvironment);
        cleanerThread = new Thread(deploymentCleaner);
        cleanerThread.start();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

