/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.cis;

import com.iplanet.ias.util.PropertyWrapper;
import java.io.IOException;

public class CISPropertyManager
extends PropertyWrapper {
    private static String default_properties_file = "cis.properties";
    private static String strConnEnvPropertyName = "cis.properties";
    private static CISPropertyManager singleton = new CISPropertyManager();
    private boolean isNonBlocking = false;

    private CISPropertyManager() {
        super(default_properties_file, strConnEnvPropertyName);
    }

    public static CISPropertyManager getCISPropertyManager() {
        return singleton;
    }

    public void reload() throws IOException {
        this.loadProperties();
    }

    public boolean getDebugFlag() {
        return this.getBooleanProperty("CIS.DebugFlag", false);
    }

    public int getAcceptorSetSize(int n) {
        return this.getIntProperty("AcceptorManager.AcceptorSet.size", n);
    }

    public String getAcceptorHost(int n) {
        String string = new String("AcceptorManager.AcceptorSet" + n + ".host");
        return this.getProperty(string);
    }

    public int getAcceptorPortNumber(int n) {
        String string = new String("AcceptorManager.AcceptorSet" + n + ".port");
        return this.getIntProperty(string);
    }

    public int getAcceptorThreadCount(int n) {
        String string = new String("AcceptorManager.AcceptorSet" + n + ".threads");
        return this.getIntProperty(string);
    }

    public int getAcceptorTimeout(int n) {
        String string = new String("AcceptorManager.AcceptorSet" + n + ".timeout");
        return this.getIntProperty(string);
    }

    public int getInitiatedConnSetSize(int n) {
        return this.getIntProperty("ConnectionManager.InitiatedConnectionSet.size", n);
    }

    public int getAcceptedConnSetSize(int n) {
        return this.getIntProperty("ConnectionManager.AcceptedConnectionSet.size", n);
    }

    public int getConnectionListenerTableSize(int n) {
        return this.getIntProperty("ConnectionManager.ConnectionListenerTable.size", n);
    }

    public int getConnectionListSize(int n) {
        return this.getIntProperty("ConnectionManager.ConnectionList.size", n);
    }

    public int getTCPChannelTimeout(int n) {
        return this.getIntProperty("TCPChannelFactory.TCPChannelTimeout", n);
    }

    public boolean isNonBlocking() {
        return this.isNonBlocking;
    }

    public void setNonBlocking(boolean bl) {
        this.isNonBlocking = bl;
    }

    public int getTCPChannelListenBacklog(int n) {
        return this.getIntProperty("TCPChannelFactory.TCPChannelListenBacklog", n);
    }

    public int getSendBufferSize(int n) {
        return this.getIntProperty("TCPChannel.SendBuffer.Size", n);
    }

    public int getRecvBufferSize(int n) {
        return this.getIntProperty("TCPChannel.RecvBuffer.Size", n);
    }

    public long getApproximateClockDelay(long l) {
        return this.getLongProperty("ConnectionManager.ApproximateClockDelay", l);
    }

    public boolean getReaperFlag(boolean bl) {
        return this.getBooleanProperty("ConnectionManager.ReapUnsedConnections", false);
    }

    public long getReaperInterval(long l) {
        return this.getLongProperty("ConnectionManager.ReaperInterval", l);
    }

    public int getConnectionListMinSize() {
        return this.getIntProperty("ConnectionManager.ConnectionList.Minsize");
    }

    public int getConnectionListMaxSize(int n) {
        return this.getIntProperty("ConnectionManager.ConnectionList.Maxsize", n);
    }
}

