/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.verifier.tests;

import com.iplanet.ias.admin.verifier.ServerCheck;
import com.iplanet.ias.admin.verifier.ServerXmlTest;
import com.iplanet.ias.admin.verifier.tests.StaticTest;
import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigContextEvent;
import com.iplanet.ias.config.serverbeans.Applications;
import com.iplanet.ias.config.serverbeans.LifecycleModule;
import com.iplanet.ias.config.serverbeans.Server;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LifecycleModuleTest
extends ServerXmlTest
implements ServerCheck {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.verifier");

    public Result check(ConfigContext configContext) {
        Result result = super.getInitializedResult();
        try {
            Server server = (Server)configContext.getRootConfigBean();
            Applications applications = server.getApplications();
            LifecycleModule[] lifecycleModuleArray = applications.getLifecycleModule();
            String string = null;
            int n = 0;
            while (n < lifecycleModuleArray.length) {
                try {
                    string = lifecycleModuleArray[n].getLoadOrder();
                    if (string != null && Integer.parseInt(string) < 0) {
                        result.failed(this.smh.getLocalString(this.getClass().getName() + ".positiveOrder", "Load Order Must be positive number"));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".intOrder", "Load Order " + string + " for LifeCycleModule " + lifecycleModuleArray[n].getName() + " :  must be integer value : Failed", new Object[]{string, lifecycleModuleArray[n].getName()}));
                }
                ++n;
            }
            result.passed(this.smh.getLocalString(this.getClass().getName() + ".testPassed", "Test Passed : "));
        }
        catch (Exception exception) {
            _logger.log(Level.FINE, "serverxmlverifier.exception", exception);
            result.failed("Exception : " + exception.getMessage());
        }
        return result;
    }

    public Result check(ConfigContextEvent configContextEvent) {
        Object object = configContextEvent.getObject();
        Result result = new Result();
        String string = configContextEvent.getBeanName();
        if (string != null) {
            String string2 = configContextEvent.getName();
            return this.testSave(string2, (String)object);
        }
        LifecycleModule lifecycleModule = (LifecycleModule)object;
        String string3 = lifecycleModule.getName();
        if (!StaticTest.checkObjectName(string3, result)) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidName", "LifeCycle Module Name Invalid "));
            return result;
        }
        result.passed(this.smh.getLocalString(this.getClass().getName() + ".validObj", "Valid Object Name"));
        String string4 = lifecycleModule.getLoadOrder();
        try {
            if (string4 != null && Integer.parseInt(string4) < 0) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".positiveOrder", "Load Order Must be positive number"));
                return result;
            }
            result.passed("Test passed ******");
        }
        catch (NumberFormatException numberFormatException) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".intOrder", "Load Order for LifeCycleModule must be integer value"));
        }
        return result;
    }

    public Result testSave(String string, String string2) {
        Result result;
        block3: {
            result = new Result();
            result.passed(" ***");
            if (!string.equals("load-order")) break block3;
            try {
                if (string2 != null && Integer.parseInt(string2) < 0) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".positiveOrder", "Load Order Must be positive number"));
                    return result;
                }
                result.passed("Test passed ******");
            }
            catch (NumberFormatException numberFormatException) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".intOrder", "Load Order for LifeCycleModule must be integer value"));
            }
        }
        return result;
    }
}

