/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.core.mbean.config;

import com.iplanet.ias.admin.common.constant.ConfigAttributeName;
import com.iplanet.ias.admin.common.exception.MBeanConfigException;
import com.iplanet.ias.admin.server.core.mbean.config.ConfigMBeanBase;
import com.iplanet.ias.admin.server.core.mbean.config.HTTPQosBase;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.serverbeans.ElementProperty;
import com.iplanet.ias.config.serverbeans.HttpQos;
import com.iplanet.ias.config.serverbeans.ServerTags;
import com.iplanet.ias.config.serverbeans.ServerXPathHelper;
import com.iplanet.ias.config.serverbeans.VirtualServer;
import com.iplanet.ias.config.serverbeans.VirtualServerClass;
import com.iplanet.ias.config.serverbeans.WebModule;
import com.iplanet.ias.installer.core.installConfig;
import com.iplanet.ias.instance.InstanceEnvironment;
import com.iplanet.ias.util.i18n.StringManager;
import com.iplanet.ias.util.io.FileUtils;
import java.io.File;

public class ManagedVirtualServerClass
extends ConfigMBeanBase
implements ConfigAttributeName.VirtualServerClass {
    private static StringManager localStrings;
    private static final String[][] MAPLIST;
    private static final String[] ATTRIBUTES;
    private static final String[] OPERATIONS;
    static /* synthetic */ Class class$com$iplanet$ias$admin$server$core$mbean$config$GenericConfigurator;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$iplanet$ias$admin$server$core$mbean$config$ManagedVirtualServerClass;

    public ManagedVirtualServerClass() throws MBeanConfigException {
        Object[] objectArray = ConfigMBeanBase.MergeAttributesWithAnotherMbean(MAPLIST, ATTRIBUTES, HTTPQosBase.MAPLIST, HTTPQosBase.ATTRIBUTES, ServerTags.HTTP_QOS, null);
        this.setDescriptions((String[][])objectArray[0], (String[])objectArray[1], OPERATIONS);
    }

    public ManagedVirtualServerClass(String string, String string2) throws MBeanConfigException {
        this();
        this.initialize("virtual-server-class", new String[]{string, string2});
    }

    public void createHttpQos(String string, Boolean bl, String string2, Boolean bl2) throws ConfigException {
        HttpQos httpQos = new HttpQos();
        if (string != null) {
            httpQos.setBandwidthLimit(string);
        }
        if (bl != null) {
            httpQos.setEnforceBandwidthLimit(bl);
        }
        if (string2 != null) {
            httpQos.setConnectionLimit(string2);
        }
        if (bl2 != null) {
            httpQos.setEnforceConnectionLimit(bl2);
        }
        VirtualServerClass virtualServerClass = (VirtualServerClass)this.getBaseConfigBean();
        virtualServerClass.setHttpQos(httpQos);
        this.getConfigContext().flush();
    }

    public boolean isHttpQosCreated() throws ConfigException {
        VirtualServer virtualServer = (VirtualServer)this.getBaseConfigBean();
        return virtualServer.getHttpQos() != null;
    }

    public void deleteHttpQos() throws ConfigException {
        VirtualServerClass virtualServerClass = (VirtualServerClass)this.getBaseConfigBean();
        virtualServerClass.setHttpQos(null);
        this.getConfigContext().flush();
    }

    public void createVirtualServer(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, Boolean bl, String string9, String string10) throws ConfigException {
        String string11;
        VirtualServer virtualServer = new VirtualServer();
        WebModule webModule = null;
        String string12 = null;
        if (string2 != null && string2.trim().length() > 0) {
            try {
                string11 = ServerXPathHelper.getWebModuleIdXpathExpression(string2);
                webModule = (WebModule)this.getConfigBeanByXPath(string11);
                string12 = webModule.getVirtualServers();
            }
            catch (Exception exception) {
                String string13 = localStrings.getString("admin.server.core.mbean.config.no_module_for_virtual_server", string2);
                throw new ConfigException(string13);
            }
        }
        if (string != null) {
            virtualServer.setId(string);
        }
        if (string4 != null) {
            virtualServer.setDefaultObject(string4);
        }
        if (string5 != null) {
            virtualServer.setHosts(string5);
        }
        if (string6 != null) {
            virtualServer.setMime(string6);
        }
        if (string7 != null) {
            virtualServer.setState(string7);
        }
        if (string8 != null) {
            virtualServer.setAcls(string8);
        }
        if (bl != null) {
            virtualServer.setAcceptLanguage(bl);
        }
        if (string9 != null) {
            virtualServer.setLogFile(string9);
        }
        if (string10 != null) {
            virtualServer.setHttpListeners(string10);
        }
        this.addProperty(virtualServer, "dir", "");
        this.addProperty(virtualServer, "nice", "");
        this.addProperty(virtualServer, "user", "");
        this.addProperty(virtualServer, "group", "");
        this.addProperty(virtualServer, "chroot", "");
        string11 = this.getServerInstanceName();
        InstanceEnvironment instanceEnvironment = new InstanceEnvironment(string11);
        String string14 = instanceEnvironment.getDocRootPath();
        string14 = string14.replace('\\', '/');
        this.addProperty(virtualServer, "docroot", string14);
        string14 = instanceEnvironment.getDefaultAccessLogPath();
        string14 = string14.replace('\\', '/');
        this.addProperty(virtualServer, "accesslog", string14);
        if (webModule != null && string12 != null && string12.trim().length() > 0) {
            string12 = string12.trim() + "," + string;
            webModule.setVirtualServers(string12);
            virtualServer.setDefaultWebModule(string2.trim());
        }
        VirtualServerClass virtualServerClass = (VirtualServerClass)this.getBaseConfigBean();
        this.createConfigFile(virtualServer);
        virtualServerClass.addVirtualServer(virtualServer);
        this.getConfigContext().flush();
    }

    private void addProperty(VirtualServer virtualServer, String string, String string2) throws ConfigException {
        ElementProperty elementProperty = new ElementProperty();
        elementProperty.setName(string);
        elementProperty.setValue(string2);
        virtualServer.addElementProperty(elementProperty);
    }

    public void deleteVirtualServer(String string) throws ConfigException {
        VirtualServerClass virtualServerClass = (VirtualServerClass)this.getBaseConfigBean();
        VirtualServer virtualServer = virtualServerClass.getVirtualServerById(string);
        if (virtualServer != null) {
            String string2 = this.getServerInstanceName();
            InstanceEnvironment instanceEnvironment = new InstanceEnvironment(string2);
            String string3 = instanceEnvironment.getBackupConfigDirPath();
            if (!($assertionsDisabled || string3 != null && string3.length() > 0)) {
                throw new AssertionError();
            }
            String string4 = virtualServer.getConfigFile();
            if (string4 != null && string4.length() > 0) {
                File file;
                File file2 = new File(string3, string4);
                if (file2.exists()) {
                    file2.delete();
                }
                if ((file = new File(file2.getAbsolutePath() + ".timestamp")).exists()) {
                    file.delete();
                }
            }
            virtualServerClass.removeVirtualServer(virtualServer);
            this.getConfigContext().flush();
        }
    }

    public String[] listVirtualServers() throws ConfigException {
        VirtualServerClass virtualServerClass = (VirtualServerClass)this.getBaseConfigBean();
        VirtualServer[] virtualServerArray = virtualServerClass.getVirtualServer();
        String[] stringArray = new String[virtualServerArray.length];
        int n = 0;
        while (n < virtualServerArray.length) {
            stringArray[n] = virtualServerArray[n].getId();
            ++n;
        }
        return stringArray;
    }

    private void createConfigFile(VirtualServer virtualServer) throws ConfigException {
        String string = virtualServer.getId();
        String string2 = this.getServerInstanceName();
        InstanceEnvironment instanceEnvironment = new InstanceEnvironment(string2);
        String string3 = instanceEnvironment.getBackupConfigDirPath();
        if (!($assertionsDisabled || string3 != null && string3.length() > 0)) {
            throw new AssertionError();
        }
        VirtualServerClass virtualServerClass = (VirtualServerClass)this.getBaseConfigBean();
        String string4 = virtualServerClass.getConfigFile();
        if (string4 == null || string4.length() == 0) {
            string4 = "obj.conf";
        }
        File file = new File(string3, string4);
        File file2 = new File(string3, string + '-' + file.getName());
        try {
            FileUtils.copy(file, file2);
            if (instanceEnvironment.isChownNeeded(null)) {
                String string5 = instanceEnvironment.getInstanceUser();
                String string6 = new installConfig().chownFile(file2.getAbsolutePath(), string5);
                if (string6 != null) {
                    throw new ConfigException(string6);
                }
            }
            virtualServer.setConfigFile(file2.getName());
        }
        catch (Throwable throwable) {
            if (file2.exists()) {
                file2.delete();
            }
            ConfigMBeanBase.sLogger.throwing(this.getClass().getName(), "createVirtualServer", throwable);
            if (throwable instanceof ConfigException) {
                throw (ConfigException)throwable;
            }
            throw new ConfigException(throwable.getLocalizedMessage());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$iplanet$ias$admin$server$core$mbean$config$ManagedVirtualServerClass == null ? (class$com$iplanet$ias$admin$server$core$mbean$config$ManagedVirtualServerClass = ManagedVirtualServerClass.class$("com.iplanet.ias.admin.server.core.mbean.config.ManagedVirtualServerClass")) : class$com$iplanet$ias$admin$server$core$mbean$config$ManagedVirtualServerClass).desiredAssertionStatus();
        localStrings = StringManager.getManager(class$com$iplanet$ias$admin$server$core$mbean$config$GenericConfigurator == null ? (class$com$iplanet$ias$admin$server$core$mbean$config$GenericConfigurator = ManagedVirtualServerClass.class$("com.iplanet.ias.admin.server.core.mbean.config.GenericConfigurator")) : class$com$iplanet$ias$admin$server$core$mbean$config$GenericConfigurator);
        MAPLIST = new String[][]{{"id", "@" + ServerTags.ID}, {"configFile", "@" + ServerTags.CONFIG_FILE}, {"defaultObject", "@" + ServerTags.DEFAULT_OBJECT}, {"acceptLanguage", "@" + ServerTags.ACCEPT_LANGUAGE}, {"enabled", "@" + ServerTags.ENABLED}};
        ATTRIBUTES = new String[]{"id, String,       R", "configFile, String,       RW", "defaultObject, String,       RW", "acceptLanguage, boolean,      RW", "enabled, boolean,      RW"};
        OPERATIONS = new String[]{"createHttpQos(String bandwidthLimit, Boolean enforceBandwidthLimit, String connectionLimit, Boolean enforceConnectionLimit), ACTION", "deleteHttpQos(), ACTION", "isHttpQosCreated(), INFO", "createVirtualServer(String id, String defaultWebModule, String configFile, String defaultObject, String hosts, String mime, String state, String acls, Boolean acceptLanguage, String errorLog, String httpListeners), ACTION", "deleteVirtualServer(String id), ACTION", "listVirtualServers(), INFO"};
    }
}

