/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.core.jmx;

import com.iplanet.ias.admin.server.core.jmx.DomainRepository;
import com.iplanet.ias.admin.server.core.jmx.IRepository;
import com.iplanet.ias.admin.server.core.jmx.InitException;
import com.iplanet.ias.admin.server.core.jmx.Introspector;
import com.iplanet.ias.admin.server.core.jmx.MBeanIntrospector;
import com.iplanet.ias.util.i18n.StringManager;
import java.io.ObjectInputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;

public class MBeanServerImpl
implements MBeanServer {
    protected IRepository mMBeanRepository = new DomainRepository();
    private static boolean kDynamicMBeansOnly = true;
    private static String kGetMBeanInfoMethodName = "getMBeanInfo";
    private static String kAllMBeansPattern = "*";
    private static StringManager localStrings = StringManager.getManager(class$com$iplanet$ias$admin$server$core$jmx$MBeanServerImpl == null ? (class$com$iplanet$ias$admin$server$core$jmx$MBeanServerImpl = MBeanServerImpl.class$("com.iplanet.ias.admin.server.core.jmx.MBeanServerImpl")) : class$com$iplanet$ias$admin$server$core$jmx$MBeanServerImpl);
    static /* synthetic */ Class class$com$iplanet$ias$admin$server$core$jmx$MBeanServerImpl;

    protected MBeanServerImpl(String string) throws InitException {
        this.initialize();
    }

    protected MBeanServerImpl() throws InitException {
        this("DefaultDomain");
    }

    private void initialize() throws InitException {
    }

    public ObjectInstance registerMBean(Object object, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        if (object == null || objectName == null) {
            throw new IllegalArgumentException();
        }
        if (this.mMBeanRepository.contains(objectName)) {
            throw new InstanceAlreadyExistsException(objectName.toString());
        }
        this.mMBeanRepository.add(objectName, object);
        return new ObjectInstance(objectName, object.getClass().getName());
    }

    public Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceNotFoundException, MBeanException {
        Object object = this.mMBeanRepository.find(objectName);
        if (object == null) {
            throw new InstanceNotFoundException(objectName.toString());
        }
        Class<?> clazz = object.getClass();
        Introspector introspector = new Introspector(clazz);
        Object object2 = null;
        try {
            Method method = introspector.getMethod(string, stringArray);
            object2 = introspector.invokeMethodOn(method, object, objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ReflectionException(classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ReflectionException(noSuchMethodException);
        }
        catch (SecurityException securityException) {
            throw new ReflectionException(securityException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof MBeanException) {
                throw (MBeanException)throwable;
            }
            if (throwable instanceof Exception) {
                throw new MBeanException((Exception)throwable);
            }
            String string2 = localStrings.getString("admin.server.core.jmx.error_from_mbean", throwable.getMessage());
            RuntimeException runtimeException = new RuntimeException(string2);
            throw new MBeanException(runtimeException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectionException(illegalAccessException);
        }
        catch (Exception exception) {
            throw new MBeanException(exception);
        }
        return object2;
    }

    public Object getAttribute(ObjectName objectName, String string) throws InstanceNotFoundException, AttributeNotFoundException, MBeanException, ReflectionException {
        Object object = this.mMBeanRepository.find(objectName);
        if (object == null) {
            throw new InstanceNotFoundException(objectName.toString());
        }
        Class<?> clazz = object.getClass();
        Object object2 = null;
        try {
            MBeanIntrospector mBeanIntrospector = new MBeanIntrospector(clazz);
            if (mBeanIntrospector.isDynamicMBean()) {
                Method method = mBeanIntrospector.getMethod("getAttribute", new String[]{"java.lang.String"});
                object2 = mBeanIntrospector.invokeMethodOn(method, object, new Object[]{string});
            }
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            object2 = null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ReflectionException(classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ReflectionException(noSuchMethodException);
        }
        catch (SecurityException securityException) {
            throw new ReflectionException(securityException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof AttributeNotFoundException) {
                throw (AttributeNotFoundException)throwable;
            }
            if (throwable instanceof Exception) {
                throw new MBeanException((Exception)throwable);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectionException(illegalAccessException);
        }
        catch (Exception exception) {
            throw new MBeanException(exception);
        }
        return object2;
    }

    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, MBeanException, ReflectionException, InvalidAttributeValueException {
        Object object = this.mMBeanRepository.find(objectName);
        if (object == null) {
            throw new InstanceNotFoundException(objectName.toString());
        }
        Class<?> clazz = object.getClass();
        Object object2 = null;
        try {
            MBeanIntrospector mBeanIntrospector = new MBeanIntrospector(clazz);
            if (mBeanIntrospector.isDynamicMBean()) {
                Method method = mBeanIntrospector.getMethod("setAttribute", new String[]{"javax.management.Attribute"});
                object2 = mBeanIntrospector.invokeMethodOn(method, object, new Object[]{attribute});
            }
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            object2 = null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ReflectionException(classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ReflectionException(noSuchMethodException);
        }
        catch (SecurityException securityException) {
            throw new ReflectionException(securityException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof AttributeNotFoundException) {
                throw (AttributeNotFoundException)throwable;
            }
            if (throwable instanceof InvalidAttributeValueException) {
                throw (InvalidAttributeValueException)throwable;
            }
            if (throwable instanceof Exception) {
                throw new MBeanException((Exception)throwable);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectionException(illegalAccessException);
        }
        catch (Exception exception) {
            throw new MBeanException(exception);
        }
    }

    public void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException {
        if (!this.mMBeanRepository.contains(objectName)) {
            throw new InstanceNotFoundException(objectName.toString());
        }
        this.mMBeanRepository.remove(objectName);
    }

    public Integer getMBeanCount() {
        return new Integer(this.mMBeanRepository.getTotalCount());
    }

    public Set queryMBeans(ObjectName objectName, QueryExp queryExp) {
        Set set = new HashSet();
        set = this.mMBeanRepository.query(objectName);
        return set;
    }

    public MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        MBeanInfo mBeanInfo = null;
        if (!kDynamicMBeansOnly) {
            String string = localStrings.getString("admin.server.core.jmx.assert");
            throw new IntrospectionException(string);
        }
        try {
            String string = kGetMBeanInfoMethodName;
            String[] stringArray = null;
            Object[] objectArray = null;
            mBeanInfo = (MBeanInfo)this.invoke(objectName, string, objectArray, stringArray);
        }
        catch (MBeanException mBeanException) {
            throw new IntrospectionException(mBeanException.getMessage());
        }
        return mBeanInfo;
    }

    public boolean isRegistered(ObjectName objectName) {
        return this.mMBeanRepository.contains(objectName);
    }

    public void addNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException {
        String string = localStrings.getString("admin.server.core.jmx.mbeanserver_addnotificationlistener");
        throw new UnsupportedOperationException(string);
    }

    public void addNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException {
        String string = localStrings.getString("admin.server.core.jmx.mbeanserver_addnotificationlistener");
        throw new UnsupportedOperationException(string);
    }

    public ObjectInstance createMBean(String string, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        String string2 = localStrings.getString("admin.server.core.jmx.mbeanserver_creatembean");
        throw new UnsupportedOperationException(string2);
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        String string2 = localStrings.getString("admin.server.core.jmx.mbeanserver_creatembean");
        throw new UnsupportedOperationException(string2);
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        String string2 = localStrings.getString("admin.server.core.jmx.mbeanserver_creatembean");
        throw new UnsupportedOperationException(string2);
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        String string2 = localStrings.getString("admin.server.core.jmx.mbeanserver_creatembean");
        throw new UnsupportedOperationException(string2);
    }

    public ObjectInputStream deserialize(String string, byte[] byArray) throws OperationsException, ReflectionException {
        String string2 = localStrings.getString("admin.server.core.jmx.mbeanserver_deserialize");
        throw new UnsupportedOperationException(string2);
    }

    public ObjectInputStream deserialize(ObjectName objectName, byte[] byArray) throws InstanceNotFoundException, OperationsException {
        String string = localStrings.getString("admin.server.core.jmx.mbeanserver_deserialize");
        throw new UnsupportedOperationException(string);
    }

    public ObjectInputStream deserialize(String string, ObjectName objectName, byte[] byArray) throws InstanceNotFoundException, OperationsException, ReflectionException {
        String string2 = localStrings.getString("admin.server.core.jmx.mbeanserver_deserialize");
        throw new UnsupportedOperationException(string2);
    }

    public AttributeList getAttributes(ObjectName objectName, String[] stringArray) throws InstanceNotFoundException, ReflectionException {
        Object object = this.mMBeanRepository.find(objectName);
        if (object == null) {
            throw new InstanceNotFoundException(objectName.toString());
        }
        Class<?> clazz = object.getClass();
        AttributeList attributeList = new AttributeList();
        try {
            MBeanIntrospector mBeanIntrospector = new MBeanIntrospector(clazz);
            if (mBeanIntrospector.isDynamicMBean()) {
                Method method = mBeanIntrospector.getMethod("getAttributes", new String[]{"[Ljava.lang.String;"});
                attributeList = (AttributeList)mBeanIntrospector.invokeMethodOn(method, object, new Object[]{stringArray});
            }
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ReflectionException(classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ReflectionException(noSuchMethodException);
        }
        catch (SecurityException securityException) {
            throw new ReflectionException(securityException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectionException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            String string = localStrings.getString("admin.server.core.jmx.getattributes_error_from_mbean", throwable.getMessage());
            throw new RuntimeException(string);
        }
        return attributeList;
    }

    public String getDefaultDomain() {
        return "DefaultDomain";
    }

    public ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException {
        String string = localStrings.getString("admin.server.core.jmx.mbeanserver_getobjectinstance");
        throw new UnsupportedOperationException(string);
    }

    public Object instantiate(String string) throws ReflectionException, MBeanException {
        String string2 = localStrings.getString("admin.server.core.jmx.mbeanserver_instantiate");
        throw new UnsupportedOperationException(string2);
    }

    public Object instantiate(String string, ObjectName objectName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        String string2 = localStrings.getString("admin.server.core.jmx.mbeanserver_instantiate");
        throw new UnsupportedOperationException(string2);
    }

    public Object instantiate(String string, Object[] objectArray, String[] stringArray) throws ReflectionException, MBeanException {
        String string2 = localStrings.getString("admin.server.core.jmx.mbeanserver_instantiate");
        throw new UnsupportedOperationException(string2);
    }

    public Object instantiate(String string, ObjectName objectName, Object[] objectArray, String[] stringArray) throws ReflectionException, MBeanException, InstanceNotFoundException {
        String string2 = localStrings.getString("admin.server.core.jmx.mbeanserver_instantiate");
        throw new UnsupportedOperationException(string2);
    }

    public boolean isInstanceOf(ObjectName objectName, String string) throws InstanceNotFoundException {
        String string2 = localStrings.getString("admin.server.core.jmx.mbeanserver_isinstanceof");
        throw new UnsupportedOperationException(string2);
    }

    public Set queryNames(ObjectName objectName, QueryExp queryExp) {
        String string = localStrings.getString("admin.server.core.jmx.mbeanserver_querynames");
        throw new UnsupportedOperationException(string);
    }

    public void removeNotificationListener(ObjectName objectName, ObjectName objectName2) throws InstanceNotFoundException, ListenerNotFoundException {
        String string = localStrings.getString("admin.server.core.jmx.mbeanserver_removenotificationlistener");
        throw new UnsupportedOperationException(string);
    }

    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener) throws InstanceNotFoundException, ListenerNotFoundException {
        String string = localStrings.getString("admin.server.core.jmx.mbeanserver_removenotificationlistener");
        throw new UnsupportedOperationException(string);
    }

    public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException, ReflectionException {
        Object object = this.mMBeanRepository.find(objectName);
        if (object == null) {
            throw new InstanceNotFoundException(objectName.toString());
        }
        Class<?> clazz = object.getClass();
        AttributeList attributeList2 = new AttributeList();
        try {
            MBeanIntrospector mBeanIntrospector = new MBeanIntrospector(clazz);
            if (mBeanIntrospector.isDynamicMBean()) {
                Method method = mBeanIntrospector.getMethod("setAttributes", new String[]{attributeList2.getClass().getName()});
                attributeList2 = (AttributeList)mBeanIntrospector.invokeMethodOn(method, object, new Object[]{attributeList});
            }
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ReflectionException(classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ReflectionException(noSuchMethodException);
        }
        catch (SecurityException securityException) {
            throw new ReflectionException(securityException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectionException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            String string = localStrings.getString("admin.server.core.jmx.setattributes_error_from_mbean", throwable.getMessage());
            throw new RuntimeException(string);
        }
        return attributeList2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

