/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.sun.appserv;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;

public abstract class AppServerAdmin
extends Task {
    protected Server server;
    protected List servers = new ArrayList();
    private File sunonehome;
    private boolean executeCommand = true;
    private static final String[] CLASSPATH_ELEMENTS = new String[]{"lib/appserv-admin.jar", "lib/appserv-ext.jar", "lib/appserv-rt.jar"};
    private static final String CLASS_INPUTS_AND_OUTPUTS = "com.iplanet.ias.tools.cli.framework.InputsAndOutputs";
    private static final String CLASS_ADMIN_MAIN = "com.iplanet.ias.tools.cli.IasAdminMain";
    private static final String METHOD_INVOKE_CLI = "invokeCLI";
    static /* synthetic */ Class class$java$lang$String;

    public AppServerAdmin() {
        this.server = this.getNewServer();
    }

    public void setUser(String string) {
        this.server.setUser(string);
    }

    public void setPassword(String string) {
        this.server.setPassword(string);
    }

    public void setHost(String string) {
        this.server.setHost(string);
    }

    public void setPort(int n) {
        this.server.setPort(n);
    }

    public void setInstance(String string) {
        this.server.setInstance(string);
    }

    public void setExecuteCommand(boolean bl) {
        this.executeCommand = bl;
    }

    public void setSunonehome(File file) {
        this.sunonehome = file;
    }

    protected File getSunonehome() {
        String string;
        if (this.sunonehome == null && (string = this.getProject().getProperty("sunone.home")) != null) {
            this.sunonehome = new File(string);
        }
        return this.sunonehome;
    }

    public Server createServer() {
        this.log("createServer", 4);
        Server server = this.getNewServer();
        this.servers.add(server);
        return server;
    }

    protected Server getNewServer() {
        return new Server(this.server);
    }

    public void execute() throws BuildException {
        this.prepareToExecute();
        this.checkConfiguration();
        Iterator iterator = this.servers.iterator();
        while (iterator.hasNext()) {
            Server server = (Server)iterator.next();
            this.execute(server);
        }
    }

    protected void prepareToExecute() {
        if (this.servers.size() == 0) {
            this.servers.add(this.server);
        }
    }

    protected void checkConfiguration() throws BuildException {
        this.log(this.servers.size() + " servers were found.", 4);
        if (this.servers.size() == 0) {
            String string = "At least one server must be specified.";
            throw new BuildException(string, this.getLocation());
        }
        Iterator iterator = this.servers.iterator();
        while (iterator.hasNext()) {
            Server server = (Server)iterator.next();
            this.checkConfiguration(server);
        }
    }

    protected abstract void checkConfiguration(Server var1) throws BuildException;

    protected abstract void execute(Server var1) throws BuildException;

    protected void execAdminCommand(String string) throws BuildException {
        this.log("Executing: " + string, 2);
        try {
            Path path = new Path(this.getProject(), this.getServerClasspath());
            path.append(Path.systemClasspath);
            this.log("Using classpath: " + path, 4);
            AntClassLoader antClassLoader = new AntClassLoader(this.getProject(), path);
            Class<?> clazz = Class.forName(CLASS_INPUTS_AND_OUTPUTS, true, (ClassLoader)antClassLoader);
            Class<?> clazz2 = Class.forName(CLASS_ADMIN_MAIN, true, (ClassLoader)antClassLoader);
            Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = AppServerAdmin.class$("java.lang.String")) : class$java$lang$String, clazz};
            Method method = clazz2.getDeclaredMethod(METHOD_INVOKE_CLI, classArray);
            Object[] objectArray = new Object[]{string, null};
            if (this.executeCommand) {
                method.invoke(clazz2, objectArray);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string2 = "A Sun ONE Application Server 7 admin CLI class could not be found (" + classNotFoundException.getMessage() + ").  Use the sunonehome attribute, set the " + "sunone.home property, or add the appropriate " + "JARs to the classpath.";
            throw new BuildException(string2, this.getLocation());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            String string3 = "The \"invokeCLI\" method couldn't be found on the IasAdminMain class.  The exception message is:  " + noSuchMethodException.getMessage();
            throw new BuildException(string3, this.getLocation());
        }
        catch (InvocationTargetException invocationTargetException) {
            String string4 = "An exception occurred while running the command.  The exception message is: " + invocationTargetException.getTargetException().getMessage();
            throw new BuildException(string4, this.getLocation());
        }
        catch (IllegalAccessException illegalAccessException) {
            String string5 = "An exception occurred while trying to invoke the \"invokeCLI\" method.  The exception message is: " + illegalAccessException.getMessage();
            throw new BuildException(string5, this.getLocation());
        }
    }

    private String getServerClasspath() {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = this.getClasspathElements();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(new File(this.getSunonehome(), stringArray[n]).getPath());
            stringBuffer.append(':');
            ++n;
        }
        return stringBuffer.toString();
    }

    protected String[] getClasspathElements() {
        return CLASSPATH_ELEMENTS;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class Server {
        private Server parent;
        private String user;
        private String password;
        private String host;
        private int port;
        private String instance;
        protected static final String DEFAULT_USER = "admin";
        protected static final String DEFAULT_HOST = "localhost";
        protected static final String DEFAULT_PORT = "4848";

        public Server() {
            this(null);
        }

        public Server(Server server) {
            this.parent = server;
        }

        public void setParent(Server server) {
            this.parent = server;
        }

        public Server getParent() {
            return this.parent;
        }

        public void setUser(String string) {
            this.user = string;
        }

        protected String getUser() {
            if (this.user == null) {
                return this.parent == null ? DEFAULT_USER : this.parent.getUser();
            }
            return this.user;
        }

        public void setPassword(String string) {
            this.password = string;
        }

        protected String getPassword() {
            if (this.password == null) {
                return this.parent == null ? null : this.parent.getPassword();
            }
            return this.password;
        }

        public void setHost(String string) {
            this.host = string;
        }

        protected String getHost() {
            if (this.host == null) {
                return this.parent == null ? null : this.parent.getHost();
            }
            return this.host;
        }

        public void setPort(int n) {
            this.port = n;
        }

        protected int getPort() {
            if (this.port == 0) {
                return this.parent == null ? 0 : this.parent.getPort();
            }
            return this.port;
        }

        public void setInstance(String string) {
            this.instance = string;
        }

        protected String getInstance() {
            if (this.instance == null) {
                return this.parent == null ? null : this.parent.getInstance();
            }
            return this.instance;
        }

        protected String getCommandParameters(boolean bl) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(" --user ").append(this.getUser());
            stringBuffer.append(" --password ").append(this.getPassword());
            if (this.getHost() != null) {
                stringBuffer.append(" --host ").append(this.getHost());
            }
            if (this.getPort() != 0) {
                stringBuffer.append(" --port ").append(this.getPort());
            }
            if (bl && this.getInstance() != null) {
                stringBuffer.append(" --instance ").append(this.getInstance());
            }
            return stringBuffer.toString();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.getHost() == null ? DEFAULT_HOST : this.getHost());
            stringBuffer.append(':');
            stringBuffer.append(this.getPort() == 0 ? DEFAULT_PORT : String.valueOf(this.getPort()));
            return stringBuffer.toString();
        }
    }
}

