/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.sql.generator;

import com.sun.forte4j.modules.dbmodel.ColumnElement;
import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
import com.sun.jdo.api.persistence.support.JDOUserException;
import com.sun.jdo.spi.persistence.support.sqlstore.ActionDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.LogHelperSQLStore;
import com.sun.jdo.spi.persistence.support.sqlstore.ResultDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.RetrieveDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.SQLStoreManager;
import com.sun.jdo.spi.persistence.support.sqlstore.model.ClassDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.FieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.ForeignFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.LocalFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.ReferenceKeyDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.SqlIDDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.RetrieveDescImpl;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.concurrency.Concurrency;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.Constraint;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintField;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintFieldName;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintFieldNameSubQuery;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintForeignFieldName;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintJoin;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintNode;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintOperation;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintSubquery;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintValue;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.ColumnRef;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.QueryPlan;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.QueryTable;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.SelectStatement;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.Statement;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Hashtable;

public class SelectQueryPlan
extends QueryPlan {
    public static final int ST_COLLECTIVE = 8;
    public static final int ST_JOINED = 4;
    public static final int ST_FC_BUILT = 32;
    public static final int ST_ACTIVE = 64;
    public Constraint constraint;
    public ArrayList foreignPlans;
    private int maxRows;
    public ArrayList orderBy = null;
    public ForeignFieldDesc parentField;
    public SqlIDDesc resultIDDesc;
    private RetrieveDescImpl retrieveDesc;
    private Concurrency concurrency;
    private BitSet hierarchicalGroupMask;
    private BitSet independentGroupMask;
    private BitSet fieldMask = new BitSet();
    private int fetchDepth;
    private int maxFetchDepth;
    private Hashtable foreignConstraintPlans;
    public boolean correlated;
    public boolean useDependentKey;
    public boolean useInstanceKey;
    public boolean parentConstraintsAdded = false;
    private boolean isSubQueryPlan;
    private boolean appendAndOp;
    private ResultDesc resultDesc;
    public static boolean excludeSubclasses;
    private boolean projection = false;
    private int projectionId = -1;
    private static Logger logger;

    public SelectQueryPlan(ActionDesc actionDesc, SQLStoreManager sQLStoreManager, Concurrency concurrency) {
        super(actionDesc, sQLStoreManager);
        this.hierarchicalGroupMask = new BitSet();
        this.independentGroupMask = new BitSet();
        this.concurrency = concurrency;
        this.action = 4;
        this.retrieveDesc = (RetrieveDescImpl)actionDesc;
        this.retrieveDesc.plan = this;
        this.constraint = this.retrieveDesc.constraint;
        this.options = this.retrieveDesc.options;
    }

    public SelectQueryPlan(ActionDesc actionDesc, SQLStoreManager sQLStoreManager, Concurrency concurrency, int n, int n2) {
        this(actionDesc, sQLStoreManager, concurrency, n, n2, false);
    }

    public SelectQueryPlan(ActionDesc actionDesc, SQLStoreManager sQLStoreManager, Concurrency concurrency, int n, int n2, boolean bl) {
        this(actionDesc, sQLStoreManager, concurrency);
        this.maxFetchDepth = n;
        this.fetchDepth = n2;
        this.projection = bl;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public ResultDesc getResultDesc() {
        return this.resultDesc;
    }

    public void setResultDesc(ResultDesc resultDesc) {
        this.resultDesc = resultDesc;
    }

    private void setFieldMask(int n) {
        if (n < 0) {
            n = this.config.fields.size() - n;
        }
        this.fieldMask.set(n);
    }

    private boolean getFieldMask(int n) {
        if (n < 0) {
            n = this.config.fields.size() - n;
        }
        return this.fieldMask.get(n);
    }

    private void addDefaultOrderConstraint() {
        SqlIDDesc sqlIDDesc = (SqlIDDesc)this.config.persistenceIDDesc;
        if (this.constraint == null) {
            this.constraint = new Constraint();
        }
        ArrayList arrayList = sqlIDDesc.getFields();
        int n = 0;
        while (n < arrayList.size()) {
            FieldDesc fieldDesc = (FieldDesc)arrayList.get(n);
            this.constraint.addField((LocalFieldDesc)fieldDesc);
            this.constraint.addOperation(30);
            this.orderBy.add(new ConstraintFieldDesc((LocalFieldDesc)fieldDesc, 1));
            ++n;
        }
    }

    public void addColumn(LocalFieldDesc localFieldDesc, boolean bl) {
        this.addColumn(localFieldDesc, bl, false);
    }

    private void addColumn(LocalFieldDesc localFieldDesc, boolean bl, boolean bl2) {
        int n = 0;
        while (n < localFieldDesc.columnDescs.size()) {
            SelectStatement selectStatement;
            ColumnElement columnElement = (ColumnElement)localFieldDesc.columnDescs.get(n);
            QueryTable queryTable = this.findQueryTable(columnElement.getDeclaringTable());
            if (queryTable == null) {
                queryTable = this.addQueryTable(columnElement.getDeclaringTable(), null);
            }
            if ((selectStatement = (SelectStatement)this.getStatement(queryTable)) == null) {
                selectStatement = (SelectStatement)this.addStatement(queryTable);
            }
            if (bl) {
                ColumnRef columnRef = selectStatement.addColumn(columnElement, queryTable);
                if (this.resultDesc == null) {
                    this.resultDesc = this.newResultDesc();
                }
                this.resultDesc.addField(localFieldDesc, columnRef, bl2);
            }
            ++n;
        }
    }

    private void processJoinTable(ClassDesc classDesc) {
        ColumnElement columnElement = (ColumnElement)this.parentField.assocLocalColumns.get(0);
        this.addQueryTable(columnElement.getDeclaringTable(), classDesc);
        ConstraintJoin constraintJoin = new ConstraintJoin();
        constraintJoin.operation = 10;
        constraintJoin.fromColumns = this.parentField.assocForeignColumns;
        constraintJoin.fromPlan = this;
        constraintJoin.toColumns = this.parentField.foreignColumns;
        constraintJoin.toPlan = this;
        this.constraint.stack.add(constraintJoin);
    }

    private void processForeignFields(ArrayList arrayList, ArrayList arrayList2) {
        if (arrayList.size() == 0) {
            return;
        }
        boolean bl = logger.isLoggable(300);
        if (bl) {
            logger.finest("sqlstore.sql.generator.selectqueryplan.processforeignfield", this.config.getPersistenceCapableClass().getName());
        }
        this.foreignPlans = new ArrayList();
        int n = 0;
        while (n < arrayList.size()) {
            ConstraintFieldName constraintFieldName = (ConstraintFieldName)arrayList.get(n);
            SelectQueryPlan selectQueryPlan = new SelectQueryPlan(constraintFieldName.desc, this.store, this.concurrency, this.maxFetchDepth, this.fetchDepth + 1, constraintFieldName.isProjection());
            selectQueryPlan.parentField = (ForeignFieldDesc)this.config.getField(constraintFieldName.name);
            if (selectQueryPlan.parentField == null) {
                throw new JDOFatalInternalException(I18NHelper.getMessage(QueryPlan.messages, "core.constraint.unknownfield", constraintFieldName.name, this.config.getPersistenceCapableClass().getName()));
            }
            selectQueryPlan.build();
            if (selectQueryPlan.parentField.useJoinTable()) {
                selectQueryPlan.processJoinTable(this.config);
            }
            int n2 = 0;
            while (n2 < selectQueryPlan.parentField.localFields.size()) {
                FieldDesc fieldDesc = (FieldDesc)selectQueryPlan.parentField.localFields.get(n2);
                if (!this.getFieldMask(fieldDesc.absoluteID)) {
                    arrayList2.add(fieldDesc);
                }
                ++n2;
            }
            this.foreignPlans.add(selectQueryPlan);
            ++n;
        }
        if (bl) {
            logger.finest("sqlstore.sql.generator.selectqueryplan.processforeignfield.exit");
        }
    }

    private boolean getGroupMask(int n) {
        if (n >= 1) {
            return this.hierarchicalGroupMask.get(n);
        }
        if (n < 0) {
            return this.independentGroupMask.get(-(n + 1));
        }
        return true;
    }

    private void setGroupMask(int n) {
        if (n >= 1) {
            this.hierarchicalGroupMask.set(n);
        } else if (n < 0) {
            this.independentGroupMask.set(-(n + 1));
        }
    }

    private void addFetchGroup(int n, ArrayList arrayList, ArrayList arrayList2) {
        ArrayList arrayList3 = this.config.getFetchGroup(n);
        this.setGroupMask(n);
        if (arrayList3 != null) {
            int n2 = arrayList3.size() - 1;
            while (n2 >= 0) {
                FieldDesc fieldDesc = (FieldDesc)arrayList3.get(n2);
                if (!this.getFieldMask(fieldDesc.absoluteID)) {
                    this.setFieldMask(fieldDesc.absoluteID);
                    if (fieldDesc instanceof LocalFieldDesc) {
                        arrayList.add(0, fieldDesc);
                    } else if (this.fetchDepth < this.maxFetchDepth) {
                        ForeignFieldDesc foreignFieldDesc = (ForeignFieldDesc)fieldDesc;
                        RetrieveDesc retrieveDesc = this.store.getRetrieveDesc(foreignFieldDesc.foreignConfig.getPersistenceCapableClass());
                        ConstraintFieldName constraintFieldName = new ConstraintFieldName(foreignFieldDesc.getName(), retrieveDesc);
                        arrayList2.add(constraintFieldName);
                    }
                }
                --n2;
            }
        }
    }

    private void addFetchGroups(int n, ArrayList arrayList, ArrayList arrayList2) {
        if (n >= 1) {
            int n2 = 1;
            while (n2 <= n) {
                if (!this.getGroupMask(n2)) {
                    this.addFetchGroup(n2, arrayList, arrayList2);
                }
                ++n2;
            }
        } else if (n < 0) {
            if (!this.getGroupMask(1)) {
                this.addFetchGroup(1, arrayList, arrayList2);
            }
            if (!this.getGroupMask(n)) {
                this.addFetchGroup(n, arrayList, arrayList2);
            }
        }
    }

    private void processFetchGroups(ArrayList arrayList, ArrayList arrayList2) {
        int n = arrayList.size() + arrayList2.size();
        if (!this.getGroupMask(1)) {
            this.addFetchGroups(1, arrayList, arrayList2);
        }
        if (n > 0) {
            int n2 = 0;
            while (n2 < arrayList.size()) {
                FieldDesc fieldDesc = (FieldDesc)arrayList.get(n2);
                this.setFieldMask(fieldDesc.absoluteID);
                if (fieldDesc.fetchGroup != 0 && !this.getGroupMask(fieldDesc.fetchGroup)) {
                    this.addFetchGroups(fieldDesc.fetchGroup, arrayList, arrayList2);
                }
                ++n2;
            }
            int n3 = 0;
            while (n3 < arrayList2.size()) {
                ConstraintFieldName constraintFieldName = (ConstraintFieldName)arrayList2.get(n3);
                FieldDesc fieldDesc = this.config.getField(constraintFieldName.name);
                this.setFieldMask(fieldDesc.absoluteID);
                if (fieldDesc.fetchGroup != 0 && !this.getGroupMask(fieldDesc.fetchGroup)) {
                    this.addFetchGroups(fieldDesc.fetchGroup, arrayList, arrayList2);
                }
                ++n3;
            }
        }
    }

    private void processLocalFields(ArrayList arrayList) {
        boolean bl = logger.isLoggable(300);
        if (bl) {
            logger.finest("sqlstore.sql.generator.selectqueryplan.processlocalfield", this.config.getPersistenceCapableClass().getName());
        }
        int n = 0;
        while (n < arrayList.size()) {
            LocalFieldDesc localFieldDesc = (LocalFieldDesc)arrayList.get(n);
            boolean bl2 = this.projectionId != -1 && this.projectionId == n;
            this.addColumn(localFieldDesc, true, bl2);
            ++n;
        }
        if (bl) {
            logger.finest("sqlstore.sql.generator.selectqueryplan.processlocalfield.exit");
        }
    }

    private void addJoinConstraint(ReferenceKeyDesc referenceKeyDesc, int n) {
        ConstraintJoin constraintJoin = new ConstraintJoin();
        constraintJoin.operation = n;
        constraintJoin.fromColumns = referenceKeyDesc.getReferencedKey().getColumns();
        constraintJoin.fromPlan = this;
        constraintJoin.toColumns = referenceKeyDesc.getReferencingKey().getColumns();
        constraintJoin.toPlan = this;
        this.constraint.stack.add(constraintJoin);
    }

    private void joinSubtableStatement(SelectStatement selectStatement, SelectStatement selectStatement2) {
        selectStatement.copyColumns(selectStatement2);
        QueryTable queryTable = (QueryTable)selectStatement2.getQueryTables().get(0);
        ReferenceKeyDesc referenceKeyDesc = queryTable.getTableDesc().getSupertableKey();
        int n = 16;
        if (selectStatement.isSupertable()) {
            n = 10;
        }
        this.addJoinConstraint(referenceKeyDesc, n);
        selectStatement2.setProperty(SelectStatement.PROP_JOINED);
    }

    private void joinSecondaryTableStatement(SelectStatement selectStatement, SelectStatement selectStatement2) {
        selectStatement.copyColumns(selectStatement2);
        QueryTable queryTable = (QueryTable)selectStatement2.getQueryTables().get(0);
        ReferenceKeyDesc referenceKeyDesc = queryTable.getTableDesc().getPrimaryTableKey();
        this.addJoinConstraint(referenceKeyDesc, 16);
        selectStatement2.setProperty(SelectStatement.PROP_JOINED);
    }

    private void processRelatedStatements(SelectStatement selectStatement) {
        ArrayList arrayList;
        ArrayList arrayList2 = selectStatement.getSubtableStatements();
        if (arrayList2 != null) {
            int n = 0;
            while (n < arrayList2.size()) {
                SelectStatement selectStatement2 = (SelectStatement)arrayList2.get(n);
                if (!selectStatement2.isJoined()) {
                    this.processRelatedStatements(selectStatement2);
                    this.joinSubtableStatement(selectStatement, selectStatement2);
                }
                ++n;
            }
            arrayList2.clear();
        }
        if ((arrayList = selectStatement.getSecondaryTableStatements()) != null) {
            int n = 0;
            while (n < arrayList.size()) {
                SelectStatement selectStatement3 = (SelectStatement)arrayList.get(n);
                if (!selectStatement3.isJoined()) {
                    this.processRelatedStatements(selectStatement3);
                    this.joinSecondaryTableStatement(selectStatement, selectStatement3);
                }
                ++n;
            }
            arrayList.clear();
        }
    }

    protected void processStatements() {
        int n;
        boolean bl = logger.isLoggable(300);
        if (bl) {
            Object[] objectArray = new Object[]{this.config.getPersistenceCapableClass().getName(), new Integer(this.statements.size())};
            logger.finest("sqlstore.sql.generator.selectqueryplan.processstmts", objectArray);
        }
        if (this.concurrency != null) {
            this.concurrency.select(this);
        }
        if ((n = this.statements.size()) > 1) {
            super.processStatements();
            int n2 = 0;
            while (n2 < n) {
                SelectStatement selectStatement = (SelectStatement)this.statements.get(n2);
                if (!selectStatement.isJoined()) {
                    this.processRelatedStatements(selectStatement);
                }
                ++n2;
            }
            int n3 = 0;
            while (n3 < this.statements.size()) {
                SelectStatement selectStatement = (SelectStatement)this.statements.get(n3);
                if (selectStatement.isJoined()) {
                    this.statements.remove(n3);
                    --n3;
                }
                ++n3;
            }
        }
        if (bl) {
            logger.finest("sqlstore.sql.generator.selectqueryplan.processstmts.exit");
        }
    }

    private void processLocalConstraints() {
        int n = 0;
        while (n < this.constraint.stack.size()) {
            ConstraintNode constraintNode = (ConstraintNode)this.constraint.stack.get(n);
            if (constraintNode instanceof ConstraintFieldName) {
                Object object;
                ConstraintFieldName constraintFieldName = (ConstraintFieldName)constraintNode;
                SelectQueryPlan selectQueryPlan = null;
                if (constraintFieldName.desc == null) {
                    selectQueryPlan = this;
                } else {
                    object = (RetrieveDescImpl)constraintFieldName.desc;
                    selectQueryPlan = this.newForeignConstraintPlan((RetrieveDescImpl)object, null);
                }
                if (constraintFieldName.originalPlan == null) {
                    constraintFieldName.originalPlan = selectQueryPlan;
                    if (constraintFieldName.name != null && (object = selectQueryPlan.config.getField(constraintFieldName.name)) instanceof LocalFieldDesc) {
                        selectQueryPlan.addColumn((LocalFieldDesc)object, false);
                    }
                }
            }
            ++n;
        }
    }

    private SelectQueryPlan newForeignConstraintPlan(RetrieveDescImpl retrieveDescImpl, String string) {
        SelectQueryPlan selectQueryPlan = retrieveDescImpl.plan;
        if (selectQueryPlan == null) {
            selectQueryPlan = new SelectQueryPlan(retrieveDescImpl, this.store, null);
        }
        if (string == null) {
            return selectQueryPlan;
        }
        if (this.foreignConstraintPlans == null) {
            this.foreignConstraintPlans = new Hashtable();
        }
        SelectQueryPlan selectQueryPlan2 = null;
        Object object = retrieveDescImpl.getNavigationalId() != null ? retrieveDescImpl.getNavigationalId() : string;
        selectQueryPlan2 = (SelectQueryPlan)this.foreignConstraintPlans.get(object);
        if (selectQueryPlan2 != null) {
            selectQueryPlan.tables = selectQueryPlan2.tables;
            selectQueryPlan.foreignConstraintPlans = selectQueryPlan2.foreignConstraintPlans;
        } else {
            this.foreignConstraintPlans.put(object, selectQueryPlan);
            selectQueryPlan.foreignConstraintPlans = new Hashtable();
        }
        return selectQueryPlan;
    }

    private void buildForeignConstraint() {
        if ((this.status & 0x20) > 0 || (this.status & 0x40) > 0) {
            return;
        }
        this.status |= 0x40;
        this.processLocalConstraints();
        this.processStatements();
        this.processForeignConstraints();
        if (this.parentField == null) {
            this.processHybridConstraints();
        }
        this.status = (this.status | 0x20) & 0xFFFFFFBF;
    }

    private void addSubqueryConstraint(ForeignFieldDesc foreignFieldDesc, int n) {
        RetrieveDescImpl retrieveDescImpl = null;
        retrieveDescImpl = foreignFieldDesc.cardinalityUPB > 1 ? (RetrieveDescImpl)this.store.getRetrieveDesc(foreignFieldDesc.getComponentType()) : (RetrieveDescImpl)this.store.getRetrieveDesc(foreignFieldDesc.getType());
        SelectQueryPlan selectQueryPlan = new SelectQueryPlan(retrieveDescImpl, this.store, null);
        ConstraintSubquery constraintSubquery = new ConstraintSubquery();
        constraintSubquery.operation = n;
        constraintSubquery.plan = selectQueryPlan;
        selectQueryPlan.isSubQueryPlan = true;
        LocalFieldDesc localFieldDesc = (LocalFieldDesc)foreignFieldDesc.foreignFields.get(0);
        selectQueryPlan.addColumn(localFieldDesc, true);
        selectQueryPlan.build();
        ArrayList arrayList = null;
        ArrayList arrayList2 = null;
        boolean bl = false;
        bl = foreignFieldDesc.useJoinTable();
        if (bl) {
            selectQueryPlan.parentField = foreignFieldDesc;
            selectQueryPlan.processJoinTable(this.config);
            arrayList = foreignFieldDesc.localFields;
            arrayList2 = foreignFieldDesc.assocLocalFields;
        } else {
            arrayList = foreignFieldDesc.localFields;
            arrayList2 = foreignFieldDesc.foreignFields;
        }
        int n2 = 0;
        while (n2 < arrayList.size()) {
            LocalFieldDesc localFieldDesc2 = (LocalFieldDesc)arrayList.get(n2);
            LocalFieldDesc localFieldDesc3 = (LocalFieldDesc)arrayList2.get(n2);
            ConstraintFieldDesc constraintFieldDesc = new ConstraintFieldDesc(localFieldDesc2, this, 0);
            ConstraintFieldDesc constraintFieldDesc2 = new ConstraintFieldDesc(localFieldDesc3, selectQueryPlan, 0);
            retrieveDescImpl.constraint.addField(constraintFieldDesc);
            retrieveDescImpl.constraint.addField(constraintFieldDesc2);
            retrieveDescImpl.constraint.addOperation(9);
            if (!bl) {
                selectQueryPlan.addColumn(localFieldDesc3, false);
            }
            ++n2;
        }
        selectQueryPlan.processStatements();
        selectQueryPlan.parentConstraintsAdded = true;
        this.addQueryTables(selectQueryPlan.tables);
        this.constraint.stack.add(constraintSubquery);
    }

    private void processForeignConstraints() {
        ArrayList arrayList = this.constraint.stack;
        this.constraint.stack = new ArrayList();
        int n = 0;
        while (n < arrayList.size()) {
            ConstraintNode constraintNode = (ConstraintNode)arrayList.get(n);
            if (constraintNode instanceof ConstraintForeignFieldName) {
                this.processForeignFieldConstraint((ConstraintForeignFieldName)constraintNode);
            } else if (constraintNode instanceof ConstraintFieldName) {
                n = this.processLocalFieldConstraint((ConstraintFieldName)constraintNode, arrayList, n);
            } else if (constraintNode instanceof ConstraintFieldNameSubQuery) {
                this.processSubQueryConstraint((ConstraintFieldNameSubQuery)constraintNode);
            } else {
                this.constraint.stack.add(constraintNode);
            }
            ++n;
        }
    }

    private void processForeignFieldConstraint(ConstraintForeignFieldName constraintForeignFieldName) {
        RetrieveDescImpl retrieveDescImpl = (RetrieveDescImpl)constraintForeignFieldName.desc;
        if (retrieveDescImpl == null) {
            throw new JDOFatalInternalException(I18NHelper.getMessage(QueryPlan.messages, "sqlstore.constraint.noretrievedesc", constraintForeignFieldName.name, this.config.getPersistenceCapableClass().getName()));
        }
        SelectQueryPlan selectQueryPlan = this.newForeignConstraintPlan(retrieveDescImpl, constraintForeignFieldName.name);
        if ((selectQueryPlan.status & 4) == 0) {
            selectQueryPlan.addParentField(this.config, constraintForeignFieldName.name);
            this.processJoin(selectQueryPlan, 10);
            selectQueryPlan.appendAndOp = true;
        } else {
            selectQueryPlan.appendAndOp = false;
        }
    }

    private int processLocalFieldConstraint(ConstraintFieldName constraintFieldName, ArrayList arrayList, int n) {
        FieldDesc fieldDesc;
        FieldDesc fieldDesc2 = fieldDesc = constraintFieldName.name != null ? this.config.getField(constraintFieldName.name) : null;
        if (constraintFieldName.desc != null) {
            SelectQueryPlan selectQueryPlan = ((RetrieveDescImpl)constraintFieldName.desc).plan;
            this.constraint.stack.add(constraintFieldName);
            if ((selectQueryPlan.status & 4) == 0) {
                selectQueryPlan.appendAndOp = true;
            } else {
                this.constraint.stack.add(arrayList.get(++n));
                this.constraint.stack.add(arrayList.get(++n));
                if (selectQueryPlan.appendAndOp) {
                    ConstraintOperation constraintOperation = new ConstraintOperation();
                    constraintOperation.operation = 3;
                    this.constraint.stack.add(constraintOperation);
                }
            }
        } else if (fieldDesc != null && fieldDesc instanceof ForeignFieldDesc && n + 1 < arrayList.size()) {
            ConstraintNode constraintNode;
            if ((constraintNode = (ConstraintNode)arrayList.get(++n)) instanceof ConstraintOperation && (((ConstraintOperation)constraintNode).operation == 28 || ((ConstraintOperation)constraintNode).operation == 27)) {
                ForeignFieldDesc foreignFieldDesc = (ForeignFieldDesc)fieldDesc;
                if ((foreignFieldDesc.sqlProperties & 0x40) > 0) {
                    ArrayList arrayList2 = foreignFieldDesc.getLocalFields();
                    int n2 = 0;
                    while (n2 < arrayList2.size()) {
                        this.constraint.stack.add(new ConstraintFieldDesc((LocalFieldDesc)arrayList2.get(n2)));
                        this.constraint.stack.add(constraintNode);
                        ++n2;
                    }
                } else {
                    int n3 = 45;
                    if (((ConstraintOperation)constraintNode).operation == 27) {
                        n3 = 46;
                    }
                    this.addSubqueryConstraint(foreignFieldDesc, n3);
                }
            } else {
                this.constraint.stack.add(constraintFieldName);
                this.constraint.stack.add(constraintNode);
            }
        } else {
            this.constraint.stack.add(constraintFieldName);
        }
        return n;
    }

    private void processSubQueryConstraint(ConstraintFieldNameSubQuery constraintFieldNameSubQuery) {
        FieldDesc fieldDesc = this.config.getField(constraintFieldNameSubQuery.fieldName);
        RetrieveDescImpl retrieveDescImpl = (RetrieveDescImpl)constraintFieldNameSubQuery.desc;
        if (fieldDesc != null && fieldDesc instanceof ForeignFieldDesc) {
            ForeignFieldDesc foreignFieldDesc = (ForeignFieldDesc)fieldDesc;
            if (foreignFieldDesc.getComponentType() != retrieveDescImpl.getPersistenceCapableClass()) {
                throw new JDOFatalInternalException(I18NHelper.getMessage(QueryPlan.messages, "core.constraint.unknownfield", constraintFieldNameSubQuery.fieldName, retrieveDescImpl.getPersistenceCapableClass().getName()));
            }
            SelectQueryPlan selectQueryPlan = retrieveDescImpl.plan;
            if (selectQueryPlan == null) {
                selectQueryPlan = new SelectQueryPlan(retrieveDescImpl, this.store, null);
            }
            selectQueryPlan.isSubQueryPlan = true;
            selectQueryPlan.processSubQueryPlan(foreignFieldDesc);
            this.addQueryTables(selectQueryPlan.tables);
            ConstraintSubquery constraintSubquery = new ConstraintSubquery();
            constraintSubquery.plan = selectQueryPlan;
            this.constraint.stack.add(constraintSubquery);
            ArrayList arrayList = foreignFieldDesc.getLocalFields();
            int n = 0;
            while (n < arrayList.size()) {
                this.constraint.addField((LocalFieldDesc)arrayList.get(n), this);
                ++n;
            }
        } else {
            throw new JDOFatalInternalException(I18NHelper.getMessage(QueryPlan.messages, "core.constraint.unknownfield", constraintFieldNameSubQuery.fieldName, retrieveDescImpl.getPersistenceCapableClass().getName()));
        }
    }

    private void processSubQueryPlan(ForeignFieldDesc foreignFieldDesc) {
        ArrayList arrayList = null;
        boolean bl = foreignFieldDesc.useJoinTable();
        arrayList = bl ? foreignFieldDesc.getAssocLocalFields() : foreignFieldDesc.getForeignFields();
        int n = 0;
        while (n < arrayList.size()) {
            this.addColumn((LocalFieldDesc)arrayList.get(n), true);
            ++n;
        }
        if (bl) {
            ConstraintJoin constraintJoin = new ConstraintJoin();
            constraintJoin.operation = 10;
            constraintJoin.fromColumns = foreignFieldDesc.foreignColumns;
            constraintJoin.fromPlan = this;
            constraintJoin.toColumns = foreignFieldDesc.assocForeignColumns;
            constraintJoin.toPlan = this;
            this.constraint.stack.add(constraintJoin);
            ArrayList arrayList2 = foreignFieldDesc.getForeignFields();
            int n2 = 0;
            while (n2 < arrayList2.size()) {
                this.addColumn((LocalFieldDesc)arrayList2.get(n2), false);
                ++n2;
            }
        }
        this.build();
    }

    private void processHybridConstraints() {
        ArrayList arrayList = this.constraint.stack;
        this.constraint.stack = new ArrayList();
        int n = 0;
        while (n < arrayList.size()) {
            ConstraintNode constraintNode = (ConstraintNode)arrayList.get(n);
            if (constraintNode instanceof ConstraintFieldName) {
                ConstraintFieldName constraintFieldName = (ConstraintFieldName)constraintNode;
                boolean bl = constraintFieldName.name != null;
                if (bl) {
                    this.constraint.stack.add(constraintFieldName);
                }
                if (constraintFieldName.desc != null) {
                    SelectQueryPlan selectQueryPlan = ((RetrieveDescImpl)constraintFieldName.desc).plan;
                    if (bl) {
                        this.constraint.stack.add(arrayList.get(++n));
                        this.constraint.stack.add(arrayList.get(++n));
                    }
                    if (!((selectQueryPlan.status & 0x40) != 0 || this.foreignPlans != null && this.foreignPlans.contains(selectQueryPlan) || (selectQueryPlan.status & 4) != 0)) {
                        this.processJoin(selectQueryPlan, 52);
                    }
                }
            } else {
                this.constraint.stack.add(constraintNode);
            }
            ++n;
        }
    }

    private void processJoin(SelectQueryPlan selectQueryPlan, int n) {
        selectQueryPlan.buildForeignConstraint();
        this.doJoin(selectQueryPlan, n);
        if (n != 52) {
            selectQueryPlan.removeOrderConstraints();
            if (!selectQueryPlan.constraint.stack.isEmpty() || selectQueryPlan.appendAndOp) {
                ConstraintOperation constraintOperation = new ConstraintOperation();
                constraintOperation.operation = 3;
                this.constraint.stack.add(constraintOperation);
            }
        }
    }

    private void addParentField(ClassDesc classDesc, String string) {
        FieldDesc fieldDesc = classDesc.getField(string);
        if (fieldDesc == null || !(fieldDesc instanceof ForeignFieldDesc)) {
            throw new JDOFatalInternalException(I18NHelper.getMessage(QueryPlan.messages, "core.constraint.unknownfield", string, classDesc.getPersistenceCapableClass().getName()));
        }
        this.parentField = (ForeignFieldDesc)fieldDesc;
        int n = 0;
        while (n < this.parentField.foreignFields.size()) {
            LocalFieldDesc localFieldDesc = (LocalFieldDesc)this.parentField.foreignFields.get(n);
            this.addColumn(localFieldDesc, false);
            ++n;
        }
        if (this.parentField.useJoinTable()) {
            this.processJoinTable(classDesc);
        }
    }

    public void build() {
        Object object;
        Object object2 = null;
        if ((this.status & 1) > 0 || (this.status & 0x40) > 0) {
            return;
        }
        this.status |= 0x40;
        ArrayList<ConstraintFieldName> arrayList = new ArrayList<ConstraintFieldName>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        int n = 0;
        while (n < this.retrieveDesc.fields.size()) {
            ConstraintFieldName constraintFieldName = (ConstraintFieldName)this.retrieveDesc.fields.get(n);
            object = this.config.getField(constraintFieldName.name);
            if (object == null) {
                throw new JDOFatalInternalException(I18NHelper.getMessage(QueryPlan.messages, "core.constraint.unknownfield", constraintFieldName.name, this.config.getPersistenceCapableClass().getName()));
            }
            this.setFieldMask(((FieldDesc)object).absoluteID);
            if (constraintFieldName.desc != null) {
                arrayList.add(constraintFieldName);
            } else {
                arrayList2.add(object);
                if (constraintFieldName.isProjection()) {
                    object2 = object;
                }
            }
            ++n;
        }
        if (!this.isSubQueryPlan) {
            this.processFetchGroups(arrayList2, arrayList);
            if (object2 != null) {
                this.projectionId = arrayList2.indexOf(object2);
            }
        }
        this.buildSuperclass();
        int n2 = 0;
        while (n2 < this.statements.size()) {
            object = (SelectStatement)this.statements.get(n2);
            ((Statement)object).setProperty(SelectStatement.PROP_IS_SUPERTABLE);
            ++n2;
        }
        this.processForeignFields(arrayList, arrayList2);
        this.processLocalFields(arrayList2);
        this.processGlobalConstraints();
        this.processLocalConstraints();
        this.buildSubclasses();
        this.processStatements();
        this.processForeignConstraints();
        this.processHybridConstraints();
        this.status = (this.status | 1) & 0xFFFFFFBF;
    }

    private void processFields() {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        this.fieldMask = new BitSet();
        int n = 0;
        while (n < this.hierarchicalGroupMask.length()) {
            this.addFetchGroup(n, arrayList, arrayList2);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.independentGroupMask.length()) {
            this.addFetchGroup(-(n2 + 1), arrayList, arrayList2);
            ++n2;
        }
        this.processForeignFields(arrayList2, arrayList);
        this.processLocalFields(arrayList);
    }

    private ResultDesc newResultDesc() {
        ResultDesc resultDesc = new ResultDesc();
        resultDesc.setClassDesc(this.config);
        resultDesc.setProjection(this.projection);
        return resultDesc;
    }

    private void addVerticalDiscriminatorConstraint(boolean bl) {
        LocalFieldDesc localFieldDesc = this.config.getVerticalDiscriminatorField();
        if (localFieldDesc != null) {
            if (bl) {
                this.addColumn(localFieldDesc, true);
            }
            this.constraint.addField(localFieldDesc);
            this.constraint.addOperation(28);
        }
    }

    private void addHorizontalDiscriminatorConstraint(boolean bl) {
        ArrayList arrayList = this.config.getHorizontalDiscriminatorFields();
        if (arrayList != null) {
            int n = 0;
            while (n < arrayList.size()) {
                LocalFieldDesc localFieldDesc = (LocalFieldDesc)arrayList.get(n);
                if (bl) {
                    this.addColumn(localFieldDesc, true);
                }
                this.constraint.addValue(localFieldDesc.getDiscriminatorValue());
                this.constraint.addField(localFieldDesc);
                this.constraint.addOperation(25);
                ++n;
            }
        }
    }

    private void buildSuperclass() {
        ClassDesc classDesc = this.config.getSuperclassConfig();
        if (classDesc == null) {
            return;
        }
        ClassDesc classDesc2 = this.config;
        ResultDesc resultDesc = this.resultDesc;
        this.config = classDesc;
        this.resultDesc = this.newResultDesc();
        resultDesc.setSuperclassResultDesc(this.resultDesc);
        this.buildSuperclass();
        this.processFields();
        this.addHorizontalDiscriminatorConstraint(false);
        this.config = classDesc2;
        this.resultDesc = resultDesc;
    }

    private void buildSubclasses() {
        ArrayList arrayList = this.config.getSubclassConfigs();
        if (arrayList == null) {
            return;
        }
        ClassDesc classDesc = this.config;
        ResultDesc resultDesc = this.resultDesc;
        int n = 0;
        while (n < arrayList.size()) {
            this.config = (ClassDesc)arrayList.get(n);
            this.resultDesc = this.newResultDesc();
            this.resultDesc.setSuperclassResultDesc(resultDesc);
            if (!excludeSubclasses) {
                this.processFields();
            } else {
                this.addVerticalDiscriminatorConstraint(true);
                this.addHorizontalDiscriminatorConstraint(true);
            }
            this.buildSubclasses();
            ++n;
        }
        this.config = classDesc;
        this.resultDesc = resultDesc;
    }

    private void doJoin(SelectQueryPlan selectQueryPlan, int n) {
        if ((selectQueryPlan.status & 4) > 0) {
            return;
        }
        SelectStatement selectStatement = (SelectStatement)this.statements.get(0);
        SelectStatement selectStatement2 = (SelectStatement)selectQueryPlan.statements.get(0);
        if (!selectQueryPlan.isSubQueryPlan) {
            selectStatement.copyColumns(selectStatement2);
            this.addQueryTables(selectQueryPlan.tables);
            ResultDesc resultDesc = selectQueryPlan.resultDesc;
            if (this.resultDesc != null && resultDesc != null) {
                this.resultDesc.addField(resultDesc);
                resultDesc.setParentField(selectQueryPlan.parentField);
            }
        }
        this.options |= selectQueryPlan.options;
        if (n == 52) {
            selectStatement.tableList.addAll(selectStatement2.tableList);
        } else {
            this.addJoinConstraint(selectQueryPlan, n);
        }
        this.constraint.stack.addAll(selectQueryPlan.constraint.stack);
        selectQueryPlan.status |= 4;
    }

    private void addJoinConstraint(SelectQueryPlan selectQueryPlan, int n) {
        ConstraintJoin constraintJoin = new ConstraintJoin();
        constraintJoin.operation = n;
        constraintJoin.fromColumns = selectQueryPlan.parentField.localColumns;
        constraintJoin.fromPlan = this;
        constraintJoin.toColumns = selectQueryPlan.parentField.useJoinTable() ? selectQueryPlan.parentField.assocLocalColumns : selectQueryPlan.parentField.foreignColumns;
        constraintJoin.toPlan = selectQueryPlan;
        this.constraint.stack.add(constraintJoin);
    }

    private void copyConstraints(SelectQueryPlan selectQueryPlan, int n) {
        int n2;
        int n3;
        ConstraintNode constraintNode = null;
        if (n == 52 && this.constraint.stack.get(n3 = this.constraint.stack.size() - 1) instanceof ConstraintOperation && (n2 = ((ConstraintOperation)this.constraint.stack.get((int)n3)).operation) == 3) {
            constraintNode = (ConstraintNode)this.constraint.stack.remove(n3);
        }
        this.constraint.stack.addAll(selectQueryPlan.constraint.stack);
        if (constraintNode != null) {
            this.constraint.stack.add(constraintNode);
        }
    }

    private void processGlobalConstraints() {
        if (this.constraint.stack.size() >= 2 && this.constraint.stack.get(1) instanceof ConstraintOperation && ((ConstraintOperation)this.constraint.stack.get((int)1)).operation == 23) {
            ConstraintNode constraintNode = (ConstraintNode)this.constraint.stack.get(0);
            this.constraint.stack.remove(1);
            this.constraint.stack.remove(0);
            if (!(constraintNode instanceof ConstraintValue)) {
                throw new JDOUserException(I18NHelper.getMessage(QueryPlan.messages, "core.constraint.needvalnode", constraintNode.getClass().getName(), "ConstraintValue"));
            }
            this.maxRows = (Integer)((ConstraintValue)constraintNode).value;
        }
    }

    public void processJoins(SelectQueryPlan selectQueryPlan) {
        if (selectQueryPlan == null) {
            selectQueryPlan = this;
        }
        if ((this.status & 4) > 0) {
            return;
        }
        if (selectQueryPlan.foreignPlans == null || selectQueryPlan.foreignPlans.size() == 0) {
            return;
        }
        int n = 0;
        while (n < selectQueryPlan.foreignPlans.size()) {
            SelectQueryPlan selectQueryPlan2 = (SelectQueryPlan)selectQueryPlan.foreignPlans.get(n);
            selectQueryPlan2.processJoins(null);
            ++n;
        }
        if (selectQueryPlan.statements.size() == 1 && (this.options & 0x20) == 0) {
            int n2 = 0;
            while (n2 < selectQueryPlan.foreignPlans.size()) {
                SelectQueryPlan selectQueryPlan3 = (SelectQueryPlan)selectQueryPlan.foreignPlans.get(n2);
                if (selectQueryPlan3.statements.size() == 1 && selectQueryPlan3.parentField.cardinalityUPB == 1 && (selectQueryPlan3.constraint == null || (selectQueryPlan3.options & 0x100) == 0)) {
                    this.doJoin(selectQueryPlan3, 16);
                }
                ++n2;
            }
        }
    }

    private void removeOrderConstraints() {
        int n = 0;
        while (n < this.constraint.stack.size()) {
            ConstraintNode constraintNode = (ConstraintNode)this.constraint.stack.get(n);
            if (constraintNode instanceof ConstraintOperation && (((ConstraintOperation)constraintNode).operation == 30 || ((ConstraintOperation)constraintNode).operation == 31)) {
                if (n > 1 && this.constraint.stack.get(n - 2) instanceof ConstraintValue) {
                    this.constraint.stack.remove(n - 2);
                    --n;
                }
                this.constraint.stack.remove(n);
                this.constraint.stack.remove(n - 1);
                --n;
            }
            ++n;
        }
    }

    public ArrayList processOrderConstraints() {
        if (this.orderBy == null) {
            Object object;
            Object object2;
            int n;
            ArrayList arrayList = new ArrayList();
            int n2 = 0;
            if (this.constraint != null) {
                int n3 = 0;
                while (n3 < this.constraint.stack.size()) {
                    ConstraintNode constraintNode = (ConstraintNode)this.constraint.stack.get(n3);
                    if (constraintNode instanceof ConstraintOperation && (((ConstraintOperation)constraintNode).operation == 30 || ((ConstraintOperation)constraintNode).operation == 31)) {
                        Object object3;
                        int n4 = -1;
                        if (n3 > 1 && this.constraint.stack.get(n3 - 2) instanceof ConstraintValue) {
                            n4 = (Integer)((ConstraintValue)this.constraint.stack.get((int)(n3 - 2))).value;
                            this.constraint.stack.remove(n3 - 2);
                            --n3;
                        }
                        if (n4 > 0) {
                            n2 = n4;
                        }
                        n = arrayList.size();
                        while (n <= n2) {
                            arrayList.add(null);
                            ++n;
                        }
                        if (arrayList.get(n2) == null) {
                            arrayList.set(n2, new ArrayList());
                        }
                        object2 = (ConstraintNode)this.constraint.stack.get(n3 - 1);
                        ConstraintFieldDesc constraintFieldDesc = null;
                        if (object2 instanceof ConstraintFieldName) {
                            object3 = this;
                            if (((ConstraintField)object2).originalPlan != null) {
                                object3 = ((ConstraintField)object2).originalPlan;
                            }
                            if (!((object = ((QueryPlan)object3).config.getField(((ConstraintFieldName)object2).name)) instanceof LocalFieldDesc)) {
                                throw new JDOUserException(I18NHelper.getMessage(QueryPlan.messages, "core.generic.notinstanceof", object.getClass().getName(), "LocalFieldDesc"));
                            }
                            constraintFieldDesc = new ConstraintFieldDesc((LocalFieldDesc)object, (QueryPlan)object3, 1);
                        } else if (object2 instanceof ConstraintFieldDesc) {
                            constraintFieldDesc = (ConstraintFieldDesc)object2;
                        } else {
                            throw new JDOUserException(I18NHelper.getMessage(QueryPlan.messages, "core.generic.notinstanceof", object2.getClass().getName(), "ConstraintFieldName/ConstraintFieldDesc"));
                        }
                        if (((ConstraintOperation)constraintNode).operation == 31) {
                            constraintFieldDesc.ordering = -1;
                        }
                        object3 = (ArrayList)arrayList.get(n2);
                        ((ArrayList)object3).add(constraintFieldDesc);
                        this.constraint.stack.remove(n3);
                        this.constraint.stack.remove(n3 - 1);
                        n3 = n3 - 2 + 1;
                    }
                    ++n3;
                }
            }
            this.orderBy = new ArrayList();
            int n5 = 0;
            n = arrayList.size();
            while (n5 < n) {
                object2 = (ArrayList)arrayList.get(n5);
                if (this.constraint == null) {
                    this.constraint = new Constraint();
                }
                int n6 = 0;
                int n7 = ((ArrayList)object2).size();
                while (n6 < n7) {
                    object = (ConstraintFieldDesc)((ArrayList)object2).get(n6);
                    this.orderBy.add(object);
                    if (((ConstraintFieldDesc)object).ordering < 0) {
                        this.constraint.addField((ConstraintFieldDesc)object);
                        this.constraint.addOperation(31);
                    } else {
                        this.constraint.addField((ConstraintFieldDesc)object);
                        this.constraint.addOperation(30);
                    }
                    ++n6;
                }
                ++n5;
            }
        }
        return this.orderBy;
    }

    protected Statement newStatement() {
        SelectStatement selectStatement = new SelectStatement(this.store.getVendorType(), this);
        selectStatement.constraint = this.constraint;
        return selectStatement;
    }

    static {
        logger = LogHelperSQLStore.getLogger();
    }
}

