/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.query.util.scope;

import com.sun.jdo.spi.persistence.support.sqlstore.query.util.scope.Definition;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.scope.Nesting;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;

public class SymbolTable {
    protected int actualScope = 0;
    protected Stack nestings = new Stack();
    protected Hashtable symbols = new Hashtable();

    public void enterScope() {
        ++this.actualScope;
        this.nestings.push(new Nesting());
    }

    public void leaveScope() {
        this.forgetNesting((Nesting)this.nestings.pop());
        --this.actualScope;
    }

    public int getActualScope() {
        return this.actualScope;
    }

    public Definition declare(String string, Definition definition) {
        Definition definition2 = (Definition)this.symbols.get(string);
        definition.setScope(this.actualScope);
        if (definition2 == null || definition2.getScope() < this.actualScope) {
            Nesting nesting = (Nesting)this.nestings.peek();
            nesting.add(string, definition2);
            this.symbols.put(string, definition);
            return null;
        }
        return definition2;
    }

    public boolean isDeclared(String string) {
        return this.getDefinition(string) != null;
    }

    public Definition getDefinition(String string) {
        return (Definition)this.symbols.get(string);
    }

    protected void forgetNesting(Nesting nesting) {
        String string = null;
        Definition definition = null;
        Iterator iterator = nesting.getIdents();
        Iterator iterator2 = nesting.getHiddenDefinitions();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            definition = (Definition)iterator2.next();
            if (definition == null) {
                this.symbols.remove(string);
                continue;
            }
            this.symbols.put(string, definition);
        }
    }
}

