/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.database.oracle;

import com.sun.jdo.api.persistence.support.FieldMapping;
import com.sun.jdo.spi.persistence.support.sqlstore.LogHelperSQLStore;
import com.sun.jdo.spi.persistence.support.sqlstore.database.BaseSpecialDBOperation;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.EJBHelper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import oracle.jdbc.OraclePreparedStatement;

public class OracleSpecialDBOperation
extends BaseSpecialDBOperation {
    private static Logger logger = LogHelperSQLStore.getLogger();
    boolean canloadOracle9iPStmt = false;
    boolean canloadOracle8iPStmt = false;
    private StatementHandler oracle9iHandler = null;
    private StatementHandler oracle8iHandler = null;
    static /* synthetic */ Class class$com$sun$jdo$spi$persistence$support$sqlstore$database$oracle$OracleSpecialDBOperation;

    public OracleSpecialDBOperation() {
        try {
            this.oracle9iHandler = new StatementHandler(){

                public void defineColumnType(OraclePreparedStatement oraclePreparedStatement, oracle.jdbc.driver.OraclePreparedStatement oraclePreparedStatement2, int n, int n2) throws SQLException {
                    oraclePreparedStatement.defineColumnType(n, n2);
                }

                public void defineColumnType(OraclePreparedStatement oraclePreparedStatement, oracle.jdbc.driver.OraclePreparedStatement oraclePreparedStatement2, int n, int n2, int n3) throws SQLException {
                    oraclePreparedStatement.defineColumnType(n, n2, n3);
                }

                public void clearDefines(OraclePreparedStatement oraclePreparedStatement, oracle.jdbc.driver.OraclePreparedStatement oraclePreparedStatement2) throws SQLException {
                    oraclePreparedStatement.clearDefines();
                }
            };
            this.oracle8iHandler = new StatementHandler(){

                public void defineColumnType(OraclePreparedStatement oraclePreparedStatement, oracle.jdbc.driver.OraclePreparedStatement oraclePreparedStatement2, int n, int n2) throws SQLException {
                    oraclePreparedStatement2.defineColumnType(n, n2);
                }

                public void defineColumnType(OraclePreparedStatement oraclePreparedStatement, oracle.jdbc.driver.OraclePreparedStatement oraclePreparedStatement2, int n, int n2, int n3) throws SQLException {
                    oraclePreparedStatement2.defineColumnType(n, n2, n3);
                }

                public void clearDefines(OraclePreparedStatement oraclePreparedStatement, oracle.jdbc.driver.OraclePreparedStatement oraclePreparedStatement2) throws SQLException {
                    oraclePreparedStatement2.clearDefines();
                }
            };
            ClassLoader classLoader = (class$com$sun$jdo$spi$persistence$support$sqlstore$database$oracle$OracleSpecialDBOperation == null ? (class$com$sun$jdo$spi$persistence$support$sqlstore$database$oracle$OracleSpecialDBOperation = OracleSpecialDBOperation.class$("com.sun.jdo.spi.persistence.support.sqlstore.database.oracle.OracleSpecialDBOperation")) : class$com$sun$jdo$spi$persistence$support$sqlstore$database$oracle$OracleSpecialDBOperation).getClassLoader();
            if (this.loadClass("oracle.jdbc.OraclePreparedStatement", classLoader) != null) {
                this.canloadOracle9iPStmt = true;
            }
            if (this.loadClass("oracle.jdbc.driver.OraclePreparedStatement", classLoader) != null) {
                this.canloadOracle8iPStmt = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (logger.isLoggable(900) && !this.canloadOracle9iPStmt && !this.canloadOracle8iPStmt) {
            logger.info("sqlstore.database.oracle.optimizationdisabled");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void defineColumnTypeForResult(Statement statement, List list) throws SQLException {
        if (!this.canloadOracle9iPStmt && !this.canloadOracle8iPStmt) {
            return;
        }
        int n = list.size();
        if (n == 0) return;
        StatementHandler statementHandler = null;
        OraclePreparedStatement oraclePreparedStatement = null;
        oracle.jdbc.driver.OraclePreparedStatement oraclePreparedStatement2 = null;
        Statement statement2 = EJBHelper.unwrapStatement(statement);
        if (this.canloadOracle9iPStmt) {
            oraclePreparedStatement = this.setupOracle9i(statement2);
            if (oraclePreparedStatement == null) return;
            statementHandler = this.oracle9iHandler;
        } else {
            oraclePreparedStatement2 = this.setupOracle8i(statement2);
            if (oraclePreparedStatement2 == null) return;
            statementHandler = this.oracle8iHandler;
        }
        try {
            int n2 = 0;
            while (n2 < n) {
                FieldMapping fieldMapping = (FieldMapping)list.get(n2);
                int n3 = fieldMapping.getColumnType();
                if (n3 == 1 || n3 == 12) {
                    int n4 = fieldMapping.getColumnLength();
                    if (n4 > 0) {
                        statementHandler.defineColumnType(oraclePreparedStatement, oraclePreparedStatement2, n2 + 1, n3, n4);
                    } else {
                        statementHandler.defineColumnType(oraclePreparedStatement, oraclePreparedStatement2, n2 + 1, n3);
                    }
                } else {
                    statementHandler.defineColumnType(oraclePreparedStatement, oraclePreparedStatement2, n2 + 1, n3);
                }
                ++n2;
            }
            return;
        }
        catch (Exception exception) {
            if (logger.isLoggable(800)) {
                logger.log(800, "sqlstore.database.oracle.defineCol", exception);
            }
            statementHandler.clearDefines(oraclePreparedStatement, oraclePreparedStatement2);
        }
    }

    private Class loadClass(String string, ClassLoader classLoader) {
        final ClassLoader classLoader2 = classLoader;
        final String string2 = string;
        return (Class)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    if (classLoader2 != null) {
                        return Class.forName(string2, true, classLoader2);
                    }
                    return Class.forName(string2);
                }
                catch (Exception exception) {
                    return null;
                }
            }
        });
    }

    private OraclePreparedStatement setupOracle9i(Statement statement) {
        try {
            return (OraclePreparedStatement)statement;
        }
        catch (ClassCastException classCastException) {
            if (logger.isLoggable(900)) {
                logger.log(900, "sqlstore.database.oracle.castpstmt", statement.getClass().getName());
            }
            return null;
        }
    }

    private oracle.jdbc.driver.OraclePreparedStatement setupOracle8i(Statement statement) {
        try {
            return (oracle.jdbc.driver.OraclePreparedStatement)statement;
        }
        catch (ClassCastException classCastException) {
            if (logger.isLoggable(900)) {
                logger.log(900, "sqlstore.database.oracle.castpstmt", statement.getClass().getName());
            }
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static interface StatementHandler {
        public void defineColumnType(OraclePreparedStatement var1, oracle.jdbc.driver.OraclePreparedStatement var2, int var3, int var4) throws SQLException;

        public void defineColumnType(OraclePreparedStatement var1, oracle.jdbc.driver.OraclePreparedStatement var2, int var3, int var4, int var5) throws SQLException;

        public void clearDefines(OraclePreparedStatement var1, oracle.jdbc.driver.OraclePreparedStatement var2) throws SQLException;
    }
}

