/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.ejb.cmp;

import com.sun.jdo.api.persistence.support.JDOFatalDataStoreException;
import com.sun.jdo.api.persistence.support.JDOHelper;
import com.sun.jdo.api.persistence.support.JDOObjectNotFoundException;
import com.sun.jdo.api.persistence.support.JDOUserException;
import com.sun.jdo.api.persistence.support.PersistenceManager;
import com.sun.jdo.spi.persistence.support.ejb.cmp.LogHelperEntityInternal;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.CMPHelper;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.JDOEJB11Helper;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import javax.ejb.EJBException;
import javax.ejb.EJBObject;

public abstract class JDOEJB11HelperImpl
implements JDOEJB11Helper {
    protected static final ResourceBundle messages = I18NHelper.loadBundle(class$com$sun$jdo$spi$persistence$support$ejb$cmp$JDOEJB11HelperImpl == null ? (class$com$sun$jdo$spi$persistence$support$ejb$cmp$JDOEJB11HelperImpl = JDOEJB11HelperImpl.class$("com.sun.jdo.spi.persistence.support.ejb.cmp.JDOEJB11HelperImpl")) : class$com$sun$jdo$spi$persistence$support$ejb$cmp$JDOEJB11HelperImpl);
    protected static Logger logger = LogHelperEntityInternal.getLogger();
    static /* synthetic */ Class class$com$sun$jdo$spi$persistence$support$ejb$cmp$JDOEJB11HelperImpl;

    public EJBObject convertPCToEJBObject(Object object, PersistenceManager persistenceManager) {
        if (object == null) {
            return null;
        }
        Object object2 = persistenceManager.getObjectId(object);
        Object object3 = this.convertObjectIdToPrimaryKey(object2);
        try {
            return CMPHelper.getEJBObject(object3, this.getContainer());
        }
        catch (Exception exception) {
            EJBException eJBException = new EJBException(I18NHelper.getMessage(messages, "EXC_ConvertPCToEJBObject", object3.toString()), exception);
            logger.throwing("JDOEJB11HelperImpl", "convertPCToEJBObject", (Throwable)eJBException);
            throw eJBException;
        }
    }

    public Object convertEJBObjectToPC(EJBObject eJBObject, PersistenceManager persistenceManager, boolean bl) {
        Object object = null;
        try {
            object = eJBObject.getPrimaryKey();
        }
        catch (Exception exception) {
            EJBException eJBException = new EJBException(I18NHelper.getMessage(messages, "EXC_ConvertEJBObjectToPC", eJBObject.getClass().getName()), exception);
            logger.throwing("JDOEJB11HelperImpl", "convertEJBObjectToPC", (Throwable)eJBException);
            throw eJBException;
        }
        return this.convertPrimaryKeyToPC(object, persistenceManager, bl);
    }

    protected Object convertPrimaryKeyToPC(Object object, PersistenceManager persistenceManager, boolean bl) {
        Object object2 = null;
        try {
            Object object3 = this.convertPrimaryKeyToObjectId(object);
            object2 = persistenceManager.getObjectById(object3, bl);
        }
        catch (JDOObjectNotFoundException jDOObjectNotFoundException) {
            logger.fine("---JDOEJB11HelperImpl.convertPrimaryKeyToPC: Object not found for: " + object);
            throw new IllegalArgumentException(I18NHelper.getMessage(messages, "EXC_DeletedInstanceOtherTx", object.toString()));
        }
        if (bl && JDOHelper.isDeleted(object2)) {
            logger.fine("---JDOEJB11HelperImpl.convertPrimaryKeyToPC: Object is deleted for: " + object);
            throw new IllegalArgumentException(I18NHelper.getMessage(messages, "EXC_DeletedInstanceThisTx", object.toString()));
        }
        return object2;
    }

    public Collection convertCollectionPCToEJBObject(Collection collection, PersistenceManager persistenceManager) {
        ArrayList<EJBObject> arrayList = new ArrayList<EJBObject>();
        EJBObject eJBObject = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            eJBObject = this.convertPCToEJBObject(iterator.next(), persistenceManager);
            if (logger.isLoggable(300)) {
                logger.finest("\n---JDOEJB11HelperImpl.convertCollectionPCToEJBObject() adding: " + eJBObject);
            }
            arrayList.add(eJBObject);
        }
        return arrayList;
    }

    public Set convertCollectionPCToEJBObjectSet(Collection collection, PersistenceManager persistenceManager) {
        HashSet<EJBObject> hashSet = new HashSet<EJBObject>();
        EJBObject eJBObject = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            eJBObject = this.convertPCToEJBObject(iterator.next(), persistenceManager);
            if (logger.isLoggable(300)) {
                logger.finest("\n---JDOEJB11HelperImpl.convertCollectionPCToEJBObjectSet() adding: " + eJBObject);
            }
            hashSet.add(eJBObject);
        }
        return hashSet;
    }

    public Collection convertCollectionEJBObjectToPC(Collection collection, PersistenceManager persistenceManager, boolean bl) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            object = this.convertEJBObjectToPC((EJBObject)iterator.next(), persistenceManager, bl);
            if (logger.isLoggable(300)) {
                logger.finest("\n---JDOEJB11HelperImpl.convertCollectionEJBObjectToPC() adding: " + object);
            }
            arrayList.add(object);
        }
        return arrayList;
    }

    public Object convertPCToPrimaryKey(Object object, PersistenceManager persistenceManager) {
        Object object2 = this.convertObjectIdToPrimaryKey(persistenceManager.getObjectId(object));
        if (logger.isLoggable(300)) {
            logger.finest("\n---JDOEJB11HelperImpl.convertPCToPrimaryKey() PK: " + object2);
        }
        return object2;
    }

    public Collection convertCollectionPCToPrimaryKey(Collection collection, PersistenceManager persistenceManager) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            object = this.convertPCToPrimaryKey(iterator.next(), persistenceManager);
            if (logger.isLoggable(300)) {
                logger.finest("\n---JDOEJB11HelperImpl.convertCollectionPCToPrimaryKey() adding: " + object);
            }
            arrayList.add(object);
        }
        return arrayList;
    }

    public abstract Object convertObjectIdToPrimaryKey(Object var1);

    public abstract Object convertPrimaryKeyToObjectId(Object var1);

    public Collection convertCollectionObjectIdToPrimaryKey(Collection collection) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            object = this.convertObjectIdToPrimaryKey(iterator.next());
            if (logger.isLoggable(300)) {
                logger.finest("\n---JDOEJB11HelperImpl.convertCollectionObjectIdToPrimaryKey() adding: " + object);
            }
            arrayList.add(object);
        }
        return arrayList;
    }

    public Collection convertCollectionPrimaryKeyToObjectId(Collection collection) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            object = this.convertPrimaryKeyToObjectId(iterator.next());
            if (logger.isLoggable(300)) {
                logger.finest("\n---JDOEJB11HelperImpl.convertCollectionPrimaryKeyToObjectId() adding: " + object);
            }
            arrayList.add(object);
        }
        return arrayList;
    }

    public byte[] writeSerializableObjectToByteArray(Serializable serializable) {
        byte[] byArray = null;
        if (serializable != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = null;
            try {
                objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(serializable);
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                String string = serializable.getClass().getName();
                throw new JDOUserException(I18NHelper.getMessage(messages, "EXC_IOWriteSerializableObject", string), iOException);
            }
        }
        return byArray;
    }

    public Serializable readSerializableObjectFromByteArray(byte[] byArray) {
        Serializable serializable = null;
        if (byArray != null) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            HelperObjectInputStream helperObjectInputStream = null;
            ClassLoader classLoader = this.getClass().getClassLoader();
            try {
                helperObjectInputStream = new HelperObjectInputStream(byteArrayInputStream, classLoader);
                serializable = (Serializable)helperObjectInputStream.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new JDOFatalDataStoreException(I18NHelper.getMessage(messages, "EXC_CNFReadSerializableObject"), classNotFoundException);
            }
            catch (IOException iOException) {
                throw new JDOFatalDataStoreException(I18NHelper.getMessage(messages, "EXC_IOReadSerializableObject"), iOException);
            }
        }
        return serializable;
    }

    public abstract Class getPCClass();

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class HelperObjectInputStream
    extends ObjectInputStream {
        ClassLoader classLoader;

        public HelperObjectInputStream(InputStream inputStream, ClassLoader classLoader) throws IOException, StreamCorruptedException {
            super(inputStream);
            this.classLoader = classLoader;
        }

        protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
            return this.classLoader.loadClass(objectStreamClass.getName());
        }
    }
}

