/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.model.jdo.impl;

import com.sun.jdo.api.persistence.model.ModelException;
import com.sun.jdo.api.persistence.model.ModelVetoException;
import com.sun.jdo.api.persistence.model.jdo.ConcurrencyGroupElement;
import com.sun.jdo.api.persistence.model.jdo.PersistenceClassElement;
import com.sun.jdo.api.persistence.model.jdo.PersistenceFieldElement;
import com.sun.jdo.api.persistence.model.jdo.impl.PersistenceElementCollection;
import com.sun.jdo.api.persistence.model.jdo.impl.PersistenceElementImpl;
import java.beans.PropertyVetoException;

public class PersistenceClassElementImpl
extends PersistenceElementImpl
implements PersistenceClassElement.Impl {
    private boolean _isModified;
    private int _objectIdentityType;
    private String _keyClass;
    private PersistenceElementCollection _fields;
    private PersistenceElementCollection _groups;

    public PersistenceClassElementImpl() {
        this(null);
    }

    public PersistenceClassElementImpl(String string) {
        super(string);
        if (string != null) {
            this._keyClass = string + ".Oid";
        }
        this._objectIdentityType = 0;
        this._fields = new PersistenceElementCollection(this, "fields", new PersistenceFieldElement[0]);
        this._groups = new PersistenceElementCollection(this, "groups", new ConcurrencyGroupElement[0]);
    }

    protected final void firePropertyChange(String string, Object object, Object object2) {
        boolean bl = object != null && object2 != null && object.equals(object2);
        super.firePropertyChange(string, object, object2);
        if (!"modified".equals(string) && !bl) {
            this.setModified(true);
        }
    }

    protected final void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        boolean bl = object != null && object2 != null && object.equals(object2);
        super.fireVetoableChange(string, object, object2);
        if (!"modified".equals(string) && !bl) {
            this.fireVetoableChange("modified", Boolean.FALSE, Boolean.TRUE);
        }
    }

    public boolean isModified() {
        return this._isModified;
    }

    public void setModified(boolean bl) {
        boolean bl2 = this.isModified();
        if (bl != bl2) {
            this._isModified = bl;
            this.firePropertyChange("modified", new Boolean(bl2), new Boolean(bl));
        }
    }

    public int getObjectIdentityType() {
        return this._objectIdentityType;
    }

    public void setObjectIdentityType(int n) throws ModelException {
        Integer n2 = new Integer(this.getObjectIdentityType());
        Integer n3 = new Integer(n);
        try {
            this.fireVetoableChange("identity", n2, n3);
            this._objectIdentityType = n;
            this.firePropertyChange("identity", n2, n3);
        }
        catch (PropertyVetoException propertyVetoException) {
            throw new ModelVetoException(propertyVetoException);
        }
    }

    public String getKeyClass() {
        return 0 == this.getObjectIdentityType() ? this._keyClass : null;
    }

    public void setKeyClass(String string) throws ModelException {
        String string2 = this.getKeyClass();
        try {
            this.fireVetoableChange("keyClass", string2, string);
            this._keyClass = string;
            this.firePropertyChange("keyClass", string2, string);
        }
        catch (PropertyVetoException propertyVetoException) {
            throw new ModelVetoException(propertyVetoException);
        }
    }

    public void changeFields(PersistenceFieldElement[] persistenceFieldElementArray, int n) throws ModelException {
        this._fields.changeElements(persistenceFieldElementArray, n);
    }

    public PersistenceFieldElement[] getFields() {
        return (PersistenceFieldElement[])this._fields.getElements();
    }

    public PersistenceFieldElement getField(String string) {
        return (PersistenceFieldElement)this._fields.getElement(string);
    }

    public void changeConcurrencyGroups(ConcurrencyGroupElement[] concurrencyGroupElementArray, int n) throws ModelException {
        this._groups.changeElements(concurrencyGroupElementArray, n);
    }

    public ConcurrencyGroupElement[] getConcurrencyGroups() {
        return (ConcurrencyGroupElement[])this._groups.getElements();
    }

    public ConcurrencyGroupElement getConcurrencyGroup(String string) {
        return (ConcurrencyGroupElement)this._groups.getElement(string);
    }

    public PersistenceElementCollection getFieldCollection() {
        return this._fields;
    }

    public void setFieldCollection(PersistenceElementCollection persistenceElementCollection) {
        this._fields = persistenceElementCollection;
    }

    public PersistenceElementCollection getGroupCollection() {
        return this._groups;
    }

    public void setGroupCollection(PersistenceElementCollection persistenceElementCollection) {
        this._groups = persistenceElementCollection;
    }
}

