/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.classfile;

import com.sun.jdo.api.persistence.enhancer.classfile.ClassAttribute;
import com.sun.jdo.api.persistence.enhancer.classfile.ClassPrint;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstUtf8;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstantPool;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class AnnotatedClassAttribute
extends ClassAttribute {
    public static final String expectedAttrName = "filter.annotatedClass";
    public static final short expectedAttrVersion = 1;
    public static final short generatedFlag = 1;
    public static final short annotatedFlag = 2;
    public static final short modifiedFlag = 4;
    private short attrVersion;
    private short annotationFlags;
    private long classModTime;
    private long classAnnotationTime;

    public short getVersion() {
        return this.attrVersion;
    }

    public void setVersion(short s) {
        this.attrVersion = s;
    }

    public short getFlags() {
        return this.annotationFlags;
    }

    public void setFlags(short s) {
        this.annotationFlags = s;
    }

    public long getModTime() {
        return this.classModTime;
    }

    public void setModTime(long l) {
        this.classModTime = l;
    }

    public long getAnnotationTime() {
        return this.classAnnotationTime;
    }

    public void setAnnotationTime(long l) {
        this.classAnnotationTime = l;
    }

    public AnnotatedClassAttribute(ConstUtf8 constUtf8, short s, short s2, long l, long l2) {
        super(constUtf8);
        this.attrVersion = s;
        this.annotationFlags = s2;
        this.classModTime = l;
        this.classAnnotationTime = l2;
    }

    static AnnotatedClassAttribute read(ConstUtf8 constUtf8, DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        short s = dataInputStream.readShort();
        short s2 = dataInputStream.readShort();
        long l = dataInputStream.readLong();
        long l2 = dataInputStream.readLong();
        return new AnnotatedClassAttribute(constUtf8, s, s2, l, l2);
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.attrName().getIndex());
        dataOutputStream.writeShort(20);
        dataOutputStream.writeShort(this.attrVersion);
        dataOutputStream.writeShort(this.annotationFlags);
        dataOutputStream.writeLong(this.classModTime);
        dataOutputStream.writeLong(this.classAnnotationTime);
    }

    void print(PrintStream printStream, int n) {
        ClassPrint.spaces(printStream, n);
        printStream.println("version: " + this.attrVersion);
        printStream.println(" flags: " + this.annotationFlags);
        printStream.println(" modTime: " + this.classModTime);
        printStream.println(" annTime: " + this.classAnnotationTime);
    }
}

