/*
 * Decompiled with CFR 0.152.
 */
package com.sun.forte4j.modules.dbmodel;

import com.sun.forte4j.modules.dbmodel.DBException;
import com.sun.forte4j.modules.dbmodel.DBMemberElement;
import com.sun.forte4j.modules.dbmodel.TableElement;
import com.sun.forte4j.modules.dbmodel.util.SQLTypeUtil;

public class ColumnElement
extends DBMemberElement {
    public ColumnElement() {
        this(new Memory(), null);
    }

    public ColumnElement(Impl impl, TableElement tableElement) {
        super(impl, tableElement);
    }

    public boolean equals(Object object) {
        Integer n;
        if (!(object instanceof ColumnElement)) {
            return false;
        }
        ColumnElement columnElement = (ColumnElement)object;
        if (!this.getName().getFullName().equals(columnElement.getName().getFullName())) {
            return false;
        }
        if (this.getType() != columnElement.getType()) {
            return false;
        }
        if (this.isNullable() != columnElement.isNullable()) {
            return false;
        }
        Integer n2 = this.getLength();
        if (n2 != null ^ (n = columnElement.getLength()) != null) {
            return false;
        }
        if (n2 != null && n != null && n2.compareTo(n) != 0) {
            return false;
        }
        n2 = this.getScale();
        if (n2 != null ^ (n = columnElement.getScale()) != null) {
            return false;
        }
        if (n2 != null && n != null && n2.compareTo(n) != 0) {
            return false;
        }
        n2 = this.getPrecision();
        if (n2 != null ^ (n = columnElement.getPrecision()) != null) {
            return false;
        }
        return n2 == null || n == null || n2.compareTo(n) == 0;
    }

    public Object clone() {
        return new ColumnElement(new Memory(this), null);
    }

    final Impl getColumnImpl() {
        return (Impl)this.getElementImpl();
    }

    public int getType() {
        return this.getColumnImpl().getType();
    }

    public void setType(int n) throws DBException {
        this.getColumnImpl().setType(n);
    }

    public boolean isNumericType() {
        return SQLTypeUtil.isNumeric(this.getType());
    }

    public boolean isCharacterType() {
        return SQLTypeUtil.isCharacter(this.getType());
    }

    public boolean isBlobType() {
        return SQLTypeUtil.isBlob(this.getType());
    }

    public boolean isNullable() {
        return this.getColumnImpl().isNullable();
    }

    public void setNullable(boolean bl) throws DBException {
        this.getColumnImpl().setNullable(bl);
    }

    public Integer getLength() {
        if (this.isCharacterType() || this.isBlobType()) {
            return this.getColumnImpl().getLength();
        }
        return null;
    }

    public void setLength(Integer n) throws DBException {
        if (this.isCharacterType() || this.isBlobType()) {
            this.getColumnImpl().setLength(n);
        }
    }

    public Integer getPrecision() {
        if (this.isNumericType()) {
            return this.getColumnImpl().getPrecision();
        }
        return null;
    }

    public void setPrecision(Integer n) throws DBException {
        if (this.isNumericType()) {
            this.getColumnImpl().setPrecision(n);
        }
    }

    public Integer getScale() {
        if (this.isNumericType()) {
            return this.getColumnImpl().getScale();
        }
        return null;
    }

    public void setScale(Integer n) throws DBException {
        if (this.isNumericType()) {
            this.getColumnImpl().setScale(n);
        }
    }

    public String toString() {
        return this.getName().toString();
    }

    static class Memory
    extends DBMemberElement.Memory
    implements Impl {
        private int _type;
        private boolean _nullable;
        private Integer _length;
        private Integer _precision;
        private Integer _scale;

        Memory() {
            this._type = 0;
        }

        Memory(ColumnElement columnElement) {
            super(columnElement);
            this._type = columnElement.getType();
            this._nullable = columnElement.isNullable();
            this._length = columnElement.getLength();
            this._precision = columnElement.getPrecision();
            this._scale = columnElement.getScale();
        }

        public int getType() {
            return this._type;
        }

        public void setType(int n) {
            int n2 = this._type;
            this._type = n;
            this.firePropertyChange("type", new Integer(n2), new Integer(n));
        }

        public boolean isNullable() {
            return this._nullable;
        }

        public void setNullable(boolean bl) throws DBException {
            boolean bl2 = this._nullable;
            this._nullable = bl;
            this.firePropertyChange("nullable", new Boolean(bl2), new Boolean(bl));
        }

        public Integer getLength() {
            return this._length;
        }

        public void setLength(Integer n) throws DBException {
            Integer n2 = this._length;
            this._length = n;
            this.firePropertyChange("length", n2, n);
        }

        public Integer getPrecision() {
            return this._precision;
        }

        public void setPrecision(Integer n) throws DBException {
            Integer n2 = this._precision;
            this._precision = n;
            this.firePropertyChange("precision", n2, n);
        }

        public Integer getScale() {
            return this._scale;
        }

        public void setScale(Integer n) throws DBException {
            Integer n2 = this._scale;
            this._scale = n;
            this.firePropertyChange("scale", n2, n);
        }
    }

    public static interface Impl
    extends DBMemberElement.Impl {
        public int getType();

        public void setType(int var1) throws DBException;

        public boolean isNullable();

        public void setNullable(boolean var1) throws DBException;

        public Integer getLength();

        public void setLength(Integer var1) throws DBException;

        public Integer getPrecision();

        public void setPrecision(Integer var1) throws DBException;

        public Integer getScale();

        public void setScale(Integer var1) throws DBException;
    }
}

