/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.forte.ejb;

import com.iplanet.ias.tools.common.dd.ejb.SunEjbJar;
import com.iplanet.ias.tools.common.util.diagnostics.Reporter;
import com.iplanet.ias.tools.forte.ejb.IASEJBException;
import com.iplanet.ias.tools.forte.ejb.IASEJBTopItem;
import com.iplanet.ias.tools.forte.ejb.IASServer;
import com.iplanet.ias.tools.forte.ejb.TpCmpEjbConfigSupport;
import java.io.OutputStream;
import java.util.HashMap;
import org.netbeans.modules.j2ee.server.ConfigInputStream;
import org.netbeans.modules.j2ee.server.ConfigOutputStream;
import org.netbeans.modules.j2ee.server.CustomDataRoot;
import org.netbeans.modules.j2ee.server.datamodel.EjbStandardData;
import org.netbeans.modules.j2ee.server.datamodel.StandardData;
import org.netbeans.modules.j2ee.server.ejb.EjbConfigSupport;
import org.netbeans.modules.j2ee.server.ejb.EjbCustomData;
import org.netbeans.modules.j2ee.server.ejb.EjbTableInformation;

public class IASEJBSupport
implements EjbConfigSupport {
    private static String[] extArray = null;
    private HashMap outMap = new HashMap();
    public static final String EXT = "ejbsun";
    private static final String[] extensions = new String[]{"ejbsun"};
    private static IASServer server;
    private TpCmpEjbConfigSupport tpSupport = null;

    public void newComponentCreated(String name, ConfigOutputStream[] files) {
        Reporter.verbose("");
        this.newEjbCreated(name, files, null);
    }

    public CustomDataRoot getCustomData(StandardData data, ConfigInputStream[] files) {
        Reporter.verbose("");
        return this.getEjbCustomData((EjbStandardData.Ejb)data, files);
    }

    public EjbCustomData.Ejb getEjbCustomData(EjbStandardData.Ejb dataobj, ConfigInputStream[] files) {
        Reporter.verbose("");
        try {
            dataobj.itemModified();
            return new IASEJBTopItem(dataobj, server, files);
        }
        catch (IASEJBException e) {
            Reporter.error("Got exception creating top EJB item for the iPlanet Server: " + e);
            Reporter.error(e);
            return null;
        }
    }

    public void newEjbCreated(String EjbName2, ConfigOutputStream[] files, EjbTableInformation tableInfo) {
        this.loadOutMap(files);
        Reporter.verbose("");
        try {
            if (tableInfo != null) {
                // empty if block
            }
            SunEjbJar dd = SunEjbJar.createGraph();
            dd.write(this.getOutputStream(EXT));
            this.tpSupport.newEjbCreated(EjbName2, files, tableInfo);
        }
        catch (Exception t) {
            t.printStackTrace();
            throw new RuntimeException(t.getMessage());
        }
    }

    public IASEJBSupport(IASServer theServer) {
        server = theServer;
        this.tpSupport = new TpCmpEjbConfigSupport();
    }

    public String[] getFileExtensions() {
        if (null == extArray) {
            String[] tpCmpExts = this.tpSupport.getFileExtensions();
            int tpExtLen = 0;
            if (null != tpCmpExts) {
                tpExtLen = tpCmpExts.length;
            }
            extArray = new String[extensions.length + tpExtLen];
            int i = 2;
            while (i < extArray.length) {
                IASEJBSupport.extArray[i] = tpCmpExts[i - 2];
                ++i;
            }
            IASEJBSupport.extArray[0] = extensions[0];
        }
        return extArray;
    }

    void loadOutMap(ConfigOutputStream[] files) {
        this.outMap.clear();
        int len = 0;
        if (null != files) {
            len = files.length;
        }
        int i = 0;
        while (i < len) {
            this.outMap.put(files[i].getFileExtension(), files[i]);
            Reporter.info(files[i].getFileExtension());
            ++i;
        }
    }

    OutputStream getOutputStream(String ext) {
        Reporter.assertIt(this.outMap.size() > 0, "BadState: no data in outMap");
        OutputStream retVal = null;
        ConfigOutputStream tmp = (ConfigOutputStream)this.outMap.get(ext);
        Reporter.verbose(tmp);
        if (null != tmp) {
            retVal = tmp.getOutputStream();
        }
        Reporter.verbose(retVal);
        return retVal;
    }

    void clearOutMap() {
        this.outMap.clear();
    }
}

