/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.forte;

import com.iplanet.ias.tools.common.util.diagnostics.Reporter;
import com.iplanet.ias.tools.common.util.diagnostics.StackTrace;
import com.iplanet.ias.tools.forte.TpCmpConstants;
import com.iplanet.ias.tools.forte.TpCmpShadowFileManager;
import com.iplanet.ias.tools.forte.ejb.IASEJBModuleItem;
import com.iplanet.ias.tools.forte.ejb.IASServer;
import com.iplanet.ias.tools.forte.ejb.TpCmpEjb;
import com.sun.jdo.api.persistence.model.Model;
import com.sun.jdo.api.persistence.model.util.ModelValidationException;
import com.sun.jdo.modules.persistence.mapping.ejb.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import org.netbeans.modules.j2ee.server.MessageReporter;
import org.netbeans.modules.j2ee.server.Packager;
import org.netbeans.modules.j2ee.server.Server;
import org.netbeans.modules.j2ee.server.datamodel.EjbModuleStandardData;
import org.netbeans.modules.j2ee.server.datamodel.EjbStandardData;
import org.netbeans.modules.j2ee.server.datamodel.StandardData;
import org.netbeans.modules.jarpackager.api.ArchiveEntry;
import org.openide.util.NbBundle;

public class TpCmpPackager
implements Packager,
TpCmpConstants {
    private static Map mod2map = new HashMap();
    ResourceBundle bundle = NbBundle.getBundle((Class)(class$com$iplanet$ias$tools$forte$TpCmpPackager == null ? (class$com$iplanet$ias$tools$forte$TpCmpPackager = TpCmpPackager.class$("com.iplanet.ias.tools.forte.TpCmpPackager")) : class$com$iplanet$ias$tools$forte$TpCmpPackager));
    static /* synthetic */ Class class$com$iplanet$ias$tools$forte$TpCmpPackager;
    static /* synthetic */ Class class$java$lang$Object;

    public static void link(EjbStandardData.Ejb key, EjbModuleStandardData.Module m, TpCmpEjb val) {
        Object mkey = TpCmpShadowFileManager.getModuleKey(m);
        HashMap<EjbStandardData.Ejb, TpCmpEjb> map = (HashMap<EjbStandardData.Ejb, TpCmpEjb>)mod2map.get(mkey);
        if (null == map) {
            map = new HashMap<EjbStandardData.Ejb, TpCmpEjb>();
            mod2map.put(mkey, map);
        }
        map.put(key, val);
    }

    public void archiveCreated(StandardData sd) {
    }

    public ArchiveEntry[] getJarInput(StandardData sd, Collection files) {
        Reporter.info(sd);
        return new ArchiveEntry[0];
    }

    public ArchiveEntry[] getFinalJarInput(StandardData sd, Collection objects) {
        Reporter.info(sd);
        Iterator<Object> iter = objects.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            Reporter.info(obj.getClass() + "  " + obj);
        }
        EjbModuleStandardData.Module mod = (EjbModuleStandardData.Module)sd;
        EjbStandardData.Ejb[] ejbs = mod.getBaseEjbs();
        int len = 0;
        if (null != ejbs) {
            len = ejbs.length;
        }
        ArrayList<ArchiveEntry> retVal = new ArrayList<ArchiveEntry>();
        HashMap<String, SchemaArchiveEntry> schemas = new HashMap<String, SchemaArchiveEntry>();
        ArchiveEntry aRetVal = null;
        int i = 0;
        while (ejbs != null && i < ejbs.length) {
            Reporter.info(ejbs[i]);
            TpCmpEjb tmp = this.getTpCmpEjb(ejbs[i], mod);
            if (null != tmp) {
                SchemaArchiveEntry foo2 = new SchemaArchiveEntry(ejbs[i], mod);
                schemas.put(foo2.getName(), foo2);
            }
            ++i;
        }
        Collection schemaEntries = schemas.values();
        iter = schemaEntries.iterator();
        while (iter.hasNext()) {
            aRetVal = (ArchiveEntry)iter.next();
            retVal.add(aRetVal);
        }
        ArchiveEntry[] finalReturn = new ArchiveEntry[retVal.size()];
        int i2 = 0;
        while (i2 < retVal.size()) {
            finalReturn[i2] = (ArchiveEntry)retVal.get(i2);
            ++i2;
        }
        return finalReturn;
    }

    public boolean validate(StandardData sd, Collection files, MessageReporter mr) {
        EjbModuleStandardData.Module mod = (EjbModuleStandardData.Module)sd;
        EjbStandardData.Ejb[] ejbs = mod.getBaseEjbs();
        boolean retVal = true;
        boolean hasCmpBeans = false;
        int i = 0;
        while (i < ejbs.length) {
            TpCmpEjb custom = this.getTpCmpEjb(ejbs[i], mod);
            if (null != custom) {
                hasCmpBeans = true;
                boolean tmpVal = custom.verifyMapping();
                boolean bl = retVal = tmpVal && retVal;
                if (!tmpVal) {
                    mr.message(this.bundle, "TpCmpValidateFailue", new Object[]{ejbs[i].getEjbClass()});
                }
                Model model = Model.DEVELOPMENT;
                Collection modelFailures = model.validate(TpCmpShadowFileManager.getShadowPackageName(ejbs[i], mod), Util.getMappingContext().getBrandedBundle("com.sun.jdo.api.persistence.model.Bundle"));
                Iterator iter = modelFailures.iterator();
                while (iter.hasNext()) {
                    ModelValidationException mve = (ModelValidationException)iter.next();
                    EjbStandardData.EntityEjb tmp = null;
                    if (ejbs[i] instanceof EjbStandardData.EntityEjb) {
                        tmp = (EjbStandardData.EntityEjb)ejbs[i];
                    }
                    if (mve.getType() == 1 && null != tmp && tmp.getPrimKeyClass().equals((class$java$lang$Object == null ? TpCmpPackager.class$("java.lang.Object") : class$java$lang$Object).getName())) continue;
                    if (retVal) {
                        // empty if block
                    }
                    retVal = false;
                    mr.message(this.bundle, "TPModelFailure", new Object[]{ejbs[i].getEjbName(), mve.getMessage()});
                }
            }
            ++i;
        }
        boolean resourceDefined = true;
        if (hasCmpBeans) {
            try {
                IASEJBModuleItem cd = (IASEJBModuleItem)mod.getCustomData((Server)IASServer.getSingleton());
                String resourceVal = cd.getSunEjbJar().getEnterpriseBeans().getCmpResource().getJndiName();
                char c = resourceVal.trim().charAt(0);
            }
            catch (Throwable t) {
                resourceDefined = false;
                mr.message(this.bundle, "UndefinedCmpResource", null);
                Reporter.critical(new StackTrace(t));
            }
            retVal = retVal && resourceDefined;
        }
        return retVal;
    }

    private TpCmpEjb getTpCmpEjb(EjbStandardData.Ejb ejb, EjbModuleStandardData.Module m) {
        Object key = TpCmpShadowFileManager.getModuleKey(m);
        Map map = (Map)mod2map.get(key);
        TpCmpEjb retVal = null;
        if (null != map) {
            retVal = (TpCmpEjb)map.get(ejb);
        }
        return retVal;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class SchemaArchiveEntry
    implements ArchiveEntry {
        EjbStandardData.Ejb ejb;
        EjbModuleStandardData.Module m;

        public SchemaArchiveEntry(EjbStandardData.Ejb ejb, EjbModuleStandardData.Module m) {
            this.ejb = ejb;
            this.m = m;
        }

        public InputStream createInputStream() throws IOException {
            Object key = TpCmpShadowFileManager.getModuleKey(this.m);
            Map map = (Map)mod2map.get(key);
            if (null != map) {
                TpCmpEjb custom = (TpCmpEjb)map.get(this.ejb);
                return custom.getSchemaStream();
            }
            return null;
        }

        public String getName() {
            Object key = TpCmpShadowFileManager.getModuleKey(this.m);
            Map map = (Map)mod2map.get(key);
            if (null != map) {
                TpCmpEjb custom = (TpCmpEjb)map.get(this.ejb);
                return custom.getSchemaName() + ".dbschema";
            }
            return null;
        }
    }

    class MappingArchiveEntry
    implements ArchiveEntry {
        EjbStandardData.Ejb ejb;
        EjbModuleStandardData.Module m;

        public MappingArchiveEntry(EjbStandardData.Ejb ejb, EjbModuleStandardData.Module m) {
            this.ejb = ejb;
            this.m = m;
        }

        public InputStream createInputStream() throws IOException {
            TpCmpEjb custom = TpCmpPackager.this.getTpCmpEjb(this.ejb, this.m);
            return custom.getMappingStream();
        }

        public String getName() {
            TpCmpEjb custom = TpCmpPackager.this.getTpCmpEjb(this.ejb, this.m);
            return custom.getMappingName();
        }
    }
}

