/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.util;

import com.iplanet.ias.admin.util.Assert;
import com.iplanet.ias.admin.util.ExceptionUtil;
import com.iplanet.ias.admin.util.IOutput;
import java.io.OutputStream;
import java.io.PrintStream;

class Output
implements IOutput {
    OutputStream mOutputStream = null;
    PrintStream mPrint = null;
    boolean mCloseWhenDone = false;

    public Output(OutputStream outputStream, boolean closeWhenDone) throws Exception {
        Assert.assertit(outputStream != null, "null outputStream");
        this.mPrint = new PrintStream(outputStream);
        this.mOutputStream = outputStream;
        this.mCloseWhenDone = closeWhenDone;
    }

    public void close() {
        if (this.mCloseWhenDone) {
            try {
                this.mOutputStream.close();
            }
            catch (Exception e) {
                ExceptionUtil.ignoreException(e);
            }
        }
        this.mOutputStream = null;
        this.mPrint = null;
        this.mCloseWhenDone = false;
    }

    public void print(String msg) {
        this.mPrint.print(msg);
    }

    public void println(String msg) {
        this.mPrint.println(msg);
    }

    public void flush() {
        try {
            this.mOutputStream.flush();
        }
        catch (Exception e) {
            ExceptionUtil.ignoreException(e);
        }
    }
}

