/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.servermodel.controllers;

import com.iplanet.ias.admin.common.ObjectNames;
import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.servermodel.beans.JVMComponentBean;
import com.iplanet.ias.admin.servermodel.beans.Profiler;
import com.iplanet.ias.admin.servermodel.context.ContextHolder;
import com.iplanet.ias.admin.servermodel.controllers.Controller;
import com.iplanet.ias.admin.servermodel.controllers.SOMRequestDispatcher;
import com.iplanet.ias.admin.util.ArgChecker;
import com.iplanet.ias.admin.util.Assert;
import com.iplanet.ias.admin.util.StringValidator;
import javax.management.ObjectName;

public class JVMComponentController
implements Controller {
    private static final String GET_JVM_OPTIONS = "getJvmOptions";
    private static final String SET_JVM_OPTIONS = "setJvmOptions";
    private static final String CREATE_PROFILER = "createProfiler";
    private static final String DELETE_PROFILER = "deleteProfiler";
    private static final String PROFILER_EXISTS = "isProfilerExist";
    private static final String GET_PROFILER = "getProfiler";
    private JVMComponentBean jvm;

    public JVMComponentController(JVMComponentBean jvm) {
        this.jvm = jvm;
    }

    public String[] getJvmOptions() throws AFException {
        String[] options = (String[])this.invoke(GET_JVM_OPTIONS, null, null);
        return options;
    }

    public void setJvmOptions(String[] options) throws AFException {
        ArgChecker.checkValid(options, "options");
        String[] signature = new String[]{options.getClass().getName()};
        Object[] params = new Object[]{options};
        this.invoke(SET_JVM_OPTIONS, params, signature);
    }

    public void createProfiler(String name) throws AFException {
        ArgChecker.checkValid(name, "name", StringValidator.getInstance());
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.Boolean"};
        Object[] params = new Object[]{name, null, null, null};
        this.invoke(CREATE_PROFILER, params, signature);
    }

    public boolean isProfilerExists() throws AFException {
        Object profiler = null;
        Boolean value = (Boolean)this.invoke(PROFILER_EXISTS, null, null);
        Assert.assertit(value != null, "null value returned");
        return value;
    }

    public Profiler getProfiler() throws AFException {
        Profiler profiler = null;
        String profilerName = (String)this.invoke(GET_PROFILER, null, null);
        if (profilerName != null) {
            ObjectName mbeanName = ObjectNames.getProfilerObjectName(this.jvm.getInstanceName());
            Assert.assertit(mbeanName != null, "null value returned");
            profiler = new Profiler(mbeanName.toString(), profilerName);
            profiler.setContextHolder(this.jvm.getContextHolder());
        }
        return profiler;
    }

    public void deleteProfiler() throws AFException {
        this.invoke(DELETE_PROFILER, null, null);
    }

    private Object invoke(String operation, Object[] params, String[] signature) throws AFException {
        try {
            ContextHolder ctxHolder = this.jvm.getContextHolder();
            ObjectName mbeanName = new ObjectName(this.jvm.getIdentifier());
            SOMRequestDispatcher dispatcher = SOMRequestDispatcher.getDispatcher(ctxHolder);
            return dispatcher.invoke(mbeanName, operation, params, signature);
        }
        catch (Exception e) {
            if (e instanceof AFException) {
                throw (AFException)e;
            }
            throw new AFException(e.getLocalizedMessage());
        }
    }
}

