/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.servermodel;

import com.iplanet.ias.admin.common.ObjectNames;
import com.iplanet.ias.admin.common.ServerInstanceStatus;
import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.common.exception.AFResourceException;
import com.iplanet.ias.admin.common.exception.AFTargetNotFoundException;
import com.iplanet.ias.admin.common.exception.AccessViolationException;
import com.iplanet.ias.admin.common.exception.AttributeNotFoundException;
import com.iplanet.ias.admin.common.exception.ControlException;
import com.iplanet.ias.admin.common.exception.DeploymentException;
import com.iplanet.ias.admin.common.exception.InstanceAlreadyRunningException;
import com.iplanet.ias.admin.common.exception.InstanceNotRunningException;
import com.iplanet.ias.admin.common.exception.InvalidAttributeValueException;
import com.iplanet.ias.admin.servermodel.Controllable;
import com.iplanet.ias.admin.servermodel.beans.CustomResource;
import com.iplanet.ias.admin.servermodel.beans.DeployedApplicationComponentBean;
import com.iplanet.ias.admin.servermodel.beans.DeployedConnectorComponentBean;
import com.iplanet.ias.admin.servermodel.beans.DeployedEJBModuleComponentBean;
import com.iplanet.ias.admin.servermodel.beans.DeployedModuleComponentBean;
import com.iplanet.ias.admin.servermodel.beans.DeployedWebModuleComponentBean;
import com.iplanet.ias.admin.servermodel.beans.HttpServiceComponentBean;
import com.iplanet.ias.admin.servermodel.beans.JDBCConnectionPool;
import com.iplanet.ias.admin.servermodel.beans.JDBCResource;
import com.iplanet.ias.admin.servermodel.beans.JMSComponentBean;
import com.iplanet.ias.admin.servermodel.beans.JMSResource;
import com.iplanet.ias.admin.servermodel.beans.JNDIResource;
import com.iplanet.ias.admin.servermodel.beans.JTAComponentBean;
import com.iplanet.ias.admin.servermodel.beans.JVMComponentBean;
import com.iplanet.ias.admin.servermodel.beans.JavaMailResource;
import com.iplanet.ias.admin.servermodel.beans.LifeCycleModule;
import com.iplanet.ias.admin.servermodel.beans.ORBComponentBean;
import com.iplanet.ias.admin.servermodel.beans.PersistenceManagerFactoryResource;
import com.iplanet.ias.admin.servermodel.beans.SecurityServiceComponentBean;
import com.iplanet.ias.admin.servermodel.beans.ServerComponent;
import com.iplanet.ias.admin.servermodel.beans.ServiceComponentBean;
import com.iplanet.ias.admin.servermodel.context.ContextHolder;
import com.iplanet.ias.admin.servermodel.controllers.AppServerInstanceController;
import com.iplanet.ias.admin.servermodel.controllers.Controller;
import com.iplanet.ias.admin.servermodel.util.ServerModelIterator;
import com.iplanet.ias.admin.util.ArgChecker;
import com.iplanet.ias.admin.util.Assert;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.admin.util.HostAndPort;
import com.iplanet.ias.admin.util.StringValidator;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class AppServerInstance
implements Controllable,
Serializable {
    private final String name;
    private HostAndPort hostAndPort;
    private ContextHolder contextHolder;
    private transient AppServerInstanceController controller;

    public AppServerInstance(String name) {
        ArgChecker.checkValid(name, "name", StringValidator.getInstance());
        this.name = name;
        this.contextHolder = new ContextHolder();
        this.controller = new AppServerInstanceController(this);
    }

    public AppServerInstance(HostAndPort hAndp, String name) {
        this(name);
        ArgChecker.checkValid(hAndp, "hAndp");
        this.hostAndPort = hAndp;
    }

    public void setContextHolder(ContextHolder ctxHolder) {
        this.contextHolder = ctxHolder;
    }

    public ContextHolder getContextHolder() {
        return this.contextHolder;
    }

    public String getName() {
        return this.name;
    }

    public HostAndPort getHostAndPort() {
        return this.hostAndPort;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof AppServerInstance) {
            AppServerInstance that = (AppServerInstance)o;
            return this.hostAndPort.equals(that.hostAndPort) && this.name.equals(that.name);
        }
        return false;
    }

    public String toString() {
        String str = this.name;
        if (this.hostAndPort != null) {
            str = str + '[' + this.hostAndPort.toString() + ']';
        }
        return str;
    }

    public Controller getController() {
        return this.controller;
    }

    public boolean isRunning() throws AFException {
        return this.controller.isRunning();
    }

    public int startInDebugMode() throws AFTargetNotFoundException, ControlException {
        return this.controller.startInDebugMode();
    }

    public int startSecureInDebugMode(String[] passwords) throws AFTargetNotFoundException, ControlException {
        return this.controller.startSecureInDebugMode(passwords);
    }

    public boolean stop() throws AFTargetNotFoundException, InstanceNotRunningException, ControlException {
        return this.controller.stop();
    }

    public boolean restart() throws AFTargetNotFoundException, ControlException {
        return this.controller.restart();
    }

    public boolean start() throws InstanceAlreadyRunningException, AFTargetNotFoundException, ControlException {
        return this.controller.start();
    }

    public String[] getSecurityPasswordTokens() throws AFException {
        return this.controller.getSecurityPasswordTokens();
    }

    public boolean startSecure(String[] passwords) throws InstanceAlreadyRunningException, AFTargetNotFoundException, ControlException {
        return this.controller.startSecure(passwords);
    }

    public String getStatus() throws AFException {
        return this.controller.getStatus();
    }

    public ServerInstanceStatus getServerStatus() throws AFException {
        return (ServerInstanceStatus)this.controller.getServerStatus();
    }

    public boolean deployApplication(String filePath, String appRoot, boolean bEnabled, String virtualServers, boolean forceDeploy, boolean bVerify, boolean bPrecompileJSP) throws DeploymentException {
        return this.controller.deployApplication(filePath, appRoot, bEnabled, virtualServers, forceDeploy, bVerify, bPrecompileJSP, true);
    }

    public boolean deployApplication(String filePath, String appRoot, boolean bEnabled, String virtualServers, boolean forceDeploy, boolean bVerify, boolean bPrecompileJSP, boolean bUpload) throws DeploymentException {
        return this.controller.deployApplication(filePath, appRoot, bEnabled, virtualServers, forceDeploy, bVerify, bPrecompileJSP, bUpload);
    }

    public boolean deployApplicationDirectory(String applicationDir, String applicationRoot, boolean bEnabled, String virtualServers, boolean forceDeploy, boolean bVerify, boolean bPrecompileJSP) throws DeploymentException {
        return this.controller.deployApplicationDirectory(applicationDir, applicationRoot, bEnabled, virtualServers, forceDeploy, bVerify, bPrecompileJSP);
    }

    public boolean undeployApplication(String applicationName) throws DeploymentException {
        return this.controller.undeployApplication(applicationName);
    }

    public boolean redeployApplication(String path, String applicationName) throws DeploymentException {
        return this.controller.redeployApplication(path, applicationName);
    }

    public boolean deployModule(String filePath, String moduleGroup) throws DeploymentException {
        return this.controller.deployModule(filePath, moduleGroup);
    }

    public boolean deployModule(String filePath) throws DeploymentException {
        return this.controller.deployModule(filePath);
    }

    public boolean deployEJBJarModule(String filePath, String moduleName) throws DeploymentException {
        return this.controller.deployEJBJarModule(filePath, moduleName);
    }

    public boolean deployEJBJarModule(String filePath, String moduleName, boolean forceDeploy) throws DeploymentException {
        return this.controller.deployEJBJarModule(filePath, moduleName, forceDeploy, false, true);
    }

    public boolean deployEJBJarModule(String filePath, String moduleName, boolean forceDeploy, boolean bVerify) throws DeploymentException {
        return this.controller.deployEJBJarModule(filePath, moduleName, forceDeploy, bVerify, true);
    }

    public boolean deployEJBJarModule(String filePath, String moduleName, boolean forceDeploy, boolean bVerify, boolean bUpload) throws DeploymentException {
        return this.controller.deployEJBJarModule(filePath, moduleName, forceDeploy, bVerify, bUpload);
    }

    public boolean deployEJBJarModuleDirectory(String moduleDir, String moduleName, boolean forceDeploy) throws DeploymentException {
        return this.controller.deployEJBJarModuleDirectory(moduleDir, moduleName, forceDeploy, false);
    }

    public boolean deployEJBJarModuleDirectory(String moduleDir, String moduleName, boolean forceDeploy, boolean bVerify) throws DeploymentException {
        return this.controller.deployEJBJarModuleDirectory(moduleDir, moduleName, forceDeploy, bVerify);
    }

    public boolean redeployEJBJarModule(String filePath, String moduleName) throws DeploymentException {
        return this.controller.redeployEJBJarModule(filePath, moduleName);
    }

    public boolean deployWarModule(String filePath, String webAppName, String contextRoot, boolean bEnabled, String virtualServers, boolean forceDeploy, boolean bVerify, boolean bPrecompileJSP) throws DeploymentException {
        return this.controller.deployWarModule(filePath, webAppName, contextRoot, bEnabled, virtualServers, forceDeploy, bVerify, bPrecompileJSP, true);
    }

    public boolean deployWarModule(String filePath, String webAppName, String contextRoot, boolean bEnabled, String virtualServers, boolean forceDeploy, boolean bVerify, boolean bPrecompileJSP, boolean bUpload) throws DeploymentException {
        return this.controller.deployWarModule(filePath, webAppName, contextRoot, bEnabled, virtualServers, forceDeploy, bVerify, bPrecompileJSP, bUpload);
    }

    public boolean deployWarModuleDirectory(String moduleDir, String webAppName, String contextRoot, boolean bEnabled, String virtualServers, boolean forceDeploy, boolean bVerify, boolean bPrecompileJSP) throws DeploymentException {
        return this.controller.deployWarModuleDirectory(moduleDir, webAppName, contextRoot, bEnabled, virtualServers, forceDeploy, bVerify, bPrecompileJSP);
    }

    public boolean redeployWarModule(String filePath, String webAppName, String contextRoot) throws DeploymentException {
        return this.controller.redeployWarModule(filePath, webAppName, contextRoot);
    }

    public boolean deployConnectorModule(String filePath, String moduleName) throws DeploymentException {
        return this.controller.deployConnectorModule(filePath, moduleName);
    }

    public boolean deployConnectorModule(String filePath, String moduleName, boolean forceDeploy) throws DeploymentException {
        return this.controller.deployConnectorModule(filePath, moduleName, forceDeploy, false, true);
    }

    public boolean deployConnectorModule(String filePath, String moduleName, boolean forceDeploy, boolean bVerify) throws DeploymentException {
        return this.controller.deployConnectorModule(filePath, moduleName, forceDeploy, bVerify, true);
    }

    public boolean deployConnectorModule(String filePath, String moduleName, boolean forceDeploy, boolean bVerify, boolean bUpload) throws DeploymentException {
        return this.controller.deployConnectorModule(filePath, moduleName, forceDeploy, bVerify, bUpload);
    }

    public boolean deployConnectorModuleDirectory(String moduleDir, String moduleName, boolean forceDeploy) throws DeploymentException {
        return this.controller.deployConnectorModuleDirectory(moduleDir, moduleName, forceDeploy, false);
    }

    public boolean deployConnectorModuleDirectory(String moduleDir, String moduleName, boolean forceDeploy, boolean bVerify) throws DeploymentException {
        return this.controller.deployConnectorModuleDirectory(moduleDir, moduleName, forceDeploy, bVerify);
    }

    public boolean redeployConnectorModule(String filePath, String moduleName) throws DeploymentException {
        return this.controller.redeployConnectorModule(filePath, moduleName);
    }

    public boolean undeployModule(String moduleName, int moduleType) throws DeploymentException {
        return this.controller.undeployModule(moduleName, moduleType);
    }

    public boolean undeployModuleInApplication(String applicationName, String moduleName) throws DeploymentException {
        return this.controller.undeployModuleInApplication(applicationName, moduleName);
    }

    public ServerModelIterator getDeployedApplications() throws AFException {
        return this.controller.getDeployedApplications();
    }

    public DeployedApplicationComponentBean getDeployedApplication(String appName) {
        ArgChecker.checkValid(appName, "appname", StringValidator.getInstance());
        ObjectName identifier = ObjectNames.getApplicationObjectName(this.name, appName);
        Assert.assertit(identifier != null, "null value returned");
        DeployedApplicationComponentBean appComponent = new DeployedApplicationComponentBean(identifier.toString(), appName);
        appComponent.setContextHolder(this.getContextHolder());
        return appComponent;
    }

    public ServerModelIterator getDeployedModules() {
        return this.controller.getDeployedModules();
    }

    public ServerModelIterator getDeployedEJBModules() throws AFException {
        return this.controller.getDeployedEJBModules();
    }

    public ServerModelIterator getDeployedWebModules() throws AFException {
        return this.controller.getDeployedWebModules();
    }

    public ServerModelIterator getDeployedConnectors() throws AFException {
        return this.controller.getDeployedConnectors();
    }

    public DeployedEJBModuleComponentBean getDeployedEJBModule(String moduleName) {
        ArgChecker.checkValid(moduleName, "moduleName", StringValidator.getInstance());
        ObjectName identifier = ObjectNames.getEjbModuleObjectName(this.name, moduleName);
        Assert.assertit(identifier != null, "null value returned");
        DeployedEJBModuleComponentBean module = new DeployedEJBModuleComponentBean(identifier.toString(), moduleName, true);
        module.setContextHolder(this.getContextHolder());
        return module;
    }

    public DeployedWebModuleComponentBean getDeployedWebModule(String moduleName) {
        ArgChecker.checkValid(moduleName, "moduleName", StringValidator.getInstance());
        ObjectName identifier = ObjectNames.getWebModuleObjectName(this.name, moduleName);
        Assert.assertit(identifier != null, "null value returned");
        DeployedWebModuleComponentBean module = new DeployedWebModuleComponentBean(identifier.toString(), moduleName, true);
        module.setContextHolder(this.getContextHolder());
        return module;
    }

    public DeployedConnectorComponentBean getDeployedConnector(String moduleName) {
        ArgChecker.checkValid(moduleName, "moduleName", StringValidator.getInstance());
        ObjectName identifier = ObjectNames.getConnectorModuleObjectName(this.name, moduleName);
        Assert.assertit(identifier != null, "null value returned");
        DeployedConnectorComponentBean module = new DeployedConnectorComponentBean(identifier.toString(), moduleName, true);
        module.setContextHolder(this.getContextHolder());
        return module;
    }

    public DeployedModuleComponentBean getDeployedModule(String moduleName) {
        DeployedModuleComponentBean moduleComponent = null;
        int moduleType = this.controller.getModuleType(moduleName);
        ObjectName identifier = ObjectNames.getModuleObjectName(this.name, moduleName);
        if (moduleType == 0) {
            moduleComponent = new DeployedEJBModuleComponentBean(identifier.toString(), moduleName, true);
        } else if (moduleType == 1) {
            moduleComponent = new DeployedWebModuleComponentBean(identifier.toString(), moduleName, true);
        }
        if (moduleComponent != null) {
            moduleComponent.setContextHolder(this.getContextHolder());
        }
        return moduleComponent;
    }

    public Object getAttribute(String attributeName) throws AttributeNotFoundException, AccessViolationException, AFTargetNotFoundException {
        return this.controller.getAttribute(attributeName);
    }

    public void setAttribute(String attributeName, Object value) throws AttributeNotFoundException, AccessViolationException, InvalidAttributeValueException, AFTargetNotFoundException {
        this.controller.setAttribute(attributeName, value);
    }

    public AttributeList getAttributes(String[] attributeNames) throws AFException {
        return this.controller.getAttributes(attributeNames);
    }

    public AttributeList setAttributes(AttributeList al) throws AFException {
        return this.controller.setAttributes(al);
    }

    public Object getDefaultAttributeValue(String attributeName) throws AFException {
        return this.controller.getDefaultAttributeValue(attributeName);
    }

    public void reconfig() {
        this.controller.reconfig();
    }

    public void backupConfig() {
        this.controller.backupConfig();
    }

    public void restoreConfig() {
        this.controller.restoreConfig();
    }

    public ServiceComponentBean getWebContainer() {
        ObjectName containerObjectName = ObjectNames.getWebContainerObjectName(this.name);
        Assert.assertit(containerObjectName != null, "null value returned");
        ServiceComponentBean webContainer = new ServiceComponentBean(containerObjectName.toString(), "Web container");
        webContainer.setContextHolder(this.getContextHolder());
        return webContainer;
    }

    public ServiceComponentBean getEjbContainer() {
        ObjectName containerObjectName = ObjectNames.getEjbContainerObjectName(this.name);
        Assert.assertit(containerObjectName != null, "null value returned");
        ServiceComponentBean container = new ServiceComponentBean(containerObjectName.toString(), "Ejb container");
        container.setContextHolder(this.getContextHolder());
        return container;
    }

    public ServiceComponentBean getMdbContainer() {
        ObjectName containerObjectName = ObjectNames.getMdbContainerObjectName(this.name);
        Assert.assertit(containerObjectName != null, "null value returned");
        ServiceComponentBean container = new ServiceComponentBean(containerObjectName.toString(), "Mdb container");
        container.setContextHolder(this.getContextHolder());
        return container;
    }

    public ServiceComponentBean getLogService() {
        ObjectName mbeanName = ObjectNames.getLogServiceObjectName(this.name);
        Assert.assertit(mbeanName != null, "null value returned");
        ServiceComponentBean logService = new ServiceComponentBean(mbeanName.toString(), "Log Service");
        logService.setContextHolder(this.getContextHolder());
        return logService;
    }

    public ORBComponentBean getORBComponent() {
        ObjectName objId = ObjectNames.getORBObjectName(this.name);
        Assert.assertit(objId != null, "null value returned");
        ORBComponentBean bean = new ORBComponentBean(objId.toString());
        bean.setContextHolder(this.getContextHolder());
        return bean;
    }

    public void retrieveApplication(String applicationName, File localDir) throws IOException {
        this.controller.retrieveApplication(applicationName, localDir);
    }

    public void retrieveModule(String moduleName, File localDir) throws IOException {
        this.controller.retrieveModule(moduleName, localDir);
    }

    public Iterator getServerComponents() {
        throw new UnsupportedOperationException("To be implemented");
    }

    public ServerComponent getServerComponent(String identifier) {
        throw new UnsupportedOperationException("To be implemented");
    }

    public void createResource(String xmlFile) throws AFResourceException {
        this.controller.createResource(xmlFile);
    }

    public void createJDBCConnectionPool(String id, String datasourceClassName) throws AFResourceException {
        this.controller.createJDBCConnectionPool(id, datasourceClassName);
    }

    public void deleteJDBCConnectionPool(String poolName) throws AFResourceException {
        this.controller.deleteJDBCConnectionPool(poolName);
    }

    public JDBCConnectionPool getJDBCConnectionPool(String poolId) throws AFResourceException {
        ArgChecker.checkValid(poolId, "poolId", StringValidator.getInstance());
        ObjectName connectionPoolObjectName = ObjectNames.getJDBCConnectionPoolObjectName(this.name, poolId);
        Assert.assertit(connectionPoolObjectName != null, "null value returned");
        JDBCConnectionPool connectionPool = new JDBCConnectionPool(connectionPoolObjectName.toString(), poolId);
        connectionPool.setContextHolder(this.getContextHolder());
        return connectionPool;
    }

    public ServerModelIterator getJDBCConnectionPools() throws AFException {
        return this.controller.getJDBCConnectionPools();
    }

    public void createJDBCResource(String jndiName, String poolName) throws AFResourceException {
        this.controller.createJDBCResource(jndiName, poolName);
    }

    public void deleteJDBCResource(String jndiName) throws AFResourceException {
        this.controller.deleteJDBCResource(jndiName);
    }

    public JDBCResource getJDBCResource(String jndiName) throws AFResourceException {
        ArgChecker.checkValid(jndiName, "jndiName", StringValidator.getInstance());
        ObjectName resourceObjectName = ObjectNames.getJDBCResourceObjectName(this.name, jndiName);
        Assert.assertit(resourceObjectName != null, "null value returned");
        JDBCResource resource = new JDBCResource(resourceObjectName.toString(), jndiName);
        resource.setContextHolder(this.getContextHolder());
        return resource;
    }

    public ServerModelIterator getJDBCResources() throws AFException {
        return this.controller.getJDBCResources();
    }

    public void createJMSResource(String jndiName, String resourceType) throws AFResourceException {
        this.controller.createJMSResource(jndiName, resourceType);
    }

    public void deleteJMSResource(String jndiName) throws AFResourceException {
        this.controller.deleteJMSResource(jndiName);
    }

    public JMSResource getJMSResource(String jndiName) throws AFResourceException {
        ArgChecker.checkValid(jndiName, "jndiName", StringValidator.getInstance());
        ObjectName resourceObjectName = ObjectNames.getJMSResourceObjectName(this.name, jndiName);
        Assert.assertit(resourceObjectName != null, "null value returned");
        JMSResource resource = new JMSResource(resourceObjectName.toString(), jndiName);
        resource.setContextHolder(this.getContextHolder());
        return resource;
    }

    public ServerModelIterator getJMSResources() throws AFException {
        return this.controller.getJMSResources();
    }

    public ServerModelIterator getJMSDestObjs() throws AFException {
        return this.controller.getJMSDestResources();
    }

    public ServerModelIterator getJMSConnObjs() throws AFException {
        return this.controller.getJMSConnResources();
    }

    public void createJNDIResource(String jndiName, String jndiLookupName, String resourceType, String factoryClass) throws AFResourceException {
        this.controller.createJNDIResource(jndiName, jndiLookupName, resourceType, factoryClass);
    }

    public void deleteJNDIResource(String jndiName) throws AFResourceException {
        this.controller.deleteJNDIResource(jndiName);
    }

    public JNDIResource getJNDIResource(String jndiName) throws AFResourceException {
        ArgChecker.checkValid(jndiName, "jndiName", StringValidator.getInstance());
        ObjectName resourceObjectName = ObjectNames.getJNDIResourceObjectName(this.name, jndiName);
        Assert.assertit(resourceObjectName != null, "null value returned");
        JNDIResource resource = new JNDIResource(resourceObjectName.toString(), jndiName);
        resource.setContextHolder(this.getContextHolder());
        return resource;
    }

    public ServerModelIterator getJNDIResources() throws AFException {
        return this.controller.getJNDIResources();
    }

    public void createJavaMailResource(String jndiName, String host, String user, String fromAddress) throws AFResourceException {
        this.controller.createJavaMailResource(jndiName, host, user, fromAddress);
    }

    public void deleteJavaMailResource(String jndiName) throws AFResourceException {
        this.controller.deleteJavaMailResource(jndiName);
    }

    public JavaMailResource getJavaMailResource(String jndiName) throws AFResourceException {
        ArgChecker.checkValid(jndiName, "jndiName", StringValidator.getInstance());
        ObjectName resourceObjectName = ObjectNames.getMailResourceObjectName(this.name, jndiName);
        Assert.assertit(resourceObjectName != null, "null value returned");
        JavaMailResource resource = new JavaMailResource(resourceObjectName.toString(), jndiName);
        resource.setContextHolder(this.getContextHolder());
        return resource;
    }

    public ServerModelIterator getJavaMailResources() throws AFException {
        return this.controller.getJavaMailResources();
    }

    public void createPersistenceManagerFactoryResource(String jndiName) throws AFResourceException {
        this.controller.createPersistenceManagerFactoryResource(jndiName);
    }

    public void deletePersistenceManagerFactoryResource(String jndiName) throws AFResourceException {
        this.controller.deletePersistenceManagerFactoryResource(jndiName);
    }

    public PersistenceManagerFactoryResource getPersistenceManagerFactoryResource(String jndiName) throws AFResourceException {
        ArgChecker.checkValid(jndiName, "jndiName", StringValidator.getInstance());
        ObjectName resourceObjectName = ObjectNames.getPersistenceManagerFactoryResourceObjectName(this.name, jndiName);
        Assert.assertit(resourceObjectName != null, "null value returned");
        PersistenceManagerFactoryResource resource = new PersistenceManagerFactoryResource(resourceObjectName.toString(), jndiName);
        resource.setContextHolder(this.getContextHolder());
        return resource;
    }

    public ServerModelIterator getPersistenceManagerFactoryResources() throws AFException {
        return this.controller.getPersistenceManagerFactoryResources();
    }

    public void createCustomResource(String jndiName, String resourceType, String factoryClass) throws AFResourceException {
        this.controller.createCustomResource(jndiName, resourceType, factoryClass);
    }

    public void deleteCustomResource(String jndiName) throws AFResourceException {
        this.controller.deleteCustomResource(jndiName);
    }

    public CustomResource getCustomResource(String jndiName) throws AFResourceException {
        ArgChecker.checkValid(jndiName, "jndiName", StringValidator.getInstance());
        ObjectName resourceObjectName = ObjectNames.getCustomResourceObjectName(this.name, jndiName);
        Assert.assertit(resourceObjectName != null, "null value returned");
        CustomResource resource = new CustomResource(resourceObjectName.toString(), jndiName);
        resource.setContextHolder(this.getContextHolder());
        return resource;
    }

    public ServerModelIterator getCustomResources() throws AFException {
        return this.controller.getCustomResources();
    }

    public JMSComponentBean getJMSComponent() {
        ObjectName mbeanName = ObjectNames.getJMSAdminHandlerObjectName(this.name);
        Assert.assertit(mbeanName != null, "null value returned");
        JMSComponentBean component = new JMSComponentBean(mbeanName.toString());
        component.setContextHolder(this.getContextHolder());
        return component;
    }

    public JTAComponentBean getJTAComponent() {
        ObjectName mbeanName = ObjectNames.getJTSComponentObjectName(this.name);
        Assert.assertit(mbeanName != null, "null value returned");
        JTAComponentBean component = new JTAComponentBean(mbeanName.toString());
        component.setContextHolder(this.getContextHolder());
        return component;
    }

    public JVMComponentBean getJVMComponent() {
        ObjectName mbeanName = ObjectNames.getJVMComponentObjectName(this.name);
        Assert.assertit(mbeanName != null, "null value returned");
        JVMComponentBean component = new JVMComponentBean(mbeanName.toString());
        component.setContextHolder(this.getContextHolder());
        return component;
    }

    public SecurityServiceComponentBean getSecurityService() {
        ObjectName mbeanName = ObjectNames.getSecurityServiceObjectName(this.name);
        Assert.assertit(mbeanName != null, "null value returned");
        SecurityServiceComponentBean component = new SecurityServiceComponentBean(mbeanName.toString());
        component.setContextHolder(this.getContextHolder());
        return component;
    }

    public HttpServiceComponentBean getHttpService() {
        ObjectName mbeanName = ObjectNames.getHttpServiceObjectName(this.name);
        Assert.assertit(mbeanName != null, "null value returned");
        HttpServiceComponentBean component = new HttpServiceComponentBean(mbeanName.toString());
        component.setContextHolder(this.getContextHolder());
        return component;
    }

    public boolean isApplyNeeded() throws AFException {
        return this.controller.isApplyNeeded();
    }

    public boolean isRestartNeeded() throws AFException {
        return this.controller.isRestartNeeded();
    }

    public boolean applyChanges() throws AFException {
        return this.controller.applyChanges();
    }

    public boolean overwriteChanges() throws AFException {
        return this.controller.overwriteChanges();
    }

    public boolean useManualChanges() throws AFException {
        return this.controller.useManualChanges();
    }

    public void createLifeCycleModule(String name, String className) throws AFException {
        this.controller.createLifeCycleModule(name, className);
    }

    public void removeLifeCycleModule(String name) throws AFException {
        this.controller.removeLifeCycleModule(name);
    }

    public ServerModelIterator getLifeCycleModules() throws AFException {
        return this.controller.getLifeCycleModules();
    }

    public LifeCycleModule getLifeCycleModule(String moduleName) {
        ArgChecker.checkValid(moduleName, "moduleName", StringValidator.getInstance());
        ObjectName mbeanName = ObjectNames.getLifeCycleModuleObjectName(this.getName(), moduleName);
        Assert.assertit(mbeanName != null, "null value returned");
        Debug.println("AppServerInstance.getLifeCycleModule: mbean = " + mbeanName);
        LifeCycleModule module = new LifeCycleModule(mbeanName.toString(), moduleName);
        module.setContextHolder(this.getContextHolder());
        return module;
    }

    public String exportClientStubs(String appName, int appType, String destDir) throws AFException {
        return this.controller.exportClientStubs(appName, appType, destDir);
    }

    public String[] getCertNickNames() throws AFException {
        return this.controller.getCertNickNames();
    }

    public String getInstanceRoot() throws AFException {
        return this.controller.getInstanceRoot();
    }

    public String[] getUserNames() throws AFException {
        return this.controller.getUserNames();
    }

    public String[] getGroupNames() throws AFException {
        return this.controller.getGroupNames();
    }

    public String[] getUserGroupNames(String userName) throws AFException {
        return this.controller.getUserGroupNames(userName);
    }

    public void addUser(String userName, String password, String[] groupList) throws AFException {
        this.controller.addUser(userName, password, groupList);
    }

    public void removeUser(String userName) throws AFException {
        this.controller.removeUser(userName);
    }

    public void updateUser(String userName, String password, String[] groupList) throws AFException {
        this.controller.updateUser(userName, password, groupList);
    }
}

