/*
 * Decompiled with CFR 0.152.
 */
package antlr;

import antlr.ANTLRTokdefLexer;
import antlr.ANTLRTokdefParser;
import antlr.Grammar;
import antlr.RecognitionException;
import antlr.SimpleTokenManager;
import antlr.StringLiteralSymbol;
import antlr.TokenStreamException;
import antlr.TokenSymbol;
import antlr.Tool;
import java.io.FileNotFoundException;
import java.io.FileReader;

class ImportVocabTokenManager
extends SimpleTokenManager
implements Cloneable {
    private String filename;
    protected Grammar grammar;

    public Object clone() {
        ImportVocabTokenManager importVocabTokenManager = (ImportVocabTokenManager)super.clone();
        importVocabTokenManager.filename = this.filename;
        importVocabTokenManager.grammar = this.grammar;
        return importVocabTokenManager;
    }

    public void define(TokenSymbol tokenSymbol) {
        super.define(tokenSymbol);
    }

    public void define(String string, int n) {
        TokenSymbol tokenSymbol = null;
        tokenSymbol = string.startsWith("\"") ? new StringLiteralSymbol(string) : new TokenSymbol(string);
        tokenSymbol.setTokenType(n);
        super.define(tokenSymbol);
        this.maxToken = n + 1 > this.maxToken ? n + 1 : this.maxToken;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public int nextTokenType() {
        return super.nextTokenType();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ImportVocabTokenManager(Grammar grammar, String string, String string2, Tool tool) {
        super(string2, tool);
        this.grammar = grammar;
        this.filename = string;
        this.setReadOnly(true);
        try {
            FileReader fileReader = new FileReader(this.filename);
            ANTLRTokdefLexer aNTLRTokdefLexer = new ANTLRTokdefLexer(fileReader);
            ANTLRTokdefParser aNTLRTokdefParser = new ANTLRTokdefParser(aNTLRTokdefLexer);
            aNTLRTokdefParser.setFilename(this.filename);
            aNTLRTokdefParser.file(this);
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            Tool.panic("Cannot find importVocab file '" + this.filename);
            return;
        }
        catch (RecognitionException recognitionException) {
            Tool.panic("Error parsing importVocab file '" + this.filename + "': " + recognitionException.toString());
            return;
        }
        catch (TokenStreamException tokenStreamException) {
            Tool.panic("Error reading importVocab file '" + this.filename + "'");
        }
    }
}

