/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli.framework;

import com.iplanet.ias.tools.cli.framework.GlobalsManager;
import com.iplanet.ias.tools.cli.framework.ValidOption;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class ValidCommand {
    private String name;
    private String numberOfOperands;
    private Vector validOptions;
    private Vector requiredOptions;
    private String className;
    private String helpText = null;
    private String usageText = null;
    private HashMap shortToLongOptionMapping = null;

    public ValidCommand() {
        this.validOptions = new Vector();
        this.requiredOptions = new Vector();
        this.shortToLongOptionMapping = new HashMap();
    }

    public ValidCommand(String string, String string2, Vector vector, Vector vector2, String string3) {
        this.name = string;
        this.numberOfOperands = string2;
        this.validOptions = vector;
        this.requiredOptions = vector2;
        this.helpText = string3;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getNumberOfOperands() {
        return this.numberOfOperands;
    }

    public void setNumberOfOperands(String string) {
        this.numberOfOperands = string;
    }

    public Vector getValidOptions() {
        return this.validOptions;
    }

    public void setValidOptions(Vector vector) {
        if (vector == null) {
            return;
        }
        int n = 0;
        while (n < vector.size()) {
            ValidOption validOption = (ValidOption)vector.get(n);
            this.addValidOption(validOption);
            ++n;
        }
    }

    public Vector getRequiredOptions() {
        return this.requiredOptions;
    }

    public void setRequiredOptions(Vector vector) {
        if (vector == null) {
            return;
        }
        int n = 0;
        while (n < vector.size()) {
            ValidOption validOption = (ValidOption)vector.get(n);
            this.addRequiredOption(validOption);
            ++n;
        }
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String string) {
        this.className = string;
    }

    public String getHelpText() {
        return this.helpText;
    }

    public void setHelpText(String string) {
        this.helpText = string;
    }

    public String getUsageText() {
        return this.usageText;
    }

    public void setUsageText(String string) {
        this.usageText = GlobalsManager.getLocalizedString("UsageString", new Object[]{string});
    }

    public int getLongOptionsCount() {
        return this.validOptions.size() + this.requiredOptions.size();
    }

    public int getShortOptionCount() {
        return this.shortToLongOptionMapping.size();
    }

    public Vector getShortOptions() {
        Vector<ValidOption> vector = new Vector<ValidOption>();
        Iterator iterator = this.shortToLongOptionMapping.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ValidOption validOption = (ValidOption)this.shortToLongOptionMapping.get(string);
            if (validOption == null) continue;
            vector.add(validOption);
        }
        return vector;
    }

    public ValidOption getOption(String string) {
        ValidOption validOption = null;
        int n = 0;
        while (n < this.validOptions.size()) {
            ValidOption validOption2 = (ValidOption)this.validOptions.get(n);
            if (validOption2.getName().equals(string)) {
                validOption = validOption2;
                break;
            }
            ++n;
        }
        if (validOption != null) {
            return validOption;
        }
        int n2 = 0;
        while (n2 < this.requiredOptions.size()) {
            ValidOption validOption3 = (ValidOption)this.requiredOptions.get(n2);
            if (validOption3.getName().equals(string)) {
                validOption = validOption3;
                break;
            }
            ++n2;
        }
        return validOption;
    }

    public Vector getOptions() {
        Vector vector = new Vector();
        int n = 0;
        while (n < this.validOptions.size()) {
            vector.add(this.validOptions.get(n));
            ++n;
        }
        int n2 = 0;
        while (n2 < this.requiredOptions.size()) {
            vector.add(this.requiredOptions.get(n2));
            ++n2;
        }
        return vector;
    }

    public int addValidOption(ValidOption validOption) {
        if (!this.hasValidOption(validOption)) {
            this.validOptions.add(validOption);
            if (!validOption.hasShortName() || this.shortToLongOptionMapping.containsKey(validOption.getShortName())) {
                return -1;
            }
        } else {
            return -1;
        }
        this.shortToLongOptionMapping.put(validOption.getShortName(), validOption);
        return 1;
    }

    public int addRequiredOption(ValidOption validOption) {
        if (!this.hasRequiredOption(validOption) && !this.hasValidOption(validOption)) {
            this.requiredOptions.add(validOption);
            if (this.shortToLongOptionMapping.containsKey(validOption.getShortName())) {
                return -1;
            }
        } else {
            return -1;
        }
        this.shortToLongOptionMapping.put(validOption.getShortName(), validOption);
        return 1;
    }

    public int deleteOption(ValidOption validOption) {
        return 1;
    }

    public boolean hasValidOption(String string) {
        boolean bl = false;
        int n = 0;
        while (n < this.validOptions.size()) {
            if (((ValidOption)this.validOptions.get(n)).getName().equals(string)) {
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    public boolean hasValidOption(ValidOption validOption) {
        return this.hasValidOption(validOption.getName());
    }

    public boolean hasRequiredOption(String string) {
        boolean bl = false;
        int n = 0;
        while (n < this.requiredOptions.size()) {
            if (((ValidOption)this.requiredOptions.get(n)).getName().equals(string)) {
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    public boolean hasRequiredOption(ValidOption validOption) {
        return this.hasRequiredOption(validOption.getName());
    }
}

