/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.servermodel.ServerInstanceManager;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.tools.cli.BaseConfigurationCommand;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;
import com.iplanet.ias.tools.cli.framework.Operand;
import com.iplanet.ias.tools.cli.framework.Option;
import java.util.Iterator;
import javax.management.Attribute;
import javax.management.AttributeList;

public class SetAttributeCommand
extends BaseConfigurationCommand {
    private static final char DOUBLE_QUOTE_CHAR = '\"';

    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    public void runCommand() throws CommandException, CommandValidationException {
        if (!this.validateOptions()) {
            return;
        }
        ServerInstanceManager serverInstanceManager = this.getServerInstanceManager();
        AttributeList attributeList = this.getAttributes();
        attributeList = this.setPrefixForAllAttributes(attributeList);
        AttributeList attributeList2 = null;
        try {
            attributeList2 = this.isMonitoring() ? serverInstanceManager.setMonitorAttributes(attributeList) : serverInstanceManager.setGenericAttributes(attributeList);
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printError(this.getLocalizedString("CannotSetAttribute"));
            throw new CommandException(exception.getMessage());
        }
        if (!this.isMonitoring()) {
            this.validateAttributeList(attributeList, attributeList2);
        } else if (attributeList2 == null) {
            this.printError(this.getLocalizedString("CannotSetAttribute"));
            throw new CommandException(this.getLocalizedString("NoAttributeNameMatch"));
        }
        Iterator iterator = attributeList2.iterator();
        if (!iterator.hasNext()) {
            this.printMessage(this.getLocalizedString("AttributeNotFound"));
        }
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            this.printMessage(this.getLocalizedString("AttributeSetTo", new Object[]{attribute.getName(), attribute.getValue().toString()}));
        }
        Debug.println(this.getClass().getName() + " : Command executed");
    }

    private AttributeList getAttributes() throws CommandException, CommandValidationException {
        AttributeList attributeList = new AttributeList();
        int n = 0;
        while (n < this.operands.size()) {
            String string = ((Operand)this.operands.get(n)).getName();
            Debug.println("Attribute (" + n + ") = " + string);
            int n2 = this.getSingleAttributeValueIndex(string);
            if (n2 == -1) {
                throw new CommandValidationException(this.getLocalizedString("ValueNotSetForAttribute"));
            }
            String string2 = string.substring(0, n2);
            if (string.length() <= n2) {
                throw new CommandValidationException(this.getLocalizedString("InvalidSetSyntax"));
            }
            String string3 = string.substring(n2 + 1);
            string3 = this.removeEscapeChars(string3);
            Attribute attribute = new Attribute(string2, string3);
            attributeList.add(attribute);
            ++n;
        }
        int n3 = 0;
        while (n3 < attributeList.size()) {
            Attribute attribute = (Attribute)attributeList.get(n3);
            Debug.println("Attribute(name,value) = " + attribute.getName() + " , " + attribute.getValue());
            ++n3;
        }
        return attributeList;
    }

    private int getSingleAttributeValueIndex(String string) {
        int n = -1;
        int n2 = 0;
        boolean bl = false;
        while (n2 < string.length()) {
            if (string.charAt(n2) == '\"') {
                if ((n2 = string.indexOf(34, n2 + 1)) == -1) {
                    return n2;
                }
                if (string.length() == n2) {
                    return -1;
                }
            } else if (string.charAt(n2) == '=' && string.charAt(n2 - 1) != '\\') {
                if (n2 == 0) {
                    return -1;
                }
                return n2;
            }
            ++n2;
        }
        return n2;
    }

    private String removeEscapeChars(String string) throws CommandValidationException {
        int n = 0;
        String string2 = string;
        String string3 = "";
        while (n < string2.length()) {
            int n2 = this.getDelimeterIndex(string2, String.valueOf('\\'), n);
            if (n2 == -1) {
                string3 = string3 + string2.substring(n);
                break;
            }
            string3 = string3 + string2.substring(n, n2);
            n = n2 + 1;
        }
        if (!string3.equals("") && string3.charAt(0) == '\"' && string3.charAt(string3.length() - 1) == '\"') {
            string3 = string3.substring(1, string3.length() - 1);
        }
        return string3;
    }

    private AttributeList setPrefixForAllAttributes(AttributeList attributeList) {
        Option option = this.findOption("prefix");
        if (option == null || option.getValue().equals("")) {
            return attributeList;
        }
        AttributeList attributeList2 = new AttributeList();
        String string = option.getValue();
        int n = 0;
        while (n < attributeList.size()) {
            Attribute attribute = (Attribute)attributeList.get(n);
            String string2 = string + "." + attribute.getName();
            Attribute attribute2 = new Attribute(string2, attribute.getValue());
            attributeList2.add(attribute2);
            ++n;
        }
        return attributeList2;
    }
}

