/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.servermodel.AppServerInstance;
import com.iplanet.ias.admin.servermodel.ServerInstanceManager;
import com.iplanet.ias.admin.servermodel.util.ServerModelIterator;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.tools.cli.BaseLifeCycleCommand;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;
import com.iplanet.ias.tools.cli.framework.Option;
import java.io.File;

public class ListInstancesCommand
extends BaseLifeCycleCommand {
    private static final String ADMIN_SERVER = "admin-server";

    public boolean validateOptions() throws CommandValidationException {
        boolean bl = super.validateOptions();
        if (!bl) {
            return bl;
        }
        if (this.isLocal()) {
            return true;
        }
        if (this.findOption("host") == null || this.findOption("port") == null || this.findOption("user") == null) {
            String string = null;
            Option option = this.findOption("host");
            string = this.findOption("host") == null ? "host" : (this.findOption("port") == null ? "port" : "user");
            throw new CommandValidationException(this.getLocalizedString("RequiredOptionsNotProvided", new Object[]{string}));
        }
        if (!this.isPasswordProvided()) {
            if (!this.isInteractive()) {
                throw new CommandValidationException(this.getLocalizedString("RequiredOptionsNotProvided", new Object[]{"password"}));
            }
            this.initPasswordOption();
        }
        return bl;
    }

    public void runCommand() throws CommandException, CommandValidationException {
        if (!this.validateOptions()) {
            return;
        }
        if (this.isLocal()) {
            String string = this.getDomain();
            Debug.println("Domain name = " + string);
            String string2 = this.getDomainLocation(string);
            Debug.println("Domain location = " + string2);
            if (!new File(string2).exists()) {
                throw new CommandException(this.getLocalizedString("DomainRootNotFound", new Object[]{string2}));
            }
            String[] stringArray = new File(string2).list();
            if (stringArray.length < 1) {
                this.printMessage(this.getLocalizedString("NoInstancesCreated"));
            }
            int n = 0;
            while (n < stringArray.length) {
                String string3 = null;
                string3 = this.isInstanceAlreadyStarted(string, stringArray[n]) ? this.getLocalizedString("InstanceRunningStatus") : this.getLocalizedString("InstanceNotRunningStatus");
                this.printMessage(stringArray[n] + " <" + string3 + ">");
                ++n;
            }
        } else {
            try {
                ServerInstanceManager serverInstanceManager = this.getServerInstanceManager();
                ServerModelIterator serverModelIterator = serverInstanceManager.getAllServerInstances();
                if (!serverModelIterator.hasNext()) {
                    this.printMessage(this.getLocalizedString("NoInstancesCreated"));
                }
                while (serverModelIterator.hasNext()) {
                    AppServerInstance appServerInstance = (AppServerInstance)serverModelIterator.next();
                    String string = appServerInstance.getStatus();
                    this.printMessage(appServerInstance + " <" + string + ">");
                }
            }
            catch (Exception exception) {
                Debug.printStackTrace(exception);
                this.printError(this.getLocalizedString("CannotListInstances"));
                throw new CommandException(exception.getLocalizedMessage());
            }
        }
        Debug.println(this.getClass().getName() + " : Command executed");
    }
}

