/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.servermodel.AppServerInstance;
import com.iplanet.ias.admin.servermodel.Controllable;
import com.iplanet.ias.admin.servermodel.ServerInstanceManager;
import com.iplanet.ias.admin.servermodel.beans.ServerComponent;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.tools.cli.BaseOtherCommand;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;
import com.iplanet.ias.tools.cli.framework.Operand;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.AttributeList;

public class CreateLifeCycleModuleCommand
extends BaseOtherCommand {
    private static final String CLASS_NAME = "classname";
    private static final String CLASS_PATH = "classpath";
    private static final String LOAD_ORDER = "loadorder";
    private static final String FAILURE_FATAL = "failurefatal";
    private static final String DESCRIPTION = "description";
    private static final String ENABLED = "enabled";

    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    public void runCommand() throws CommandException, CommandValidationException {
        Object object;
        Controllable controllable;
        AppServerInstance appServerInstance = null;
        String string = null;
        AttributeList attributeList = null;
        if (!this.validateOptions()) {
            return;
        }
        try {
            controllable = this.getServerInstanceManager();
            appServerInstance = ((ServerInstanceManager)controllable).getServerInstance(this.getInstanceOption());
            object = this.findOption(CLASS_NAME).getValue();
            string = ((Operand)this.getOperands().get(0)).getName();
            attributeList = this.getAttributeList();
            appServerInstance.createLifeCycleModule(string, (String)object);
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printError(this.getLocalizedString("CannotCreateLifeCycleModule"));
            throw new CommandException(exception.getLocalizedMessage());
        }
        this.printMessage(this.getLocalizedString("CreatedLifeCycleModule") + " = " + string);
        try {
            if (attributeList != null && !attributeList.isEmpty()) {
                controllable = appServerInstance.getLifeCycleModule(string);
                object = ((ServerComponent)controllable).setAttributes(attributeList);
                this.validateAttributeList(attributeList, (AttributeList)object);
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printError(this.getLocalizedString("UseDefaultAttribute"));
            throw new CommandException(exception.getLocalizedMessage());
        }
        Debug.println(this.getClass().getName() + " : Command executed");
    }

    private AttributeList getAttributeList() throws CommandValidationException {
        Serializable serializable;
        AttributeList attributeList = new AttributeList();
        if (this.findOption(CLASS_PATH) != null) {
            serializable = new Attribute("classPath", this.getOptionValue(CLASS_PATH));
            attributeList.add((Attribute)serializable);
        }
        if (this.findOption(LOAD_ORDER) != null) {
            serializable = new Attribute("loadOrder", this.getIntegerOptionValue(LOAD_ORDER));
            attributeList.add((Attribute)serializable);
        }
        if (this.findOption(FAILURE_FATAL) != null) {
            serializable = new Attribute("isFailureFatal", this.getBooleanOptionValue(FAILURE_FATAL));
            attributeList.add((Attribute)serializable);
        }
        if (this.findOption(DESCRIPTION) != null) {
            serializable = new Attribute(DESCRIPTION, this.getOptionValue(DESCRIPTION));
            attributeList.add((Attribute)serializable);
        }
        if (this.findOption(ENABLED) != null) {
            serializable = new Attribute(ENABLED, this.getBooleanOptionValue(ENABLED));
            attributeList.add((Attribute)serializable);
        }
        if (!((Properties)(serializable = this.getProperties())).isEmpty()) {
            String string = "property.";
            Enumeration<?> enumeration = ((Properties)serializable).propertyNames();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String string3 = (String)((Properties)serializable).get(string2);
                Attribute attribute = new Attribute(string + string2, string3);
                attributeList.add(attribute);
                Debug.println("Property(name,value) = " + string2 + " , " + string3);
            }
        }
        return attributeList;
    }
}

