/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.servermodel.AppServerInstance;
import com.iplanet.ias.admin.servermodel.ServerInstanceManager;
import com.iplanet.ias.admin.servermodel.beans.ServerComponent;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.tools.cli.BaseResourceCommand;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;
import com.iplanet.ias.tools.cli.framework.Operand;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.AttributeList;

public class CreateJDBCConnectionPoolCommand
extends BaseResourceCommand {
    private static final String DATA_SOURCE_CLASS = "datasourceclassname";
    private static final String RES_TYPE = "restype";
    private static final String STEADY_POOL_SIZE = "steadypoolsize";
    private static final String MAX_POOL_SIZE = "maxpoolsize";
    private static final String MAX_WAIT = "maxwait";
    private static final String POOL_RESIZE = "poolresize";
    private static final String IDLE_TIMEOUT = "idletimeout";
    private static final String TRANS_ISOLATION_LEVEL = "isolationlevel";
    private static final String IS_ISOLATION_GUARANTEED = "isisolationguaranteed";
    private static final String IS_CONNECTION_VALIDATE_REQ = "isconnectvalidatereq";
    private static final String VALIDATION_METHOD = "validationmethod";
    private static final String VALIDATION_TABLE = "validationtable";
    private static final String FAIL_CONNECTION = "failconnection";
    private static final String DESCRIPTION = "description";
    private static final String AUTO_COMMIT = "auto-commit";
    private static final String META_DATA = "meta-data";
    private static final String TABLE = "table";
    private static final String UNCOMMITTED = "read-uncommitted";
    private static final String COMMITTED = "read-committed";
    private static final String REPEATABLE = "repeatable-read";
    private static final String SERIALIZABLE = "serializable";

    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    public void runCommand() throws CommandException, CommandValidationException {
        Object object;
        Object object2;
        AppServerInstance appServerInstance = null;
        String string = null;
        AttributeList attributeList = null;
        if (!this.validateOptions()) {
            return;
        }
        try {
            object2 = this.findOption(DATA_SOURCE_CLASS).getValue();
            string = ((Operand)this.getOperands().get(0)).getName();
            attributeList = this.getAttributeList(string);
            object = this.getServerInstanceManager();
            appServerInstance = ((ServerInstanceManager)object).getServerInstance(this.getInstanceOption());
            appServerInstance.createJDBCConnectionPool(string, (String)object2);
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printError(this.getLocalizedString("CannotCreateConnectionPool"));
            throw new CommandException(exception.getLocalizedMessage());
        }
        this.printMessage(this.getLocalizedString("CreatedConnectionPool") + " = " + string);
        try {
            if (attributeList != null && !attributeList.isEmpty()) {
                object2 = appServerInstance.getJDBCConnectionPool(string);
                object = ((ServerComponent)object2).setAttributes(attributeList);
                this.validateAttributeList(attributeList, (AttributeList)object);
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printError(this.getLocalizedString("UseDefaultAttribute"));
            throw new CommandException(exception.getLocalizedMessage());
        }
        Debug.println(this.getClass().getName() + " : Command executed");
    }

    private AttributeList getAttributeList(String string) throws CommandValidationException {
        Object object;
        Object object2;
        AttributeList attributeList = new AttributeList();
        if (this.findOption(RES_TYPE) != null) {
            object2 = new Attribute("resType", this.getOptionValue(RES_TYPE));
            attributeList.add((Attribute)object2);
        }
        if (this.findOption(STEADY_POOL_SIZE) != null) {
            object2 = new Attribute("steadyPoolSize", this.getIntegerOptionValue(STEADY_POOL_SIZE));
            attributeList.add((Attribute)object2);
        }
        if (this.findOption(MAX_POOL_SIZE) != null) {
            object2 = new Attribute("maxPoolSize", this.getIntegerOptionValue(MAX_POOL_SIZE));
            attributeList.add((Attribute)object2);
        }
        if (this.findOption(MAX_WAIT) != null) {
            object2 = new Attribute("maxWaitTime", this.getIntegerOptionValue(MAX_WAIT));
            attributeList.add((Attribute)object2);
        }
        if (this.findOption(POOL_RESIZE) != null) {
            object2 = new Attribute("resizeValue", this.getIntegerOptionValue(POOL_RESIZE));
            attributeList.add((Attribute)object2);
        }
        if (this.findOption(IDLE_TIMEOUT) != null) {
            object2 = new Attribute("idleTimeout", this.getIntegerOptionValue(IDLE_TIMEOUT));
            attributeList.add((Attribute)object2);
        }
        if (this.findOption(TRANS_ISOLATION_LEVEL) != null) {
            object2 = this.getOptionValue(TRANS_ISOLATION_LEVEL);
            if (!(object2 == null || ((String)object2).equalsIgnoreCase(UNCOMMITTED) || ((String)object2).equalsIgnoreCase(COMMITTED) || ((String)object2).equalsIgnoreCase(REPEATABLE) || ((String)object2).equalsIgnoreCase(SERIALIZABLE))) {
                throw new CommandValidationException(this.getLocalizedString("InvalidIsolationLevel", new Object[]{object2}));
            }
            object = new Attribute("transactionIsolationLevel", this.getOptionValue(TRANS_ISOLATION_LEVEL));
            attributeList.add((Attribute)object);
        }
        if (this.findOption(IS_ISOLATION_GUARANTEED) != null) {
            object2 = new Attribute("isIsolationLevelGuaranteed", this.getBooleanOptionValue(IS_ISOLATION_GUARANTEED));
            attributeList.add((Attribute)object2);
        }
        if (this.findOption(IS_CONNECTION_VALIDATE_REQ) != null) {
            object2 = new Attribute("isValidationRequired", this.getBooleanOptionValue(IS_CONNECTION_VALIDATE_REQ));
            attributeList.add((Attribute)object2);
        }
        if (this.findOption(VALIDATION_METHOD) != null) {
            object2 = this.getOptionValue(VALIDATION_METHOD);
            if (!(object2 == null || ((String)object2).equalsIgnoreCase(AUTO_COMMIT) || ((String)object2).equalsIgnoreCase(META_DATA) || ((String)object2).equalsIgnoreCase(TABLE))) {
                throw new CommandValidationException(this.getLocalizedString("InvalidValidationMethod", new Object[]{object2}));
            }
            object = new Attribute("validationMethod", object2);
            attributeList.add((Attribute)object);
        }
        if (this.findOption(VALIDATION_TABLE) != null) {
            object2 = new Attribute("validationTable", this.getOptionValue(VALIDATION_TABLE));
            attributeList.add((Attribute)object2);
        }
        if (this.findOption(FAIL_CONNECTION) != null) {
            object2 = new Attribute("failAll", this.getBooleanOptionValue(FAIL_CONNECTION));
            attributeList.add((Attribute)object2);
        }
        if (this.findOption(DESCRIPTION) != null) {
            object2 = new Attribute(DESCRIPTION, this.getOptionValue(DESCRIPTION));
            attributeList.add((Attribute)object2);
        }
        object2 = this.getProperties();
        object = ((Properties)object2).propertyNames();
        while (object.hasMoreElements()) {
            String string2 = (String)object.nextElement();
            String string3 = (String)((Properties)object2).get(string2);
            Attribute attribute = new Attribute("property." + string2, string3);
            attributeList.add(attribute);
            Debug.println("Property(name,value) = " + string2 + " , " + string3);
        }
        return attributeList;
    }
}

