/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.servermodel.AppServerInstance;
import com.iplanet.ias.admin.servermodel.Controllable;
import com.iplanet.ias.admin.servermodel.ServerInstanceManager;
import com.iplanet.ias.admin.servermodel.beans.HttpServiceComponentBean;
import com.iplanet.ias.admin.servermodel.beans.ServerComponent;
import com.iplanet.ias.admin.servermodel.beans.VirtualServer;
import com.iplanet.ias.admin.servermodel.beans.VirtualServerClass;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.tools.cli.BaseOtherCommand;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;
import com.iplanet.ias.tools.cli.framework.Operand;
import com.iplanet.ias.tools.cli.framework.Option;
import javax.management.Attribute;
import javax.management.AttributeList;

public class CreateAuthDBCommand
extends BaseOtherCommand {
    private static final String VS_CLASS_ID = "defaultclass";
    private static final String BASE_DN = "basedn";
    private static final String CERT_MAPS = "certmaps";

    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    public void runCommand() throws CommandException, CommandValidationException {
        Object object;
        Controllable controllable;
        VirtualServer virtualServer = null;
        String string = null;
        AttributeList attributeList = null;
        if (!this.validateOptions()) {
            return;
        }
        try {
            controllable = this.getServerInstanceManager();
            object = this.getVirtualServerOption();
            String string2 = this.getDatabaseOption();
            string = ((Operand)this.getOperands().get(0)).getName();
            attributeList = this.getAttributeList();
            AppServerInstance appServerInstance = ((ServerInstanceManager)controllable).getServerInstance(this.getInstanceOption());
            HttpServiceComponentBean httpServiceComponentBean = appServerInstance.getHttpService();
            VirtualServerClass virtualServerClass = httpServiceComponentBean.getVirtualServerClass(VS_CLASS_ID);
            virtualServer = virtualServerClass.getVirtualServer((String)object);
            virtualServer.createAuthDb(string, string2);
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printError(this.getLocalizedString("CannotCreateAuthDB"));
            throw new CommandException(exception.getLocalizedMessage());
        }
        this.printMessage(this.getLocalizedString("CreatedAuthDB", new Object[]{string}));
        try {
            if (attributeList != null && !attributeList.isEmpty()) {
                controllable = virtualServer.getAuthDb(string);
                object = ((ServerComponent)controllable).setAttributes(attributeList);
                this.validateAttributeList(attributeList, (AttributeList)object);
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printError(this.getLocalizedString("UseDefaultAttribute"));
            throw new CommandException(exception.getLocalizedMessage());
        }
        Debug.println(this.getClass().getName() + " : Command executed");
    }

    private String getVirtualServerOption() {
        Option option = this.findOption("virtualserver");
        String string = null;
        if (option != null) {
            string = option.getValue();
        }
        return string;
    }

    private String getDatabaseOption() {
        Option option = this.findOption("database");
        String string = null;
        if (option != null) {
            string = option.getValue();
        }
        return string;
    }

    private AttributeList getAttributeList() throws CommandValidationException {
        Attribute attribute;
        AttributeList attributeList = new AttributeList();
        if (this.findOption(BASE_DN) != null) {
            attribute = new Attribute(BASE_DN, this.getOptionValue(BASE_DN));
            attributeList.add(attribute);
        }
        if (this.findOption(CERT_MAPS) != null) {
            attribute = new Attribute(CERT_MAPS, this.getOptionValue(CERT_MAPS));
            attributeList.add(attribute);
        }
        return attributeList;
    }
}

