/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.tools.cli.IasCommand;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;
import com.iplanet.ias.tools.cli.framework.Option;
import javax.management.Attribute;
import javax.management.AttributeList;

public abstract class BaseConfigurationCommand
extends IasCommand {
    protected static final String SHORTHAND_DELIMETER = ":";
    protected static final char ESCAPE_CHAR = '\\';
    protected static final String APPEND_WITH_DELIMETER = ".";
    protected static final String QUOTE_CHAR = "\"";
    protected static final String SET_DELIMETER = "=";
    protected static final String MONITOR_OPTION = "monitor";

    protected int getDelimeterIndex(String string, String string2, int n) throws CommandValidationException {
        int n2 = string.indexOf(string2, n);
        int n3 = string.indexOf(QUOTE_CHAR, n);
        if (n3 != -1 && n2 != -1 && n3 < n2) {
            int n4 = string.indexOf(QUOTE_CHAR, n3 + 1);
            if (n4 == -1) {
                throw new CommandValidationException(this.getLocalizedString("UnclosedString"));
            }
            if (n4 != string.length() - 1) {
                return this.getDelimeterIndex(string, string2, n4 + 1);
            }
            return -1;
        }
        if (n2 > 0 && string.charAt(n2 - 1) == '\\') {
            return this.getDelimeterIndex(string, string2, n2 + 1);
        }
        return n2;
    }

    protected boolean isMonitoring() throws CommandValidationException {
        Option option = this.findOption(MONITOR_OPTION);
        String string = null;
        if (option != null) {
            string = option.getValue();
        }
        boolean bl = false;
        if (string == null) {
            throw new CommandValidationException(this.getLocalizedString("InvalidOptionValue") + ": " + option.getName().toLowerCase());
        }
        if (string.equalsIgnoreCase("true")) {
            bl = true;
        } else if (string.equalsIgnoreCase("false")) {
            bl = false;
        } else {
            throw new CommandValidationException(this.getLocalizedString("InvalidOptionValue") + ": " + option.getName().toLowerCase());
        }
        return bl;
    }

    protected void validateAttributeList(AttributeList attributeList, AttributeList attributeList2) throws CommandException {
        if (attributeList2 != null) {
            int n = 0;
            while (n < attributeList.size()) {
                Attribute attribute = (Attribute)attributeList.get(n);
                String string = this.getAttributeValueByName(attributeList2, attribute.getName());
                if (string == null) {
                    throw new CommandException(this.getLocalizedString("CannotSetAttribute"));
                }
                if (!string.equals(attribute.getValue().toString())) {
                    throw new CommandException(this.getLocalizedString("UnableToSetAttribute", new Object[]{attribute.getName(), attribute.getValue().toString()}));
                }
                ++n;
            }
        } else {
            throw new CommandException(this.getLocalizedString("CannotSetAttribute"));
        }
    }

    private String getAttributeValueByName(AttributeList attributeList, String string) {
        int n = 0;
        while (n < attributeList.size()) {
            Attribute attribute = (Attribute)attributeList.get(n);
            if (string.endsWith(attribute.getName())) {
                return attribute.getValue().toString();
            }
            ++n;
        }
        return null;
    }
}

