/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.servermodel.controllers;

import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.servermodel.beans.IiopListener;
import com.iplanet.ias.admin.servermodel.context.ContextHolder;
import com.iplanet.ias.admin.servermodel.controllers.Controller;
import com.iplanet.ias.admin.servermodel.controllers.SOMRequestDispatcher;
import com.iplanet.ias.admin.util.ArgChecker;
import com.iplanet.ias.admin.util.Assert;
import com.iplanet.ias.admin.util.StringValidator;
import javax.management.ObjectName;

public class IiopListenerComponentController
implements Controller {
    private static final String IS_SSL_CREATED = "isSslCreated";
    private static final String CREATE_SSL = "createSsl";
    private static final String DELETE_SSL = "deleteSsl";
    private IiopListener component;

    public IiopListenerComponentController(IiopListener iiopListener) {
        this.component = iiopListener;
    }

    public boolean isSSLCreated() throws AFException {
        Object object = this.invoke(IS_SSL_CREATED, null, null);
        Assert.assertit(object != null, "null value returned");
        return (Boolean)object;
    }

    public void createSSL(String string) throws AFException {
        ArgChecker.checkValid(string, "certNickName", StringValidator.getInstance());
        String[] stringArray = new String[]{"java.lang.String", "java.lang.Boolean", "java.lang.String", "java.lang.Boolean", "java.lang.String", "java.lang.Boolean", "java.lang.Boolean", "java.lang.Boolean"};
        Object[] objectArray = new Object[]{string, null, null, null, null, null, null, null};
        this.invoke(CREATE_SSL, objectArray, stringArray);
    }

    public void deleteSSL() throws AFException {
        this.invoke(DELETE_SSL, null, null);
    }

    private Object invoke(String string, Object[] objectArray, String[] stringArray) throws AFException {
        try {
            ContextHolder contextHolder = this.component.getContextHolder();
            ObjectName objectName = new ObjectName(this.component.getIdentifier());
            SOMRequestDispatcher sOMRequestDispatcher = SOMRequestDispatcher.getDispatcher(contextHolder);
            return sOMRequestDispatcher.invoke(objectName, string, objectArray, stringArray);
        }
        catch (Exception exception) {
            if (exception instanceof AFException) {
                throw (AFException)exception;
            }
            throw new AFException(exception.getLocalizedMessage());
        }
    }
}

