/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.servermodel.controllers;

import com.iplanet.ias.admin.common.ObjectNames;
import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.servermodel.beans.ACL;
import com.iplanet.ias.admin.servermodel.beans.HttpListener;
import com.iplanet.ias.admin.servermodel.beans.HttpServiceComponentBean;
import com.iplanet.ias.admin.servermodel.beans.Mime;
import com.iplanet.ias.admin.servermodel.context.ContextHolder;
import com.iplanet.ias.admin.servermodel.controllers.Controller;
import com.iplanet.ias.admin.servermodel.controllers.SOMRequestDispatcher;
import com.iplanet.ias.admin.servermodel.util.ServerModelIterator;
import com.iplanet.ias.admin.util.ArgChecker;
import com.iplanet.ias.admin.util.Assert;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.admin.util.StringValidator;
import java.util.Vector;
import javax.management.ObjectName;

public class HttpServiceComponentController
implements Controller {
    private static final String CREATE_HTTP_LISTENER = "createHTTPListener";
    private static final String DELETE_HTTP_LISTENER = "deleteHTTPListener";
    private static final String LIST_HTTP_LISTENERS = "listHTTPListeners";
    private static final String CREATE_HTTP_QOS = "createHttpQos";
    private static final String DELETE_HTTP_QOS = "deleteHttpQos";
    private static final String IS_HTTP_QOS_CREATED = "isHttpQosCreated";
    private static final String CREATE_MIME = "createMime";
    private static final String DELETE_MIME = "deleteMime";
    private static final String LIST_MIMES = "listMimes";
    private static final String CREATE_ACL = "createAcl";
    private static final String DELETE_ACL = "deleteAcl";
    private static final String LIST_ACLS = "listAcls";
    private HttpServiceComponentBean component;

    public HttpServiceComponentController(HttpServiceComponentBean httpServiceComponentBean) {
        this.component = httpServiceComponentBean;
    }

    public void createHttpListener(String string, String string2, int n, String string3, String string4) throws AFException {
        ArgChecker.checkValid(string, "id", StringValidator.getInstance());
        ArgChecker.checkValid(string2, "address", StringValidator.getInstance());
        ArgChecker.checkValid(string3, "defaultVirtualServer", StringValidator.getInstance());
        ArgChecker.checkValid(string4, "serverName", StringValidator.getInstance());
        Object[] objectArray = new Object[]{string, string2, new Integer(n), null, null, null, null, null, string3, string4};
        String[] stringArray = new String[]{"java.lang.String", "java.lang.String", "java.lang.Integer", "java.lang.Boolean", "java.lang.String", "java.lang.Integer", "java.lang.Boolean", "java.lang.Boolean", "java.lang.String", "java.lang.String"};
        this.invoke(CREATE_HTTP_LISTENER, objectArray, stringArray);
    }

    public void deleteHttpListener(String string) throws AFException {
        ArgChecker.checkValid(string, "id", StringValidator.getInstance());
        Object[] objectArray = new Object[]{string};
        String[] stringArray = new String[]{"java.lang.String"};
        this.invoke(DELETE_HTTP_LISTENER, objectArray, stringArray);
    }

    public ServerModelIterator getHttpListeners() throws AFException {
        Vector<HttpListener> vector = new Vector<HttpListener>();
        String[] stringArray = (String[])this.invoke(LIST_HTTP_LISTENERS, null, null);
        if (stringArray != null && stringArray.length > 0) {
            String string = this.component.getInstanceName();
            Assert.assertit(string != null, "null value returned");
            int n = 0;
            while (n < stringArray.length) {
                ObjectName objectName = ObjectNames.getHttpListenerObjectName(string, stringArray[n]);
                Assert.assertit(objectName != null, "null value returned");
                Debug.println("HttpServiceComponentController.getHttpListeners : Http listener objectname = " + objectName);
                HttpListener httpListener = new HttpListener(objectName.toString(), stringArray[n]);
                httpListener.setContextHolder(this.component.getContextHolder());
                vector.add(httpListener);
                ++n;
            }
        }
        return new ServerModelIterator(vector);
    }

    public boolean isHttpQosCreated() throws AFException {
        Boolean bl = (Boolean)this.invoke(IS_HTTP_QOS_CREATED, null, null);
        Assert.assertit(bl != null, "null value returned");
        return bl;
    }

    public void createHttpQos() throws AFException {
        String[] stringArray = new String[]{"java.lang.String", "java.lang.Boolean", "java.lang.String", "java.lang.Boolean"};
        Object[] objectArray = new Object[]{null, null, null, null};
        this.invoke(CREATE_HTTP_QOS, objectArray, stringArray);
    }

    public void removeHttpQos() throws AFException {
        this.invoke(DELETE_HTTP_QOS, null, null);
    }

    public void createMime(String string, String string2) throws AFException {
        ArgChecker.checkValid(string, "id", StringValidator.getInstance());
        ArgChecker.checkValid(string2, "file", StringValidator.getInstance());
        String[] stringArray = new String[]{"java.lang.String", "java.lang.String"};
        Object[] objectArray = new Object[]{string, string2};
        this.invoke(CREATE_MIME, objectArray, stringArray);
    }

    public void removeMime(String string) throws AFException {
        ArgChecker.checkValid(string, "id", StringValidator.getInstance());
        String[] stringArray = new String[]{"java.lang.String"};
        Object[] objectArray = new Object[]{string};
        this.invoke(DELETE_MIME, objectArray, stringArray);
    }

    public ServerModelIterator getMimes() throws AFException {
        String[] stringArray = (String[])this.invoke(LIST_MIMES, null, null);
        Vector<Mime> vector = new Vector<Mime>();
        if (stringArray != null && stringArray.length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                String string = this.component.getInstanceName();
                ObjectName objectName = ObjectNames.getMimeObjectName(string, stringArray[n]);
                Assert.assertit(objectName != null, "null value returned");
                Debug.println("HttpServiceComponentController.getMimes: mbean = " + objectName);
                Mime mime = new Mime(objectName.toString(), stringArray[n]);
                mime.setContextHolder(this.component.getContextHolder());
                vector.add(mime);
                ++n;
            }
        }
        return new ServerModelIterator(vector);
    }

    public void createAcl(String string, String string2) throws AFException {
        ArgChecker.checkValid(string, "id", StringValidator.getInstance());
        ArgChecker.checkValid(string2, "file", StringValidator.getInstance());
        String[] stringArray = new String[]{"java.lang.String", "java.lang.String"};
        Object[] objectArray = new Object[]{string, string2};
        this.invoke(CREATE_ACL, objectArray, stringArray);
    }

    public void removeAcl(String string) throws AFException {
        ArgChecker.checkValid(string, "id", StringValidator.getInstance());
        String[] stringArray = new String[]{"java.lang.String"};
        Object[] objectArray = new Object[]{string};
        this.invoke(DELETE_ACL, objectArray, stringArray);
    }

    public ServerModelIterator getAcls() throws AFException {
        String[] stringArray = (String[])this.invoke(LIST_ACLS, null, null);
        Vector<ACL> vector = new Vector<ACL>();
        if (stringArray != null && stringArray.length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                String string = this.component.getInstanceName();
                ObjectName objectName = ObjectNames.getAclObjectName(string, stringArray[n]);
                Assert.assertit(objectName != null, "null value returned");
                Debug.println("HttpServiceComponentController.getAcls: mbean = " + objectName);
                ACL aCL = new ACL(objectName.toString(), stringArray[n]);
                aCL.setContextHolder(this.component.getContextHolder());
                vector.add(aCL);
                ++n;
            }
        }
        return new ServerModelIterator(vector);
    }

    private Object invoke(String string, Object[] objectArray, String[] stringArray) throws AFException {
        try {
            ContextHolder contextHolder = this.component.getContextHolder();
            ObjectName objectName = new ObjectName(this.component.getIdentifier());
            SOMRequestDispatcher sOMRequestDispatcher = SOMRequestDispatcher.getDispatcher(contextHolder);
            return sOMRequestDispatcher.invoke(objectName, string, objectArray, stringArray);
        }
        catch (Exception exception) {
            if (exception instanceof AFException) {
                throw (AFException)exception;
            }
            throw new AFException(exception.getLocalizedMessage());
        }
    }
}

