/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.comm;

import com.iplanet.ias.admin.comm.HttpConnectorAddress;
import com.iplanet.ias.admin.comm.IConnection;
import com.iplanet.ias.admin.util.Debug;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.net.UnknownHostException;

class ServletConnection
implements IConnection {
    static final String UNKNOWN_HOST = "Unknown host : ";
    static final String INVALID_HOST_PORT = "Unable to connect to admin-server.  Please check if the server is up and running and that the host and port provided are correct.";
    static final String UNAUTHORIZED_ACCESS = "Invalid user or password";
    private URLConnection mConnection = null;
    private ObjectOutputStream mObjectOutStream = null;
    private ObjectInputStream mObjectInStream = null;

    ServletConnection(HttpConnectorAddress httpConnectorAddress) throws IOException {
        try {
            this.mConnection = httpConnectorAddress.openConnection("/web1/entry");
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
    }

    public Object receive() throws IOException, ClassNotFoundException {
        Object object = null;
        try {
            this.mObjectInStream = new ObjectInputStream(new BufferedInputStream(this.mConnection.getInputStream()));
            object = this.mObjectInStream.readObject();
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
        return object;
    }

    public void send(Serializable serializable) throws IOException {
        try {
            this.mObjectOutStream = new ObjectOutputStream(new BufferedOutputStream(this.mConnection.getOutputStream()));
            this.mObjectOutStream.writeObject(serializable);
            this.mObjectOutStream.flush();
            this.mObjectOutStream.close();
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
    }

    public void close() {
        try {
            this.mObjectInStream.close();
            this.mObjectOutStream.close();
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
        }
    }

    private void handleException(IOException iOException) throws IOException {
        int n;
        IOException iOException2 = null;
        iOException2 = iOException instanceof UnknownHostException ? new UnknownHostException(UNKNOWN_HOST + iOException.getMessage()) : (iOException instanceof ConnectException ? new ConnectException(INVALID_HOST_PORT) : ((n = ((HttpURLConnection)this.mConnection).getResponseCode()) == 401 ? new IOException(UNAUTHORIZED_ACCESS) : iOException));
        throw iOException2;
    }
}

