/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/*
 *	@(#)vnode_secpolicy.h	7.9	04/04/26
 */

#ifndef	_SYS_VNODE_SECPOLICY_H
#define	_SYS_VNODE_SECPOLICY_H

#pragma ident	"@(#)vnode_secpolicy.h	7.9	04/04/26 SMI; TSOL 2.x"

#include <sys/types.h>
#include <sys/vnode.h>
#include <sys/dirent.h>
#include <sys/pathname.h>
#include <sys/cred.h>
#include <sys/proc.h>
#include <sys/thread.h>
#include <sys/secpolicy.h>

#ifdef	__cplusplus
extern "C" {
#endif

int secpolicy_pathname_process_component(cred_t *, vnode_t *, char *,
	struct pathname *, vnode_t *, secpolicy_buf_t *);
int secpolicy_pathname_restore_component(cred_t *, vnode_t *, char *,
	vnode_t *, secpolicy_buf_t *);
int secpolicy_pathname_search(cred_t *, vnode_t *, char *, enum symfollow,
	secpolicy_buf_t *);
void secpolicy_pathname_setlast(cred_t *, vnode_t *, struct pathname *,
	secpolicy_buf_t *);
int secpolicy_vnode_access(cred_t *, vnode_t *, mode_t);
int secpolicy_vnode_attach(cred_t *, vnode_t *, vnode_t *, int);
int secpolicy_vnode_attr_modify(cred_t *, vnode_t *);
int secpolicy_vnode_check_attr(cred_t *, vnode_t *, vattr_t *, char *);
int secpolicy_vnode_data_modify(cred_t *, vnode_t *);
int secpolicy_vnode_destroy(cred_t *, vnode_t *, vnode_t *);
int secpolicy_vnode_dirdata_read(cred_t *, vnode_t *, dirent64_t *);
int secpolicy_vnode_get_attr(cred_t *, vnode_t *, vsecattr_t *, int);
int secpolicy_vnode_mknod(cred_t *, void *);
int secpolicy_vnode_modify(cred_t *, vnode_t *);
int secpolicy_vnode_modify_lncnt(cred_t *, vnode_t *);
int secpolicy_vnode_read(cred_t *, vnode_t *);
int secpolicy_vnode_rename(cred_t *, vnode_t *, vnode_t *);
int secpolicy_vnode_search(cred_t *, vnode_t *);
int secpolicy_vnode_traverse(cred_t *, vnode_t *);
int secpolicy_vnode_setid_retain(cred_t *, vnode_t *);

#define	POLICY_FLAG2NAME(f)	((char *)((f) & (FREAD|FWRITE)))
#define	POLICY_NAME2FLAG(n)	((long)(n))

#ifdef	__cplusplus
}
#endif

#endif	/* _SYS_VNODE_SECPOLICY_H */
