/*
 * Copyright 1995-2003 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#ifndef	_SYS_TSOL_TNET_H
#define	_SYS_TSOL_TNET_H

#pragma ident	"@(#)tnet.h	7.46	03/10/16 SMI; TSOL 2.x"

#include <sys/types.h>
#include <sys/param.h>
#include <sys/systm.h>
#include <sys/cred.h>
#include <inet/common.h>
#include <sys/stream.h>
#include <sys/strlog.h>
#include <inet/ip.h>
#include <inet/ip6.h>
#include <sys/tsol/priv.h>
#include <sys/tsol/pattr.h>
#include <sys/tsol/t6attrs.h>
#include <sys/tsol/tstream.h>
#include <sys/tsol/t6kernel.h>
#include <inet/tcp.h>

#ifdef	__cplusplus
extern "C" {
#endif

#define	WRATTR_OK	0x0001		/* sc_wr_attr pass host accred */
#define	RDATTR_OK	0x0002		/* sc_rd_attr pass host accred */
#define	TSOLNET		0x0004		/* tsol connection */

#define	TCP_CONNECTION	0x0001		/* tsol_seccom is for TCP stream */
#define	TL_SECCOM	0x0004		/* sc_addr in tl address format */
#define	SC_VALID_ATTRS_IN_COMMON_MASK	0x0008 /* TSOL mask */
#define	SEND_ALL_ATTRIBUTES	0x0010

/* Max of the attributes present is a TSOL SAMP */
#define	T6M_ALL_SAMP_ATTR	(T6M_SL | T6M_IL | T6M_CLEARANCE |	\
    T6M_PRIVILEGES | T6M_PID | T6M_UID | T6M_GID | T6M_PROC_ATTR)

/* Trusted X server's privileged ports */
#define	TSOL_WIN_PORT_MIN	6000
#define	TSOL_WIN_PORT_MAX	6002

/* tnd port */
#define	TSOL_TND_PORT		5999

/*
 * Attributes Sources
 */
#define	ATTRSRC_MSG		0
#define	ATTRSRC_TCP_WR		1
#define	ATTRSRC_HDR_WR		2
#define	ATTRSRC_TCP_RD		3

/*
 * Defines for obtaining ptr to remote host template
 * based on dst, gateway, or src.
 */
#define	IRE_RHTP_DST		0
#define	IRE_RHTP_GATEWAY	1
#define	IRE_RHTP_SRC		2
/*
 * types of IRE lists
 */
typedef enum ire_list_type {
	IRE_HASH_TBL,
	IRE_ASSOC_HASH_TBL,
	IRE_SUBNET_LIST,
	IRE_NET_HASH_TBL,
	IRE_GATEWAY_LIST
} ire_list_type_t;

struct generic_SM_header {
	ushort_t	sm_type;	/* session mgmt protocol ID  */
	ushort_t	version;	/* version in ascii */
	uint_t		length;		/* amt data covered by samp and attr */
};

#define	SAMP_TYPE		2
#define	SAMP_VERSION		0x3031 /* TSIX samp version ascii 01 */
#define	TSOL_SAMP_VERSION	0x3054 /* TSOL samp version ascii 0T */

typedef enum samp_type {
	NO_SAMP = 0,
	TSOL_SAMP,
	TSIX_SAMP
} samp_type_t;

struct tsol_athdr {
	uchar_t		ath_type;	/* attr rep, raw or token */
	uchar_t		ath_rsv;	/* reserved */
#define	ath_modulate	ath_rsv
	ushort_t	ath_len;	/* length of attr list + hdr */
	uint_t		ath_dom;	/* domain of interpretation */
	uint_t		ath_gen;	/* generation id of tokens */
	t6mask_t	ath_mask;	/* attr specified in attr list */
};

#define	TSOL_NET_ATTR_UNDEF	0
#define	TSOL_NET_ATTR_RAW	1
#define	TSOL_NET_ATTR_TOKEN	2

struct tsol_null_hdr {
	uchar_t		nul_type;	/* attr rep, raw or token */
	uchar_t		nul_rsv;	/* reserved */
	ushort_t	nul_len;	/* length of attr list + hdr */
	uint_t		nul_dom;	/* domain of interpretation */
};

typedef struct tsol_pkt {
	struct generic_SM_header	tp_samp;
	struct tsol_athdr		tp_athdr;
	bslabel_t			tp_sl;
	uint_t				tp_sid;
	bclear_t			tp_clear;
	bilabel_t			tp_il;
	priv_set_t			tp_privs;
	pid_t				tp_pid;
	uid_t				tp_uid;
	gid_t				tp_gid;
	pattr_t				tp_pattrs;
} tsol_pkt_t;

typedef struct tsol_pkt_sl {
	struct generic_SM_header	tp_samp;
	struct tsol_athdr		tp_athdr;
	bslabel_t			tp_sl;
} tsol_pkt_sl_t;

#define	tsol_attr_wroff sizeof (tsol_pkt_t) /* max size of the packet */
#define	tsol_sl_only sizeof (tsol_pkt_sl_t) /* size of SAMP with an SL only */

#define	TSOL_HDR_SIZE	sizeof (struct generic_SM_header) \
			    + sizeof (struct tsol_athdr)

/*
 * Indicates whether Sensitivity Label came from SAMP header or
 * IP security option.
 */
#define	TSOL_SOURCE		1
#define	TSOL_FORWARDING_OR_DEST	2

/* IPv6 MLS options */

#define	SUN_FORMAT_ID	0x53554E57	/* ascii for "SUNW" */
#define	IP6OPT_MLS		10	/* Needed for user */

/* Common option header */
typedef struct mls_opt_s {
	uint32_t	mls_formatid;	/* Format identifier, "SUNW" for TS */
	uint16_t	mls_version;	/* version number */
	uint8_t		mls_type;	/* raw or tokenized attributes */
	uint8_t		mls_pad;	/* For alignment */
	t6mask_t	mls_mask;	/* attr specified in attr list */
	uint32_t	mls_doi;	/* Domain of interpretation */
} mls_opt_t;

/* Option data for TSOL (raw) attributes */
typedef struct tsol_opt_s {
	bslabel_t		tsop_sl;	/* sensitivily label */
	bclear_t		tsop_cl;	/* clearence */
	priv_set_t		tsop_priv;	/* privilege set */
	pid_t			tsop_pid;
	uid_t			tsop_uid;
	gid_t			tsop_gid;
	pattr_t			tsop_pattrs;	/* process attributes */
} tsol_opt_t;

/* Option data for TSIX (tokens) attributes */
typedef struct tsix_opt_s {
	uint32_t	tsix_genid;	/* generation ID */
	uint32_t	tsix_spam;	/* Data covered by these attibutes */
	/* Tokens to follow */
} tsix_opt_t;

/*
 * Skeleton of a full TSOL label an an IPv6 header extension (dst or h-b-h)
 * It contains 3 parts: the header description, the MLS option, and 4 padding
 * bytes
 */
typedef struct ts_ipv6_label_s {
	ip6_dest_t	ts_hdrhdr;	/* Description of the header */

	/* The MLS option: 2 bytes of description, then the option data */
	uchar_t		ts_mls_type;	/* Always MLS_OPT */
	uchar_t		ts_mls_len;	/* length of this option */
	mls_opt_t	ts_mls_opt_hdr;	/* The option header */
	tsol_opt_t	ts_mls_opt;	/* The attributes */

	/* the 4-byte PadN option */
	uchar_t		ts_pad_type;	/* Always PadN */
	uchar_t		ts_pad_len;	/* length of the padding */
	uchar_t		ts_pad_data[2];
} ts_ipv6_label_t;

extern ts_ipv6_label_t tsol_ipv6_hdr_ext;

/* Architecture-independent conversion macros for process attributes */

#if	defined(i386) || defined(__i386)
/*
 * Serious Hack Alert
 *	The process attribute structure includes bit fields.
 *	The compiler assignment of these fields is highly machine dependent.
 *	In order to put the process attributes into network order (read: sparc),
 *	we use the empirically derived pattr_i86_t structure.
 *	Note: we do not attempt to propogate the never-used paf_label_xlate
 *	attribute due to the mess incurred from occupying three separate bytes.
 */
#endif	/* i386 */

#if	defined(i386) || defined(__i386)
#define	NTOH_PATTR(pattr, strattr)					\
	/* translate to host order */					\
{									\
	pattr_t		*pap = CR_PATTR((strattr)->stra_credp);		\
	pattr_i86_t	*pi86p = (pattr_i86_t *)(pattr);		\
									\
	pap->paf_automounter = pi86p->paf_automounter;			\
	pap->paf_print_system = pi86p->paf_print_system;		\
	pap->paf_selagnt = pi86p->paf_selagnt;				\
	pap->paf_diskless_boot = pi86p->paf_diskless_boot;		\
	pap->paf_label_view = pi86p->paf_label_view;			\
	pap->paf_tokmapper = pi86p->paf_tokmapper;			\
	pap->paf_priv_debug = pi86p->paf_priv_debug;			\
	pap->paf_trusted_path = pi86p->paf_trusted_path;		\
}
#else
#define	NTOH_PATTR(pattr, strattr)					\
	*CR_PATTR((strattr)->stra_credp) = *(pattr);
#endif  /* i386 */

#if	defined(i386) || defined(__i386)
#define	HTON_PATTR(pattr, strattr)					\
{									\
	/* translate to network order */				\
	pattr_t		*pap = CR_PATTR((strattr)->stra_credp);		\
	pattr_i86_t	*pi86p = (pattr_i86_t *)&(pattr);		\
									\
	pi86p->paf_automounter = pap->paf_automounter;			\
	pi86p->paf_print_system = pap->paf_print_system;		\
	pi86p->paf_selagnt = pap->paf_selagnt;				\
	pi86p->paf_diskless_boot = pap->paf_diskless_boot;		\
	pi86p->paf_label_view = pap->paf_label_view;			\
	pi86p->paf_tokmapper = pap->paf_tokmapper;			\
	pi86p->paf_priv_debug = pap->paf_priv_debug;			\
	pi86p->paf_trusted_path = pap->paf_trusted_path;		\
}
#else
#define	HTON_PATTR(pattr, strattr)					\
	(pattr) = *CR_PATTR((strattr)->stra_credp);
#endif  /* i386 */

#ifdef _KERNEL
/*
 * IRE security attributes structure, pointed to by ire_attr
 */
typedef struct tsol_ire_attr {
	tsol_tnrhc_t	*tsol_ire_addr_rhc;	/* host entry for dst */
	tsol_tnrhc_t	*tsol_ire_gateway_rhc;	/* host entry for gateway */
	tsol_tnrhc_t	*tsol_ire_src_rhc;	/* host entry for src */
	emetric_t	*tsol_ire_emetric;	/* extended metric */
} tsol_ire_attr_t;

#define	DISKLESS_FLAG_OK(diskless_flag, rhtp, rhtp_type)	\
		(!(rhtp_type & CHECK_DISKLESS) || \
		(rhtp->tmpl_type == TMPL_NORMAL) || \
		(rhtp->host_type != UNLABELED) || \
		diskless_flag)

extern int servicing_interrupt();
extern int tsol_unlabeled_rt;

/* Will be a kernel varialble, until a number is acquired */
extern int mls_opt_value;

extern tsol_ifent_t	gifent;		/* Global default ifent */

/*
 * COPIED FROM ip.c WITH REGRET
 * Folowing macro is used whenever the code does not know whether there
 * is a M_CTL present in the front and it needs to examine the actual mp
 * i.e the IP header. As a M_CTL message could be in the front, this
 * extracts the packet into mp and the M_CTL mp into first_mp. If M_CTL
 * mp is not present, both first_mp and mp point to the same message.
 */
#define	EXTRACT_PKT_MP(mp, first_mp, mctl_present)	\
	(first_mp) = (mp);				\
	if ((mp)->b_datap->db_type == M_CTL) {		\
		(mp) = (mp)->b_cont;			\
		(mctl_present) = B_TRUE;		\
	} else {					\
		(mctl_present) = B_FALSE;		\
	}						\


#define	LLHDRLEN	16	/* Maxes most Logical Link headers' lengthes */

/*
 * Performance note: could be written very simply, but the arguments to these
 * macros are inet_netop() calls, and we try to avoid evaluating them when
 * ip_debug is off.
 */
extern ipparam_t **tsol_ip_param_arr;

#define	tsol_ip_debug	(*tsol_ip_param_arr)[6].ip_param_value
#define	tsol_unlab_equal_only	(*tsol_ip_param_arr)[45].ip_param_value
#define	IP_MOD_ID	5701	/* IP's module IP for streams tracing */
#define	TSOL_NET_TRACE1(fmt, s1)					 \
	if (tsol_ip_param_arr != NULL)  {				 \
		if (tsol_ip_debug > 0)					 \
			(void) strlog(IP_MOD_ID, 0, 0, SL_ERROR|SL_TRACE, \
			    fmt, s1);					 \
	} else								 \
		tsol_net_trace(1, fmt, s1, NULL, NULL);

#define	TSOL_NET_TRACE2(fmt, s1, s2)					 \
	if (tsol_ip_param_arr != NULL)  {				 \
		if (tsol_ip_debug > 0)					 \
			(void) strlog(IP_MOD_ID, 0, 0, SL_ERROR|SL_TRACE, \
			    fmt, s1, s2);				 \
	} else								 \
		tsol_net_trace(2, fmt, s1, s2, NULL);

#define	TSOL_NET_TRACE3(fmt, s1, s2, s3)				 \
	if (tsol_ip_param_arr != NULL)  {				 \
		if (tsol_ip_debug > 0)					 \
			(void) strlog(IP_MOD_ID, 0, 0, SL_ERROR|SL_TRACE, \
			    fmt, s1, s2, s3);				 \
	} else								 \
		tsol_net_trace(3, fmt, s1, s2, s3);


extern int	my_doi;			/* My domain of interpretation */

extern void tsol_net_trace(int, char *, char *, char *, char *);
extern boolean_t tsol_interface_chk(ire_t *, tsol_tpent_t *, bslabel_t *);
extern boolean_t tsol_mi_timer_valid(mblk_t *);
extern emetric_t *create_emetric_fromtp(tsol_tpent_t *);
extern int tsol_add_sec_options(mblk_t **, tsol_strattr_t *, tsol_tpent_t *,
    int *);
extern enum tsol_return_status tsol_ip_hook(mblk_t *, void *, uchar_t,
    uchar_t *, ire_t *, struct tsol_tpent *, accred_flag_t);
extern int add_cipso_option(mblk_t **, bslabel_t *, struct tsol_tpent *);
extern int add_ripso_option(mblk_t **, ripso_label_t *, struct tsol_tpent *);
extern int check_add_option(queue_t *q, struct tsol_tpent *, bslabel_t *,
    ripso_label_t *, mblk_t *, ire_t *, struct tsol_tpent **);
extern int check_remove_option(queue_t *q, mblk_t *mp, struct tsol_tpent *,
    bslabel_t *, ripso_label_t *, ire_t *);
extern int cipso_high(cipso_option_t *);
extern int get_sameattrs_len(mblk_t *, int, int *);
extern tsol_tpent_t *get_samp_type(mblk_t *, void *, uchar_t, samp_type_t *,
    boolean_t *);
extern int get_samplen(mblk_t *);
extern int is_rmt_broadcast(ipaddr_t);
extern int padcmp(caddr_t, caddr_t);
extern int ripso_error_label(tsol_tpent_t *, ripso_option_t *);
extern int ripso_error_label_sri(sri_t *, ripso_option_t *);
extern int ripso_labels_equal(ripso_label_t *, ripso_label_t *);
extern int tsol_bcastchk(ire_t *, mblk_t *);
extern int tsol_forward_bcast(queue_t *, mblk_t **, ire_t *);
extern int tsol_forward_ok(tsol_tpent_t *, tsol_tpent_t *, ill_t *);
extern int tsol_import_check(queue_t *, mblk_t *, ipha_t *, tsol_ip_label_t,
    uchar_t *, tsol_tpent_t *, tsol_tpent_t *);
extern int tsol_interrupt_check(queue_t *, queue_t *, mblk_t *);
extern int tsol_ip_hdr_complete(ipha_t *);
extern int tsol_ip_init_attrs(mblk_t *, tsol_strattr_t *, ipha_t *, uchar_t *,
    uchar_t *, tsol_tpent_t *, struct tsol_ifent *);
extern int tsix_ip_init_attrs(queue_t *, mblk_t *, uchar_t *, tsol_tpent_t *,
    tsol_ifent_t *);
extern int tsol_labelit(mblk_t **, tsol_strattr_t *, tsol_tpent_t *);
extern int tsol_tnif_chk(struct tsol_ifent *, bslabel_t *);
extern int tsol_tnrh_chk(tsol_tpent_t *, bslabel_t *, int);
extern int tsol_tnrh_credchk(tsol_tpent_t *, cred_t *, int);
extern ire_t *get_def_gateway(void);
extern ire_t **get_ire_list(ire_list_type_t);
extern ire_t **ire_net_irep(ipaddr_t);
extern mblk_t *tsol_mi_timer_alloc(size_t);
extern tsol_ifc_t *find_ifc(char *, int);
extern tsol_ip_label_t dest_expects_this_option(tsol_tpent_t *,
    ripso_label_t **);
extern tsol_strattr_t *combine_attrs(tsol_strattr_t *attrs,
    tsol_strattr_t *attrs1);
extern tsol_tnrhc_t *find_rhc(void *, uchar_t);
extern tsol_tnrhc_t *find_rhc_r(void *, uchar_t, boolean_t);
extern tsol_tpent_t *get_rhtp(queue_t *q, void *addr, uchar_t version);
extern tsol_tpent_t *get_rhtp_fromire(ire_t *, int, accred_flag_t *);
extern tsol_tpent_t *get_rhtp_fromtcpb(tcpb_t *, accred_flag_t *);
extern uint_t tsol_ip_csum_hdr(ipha_t *);
extern void cipso_to_sl(uchar_t *, bslabel_t *);
extern void remove_options(mblk_t *);
extern void tnet_init(void);
extern void tsix_init(void);
extern int tsol_dest_hook(mblk_t *, void *, tcp_t *, samp_type_t *, int *,
    ushort_t *, boolean_t);
extern void tsol_icmp_missing_option(queue_t *, mblk_t *, int);
extern void tsol_icmp_param_problem(queue_t *, mblk_t *, uint8_t);
extern void tsol_icmp_unreachable(queue_t *, mblk_t *, int);
extern void tsol_mi_timer(queue_t *, mblk_t *, clock_t);
extern void tsol_mi_timer_free(mblk_t *);
extern void tsol_t6_prev_attrs(tsol_strattr_t *, tsol_strattr_t *);
extern void tsol_tcp_rput_data(queue_t *, mblk_t *, int);
extern void tsol_tcp_xmit_ctl(char *, tcpb_t *, mblk_t *, uint32_t,
    uint32_t, int, uint_t);
extern int tsol_tcpw_hook(tcp_t *, mblk_t *, int, int, int, uint16_t);
extern int ripso_gateway_tntp(ripso_label_t *, tsol_tpent_t *);
extern int cipso_gateway_tntp(uchar_t *, int, tsol_tpent_t *);
extern int doi_check_okay(uchar_t *, ire_t *);
extern int check_label_relations(tsol_strattr_t *);
extern int ip_option_required(tsol_tpent_t *, emetric_t *);
extern int is_broadcast(void *, uchar_t);
extern int tsol_gatewaychk_emetric(emetric_t *, bslabel_t *);
extern int tsol_gatewaychk(tsol_tpent_t *, accred_flag_t, emetric_t *,
    bslabel_t *);
extern int ripso_gateway_emetric(ripso_label_t *, emetric_t *);
extern int cipso_gateway_emetric(uchar_t *, int, emetric_t *);
extern int ripso_gateway(ripso_label_t *, tsol_tpent_t *, emetric_t *);
extern int cipso_gateway(uchar_t *, int, tsol_tpent_t *, emetric_t *);
extern void tsol_do_checksum(mblk_t *, ipha_t *, uint_t);
extern int tsol_forward_import_check_opt(ill_t *, mblk_t *, tsol_ip_label_t,
    uchar_t *);
extern int attr_equivalent(tsol_strattr_t *, tsol_strattr_t *);
extern void tsol2tnet(caddr_t, tsol_strattr_t *, ulong_t, uint32_t);
extern void tsol2tnet_sl(caddr_t, tsol_strattr_t *, ulong_t, uint32_t);
extern void tsol2mlsopt(tsol_strattr_t *, ts_ipv6_label_t *, uint32_t);
extern tsol_strattr_t *mlsopt2tsol(uchar_t *);
extern void tsol_complete_attrs(tsol_strattr_t *, mblk_t *);
extern int tsol_tcp6_label(tcp_t *, tsol_strattr_t *);
extern tsol_ifc_t *get_src_ifc(ire_t *);
extern int tsol_apply_default(tsol_strattr_t *, struct tsol_ifent *,
    tsol_tpent_t *, ushort_t, int);
extern int tsol_accredchk_import(tsol_strattr_t *, struct tsol_ifent *,
    accred_flag_t, tsol_tpent_t *, accred_flag_t, ire_t *, uchar_t *);
extern void tnrhc_free(tsol_tnrhc_t *tnrhc);
extern void tsol_pr_addr_dbg(char *, int, const void *);
#endif /* _KERNEL */

#ifdef	__cplusplus
}
#endif

#endif	/* _SYS_TSOL_TNET_H */
