<?xml version="1.0"?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    <!-- 
        Stylesheet to convert EKE v2.0 XML Output to plain TEXT  
        Originally Created by Sumon Shahed on Nov 03, -2002 
    -->
    <xsl:output method="text" encoding="iso-8859-1" indent="yes"/>

    <!-- handle both old and new forms of generatedBy -->
    <xsl:template match="kaeresult">
********************************************************************************
* <xsl:choose><xsl:when test="generatedBy/app_name"><xsl:value-of select="generatedBy/app_name"/><xsl:if test="generatedBy/app_version"><xsl:text> (</xsl:text><xsl:value-of select="generatedBy/app_version"/><xsl:text>)</xsl:text></xsl:if><xsl:if test="generatedBy/app_distribution_channel"><xsl:text> </xsl:text><xsl:value-of select="generatedBy/app_distribution_channel"/></xsl:if></xsl:when>
              <xsl:otherwise><xsl:value-of select="generatedBy"/></xsl:otherwise></xsl:choose> *
********************************************************************************
	    <xsl:apply-templates select="*"/>

Sun Confidential/Proprietary Information.

This report contains Sun(TM) confidential information in which Sun claims 
trade secrets and other proprietary rights. The content is based upon Sun's 
proprietary technology and is being provided to you pursuant the terms of your 
SunSpectrum contract. By accepting a copy of this report, you agree to use it 
for internal purposes only.

Copyright 2002 Sun Microsystems, Inc.
================================ End Of Report =================================
    </xsl:template>



    <!-- Skip following elements -->
    <xsl:template match="generatedBy|customer_info|partner_info|field_eng_info|CRC">
	  <!-- No Info will be shown! -->
    </xsl:template>


    <!-- Process general_info -->
    <xsl:template match="general_info">
Report #                      : <xsl:value-of select="report_id/id"/>
Report Generation Date        : <xsl:value-of select="report_date/date/@GMT"/>
    </xsl:template>



    <!-- Process run result -->
	<xsl:template match="runresult">
Knowledge Automation Engine   : <xsl:value-of select="kae_version"/>
	    <xsl:apply-templates select="run_info"/>
    </xsl:template>


    <xsl:template match="run_info">

================================================================================
= SYSTEM INFORMATION                                                           =
================================================================================
System Type   : <xsl:value-of select="run_system_info/@type"/>
Explorer Data : <xsl:value-of select="input_data/explorerFile"/>

        <xsl:apply-templates select="run_system_info/cluster_info"/>
        <xsl:apply-templates select="run_system_info/host_info"/>

		<xsl:apply-templates select="run_summary"/>

================================================================================
= ANALYSIS DETAILS                                                             =
================================================================================
		<xsl:apply-templates select="checkresult" mode="main"/>


    </xsl:template>

    <xsl:template match="run_system_info/cluster_info">
CLUSTERID     : <xsl:value-of select="clusterid"/>
CLUSTER_NAME  : <xsl:value-of select="cluster_name"/>
CLUSTER_NODES : <xsl:value-of select="cluster_nodes"/>
    </xsl:template>

    <xsl:template match="run_system_info/host_info">
HOSTID        : <xsl:value-of select="hostid"/>
SERIAL_NUMBER : <xsl:value-of select="serial_number"/>
PRODUCT_TYPE  : <xsl:value-of select="product_type"/>
    </xsl:template>



    <!-- Process run_summary -->
	<xsl:template match="run_summary">

================================================================================
= ANALYSIS SUMMARY                                                             =
================================================================================
Critical : <xsl:value-of select="critical"/>
High     : <xsl:value-of select="high"/>
Medium   : <xsl:value-of select="moderate"/>
Low      : <xsl:value-of select="low"/>
Passed   : <xsl:value-of select="passed"/>
N/A      : <xsl:value-of select="notapplicable"/>
Erroneous: <xsl:value-of select="erroneous"/>
Total    : <xsl:value-of select="total"/>
	</xsl:template>




    <!-- Process checkresult -->
    <xsl:template match="checkresult" mode="main">
	    <xsl:for-each select=".">
--------------------------------------------------------------------------------
CHECK ID: <xsl:value-of select="check_id/id"/>
SEVERITY: <xsl:value-of select="@severity"/>
STATUS  : <xsl:value-of select="@status"/>
<!-- PRODUCT : System Management - Software -->
PROBLEM : <xsl:value-of select="description"/>
ANALYSIS:
<xsl:value-of select="analysis"/>
RECOMMENDATIONS:
<xsl:value-of select="recommendations"/>
	    </xsl:for-each>
    </xsl:template>

</xsl:stylesheet>

