<?xml version="1.0"?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

  <xsl:output method="html" indent="yes"/>
  
  <xsl:output cdata-section-elements="analysis recommendations"/>
  
    <!-- Stylesheet to convert EKE v2.0 XML Output to HTML 
    Originally Created by Hans Zeiler on Aug-13-2002 
    Modified by David Loeffler Oct-11-2002 
                to do sorting by severity and check id and 
                add a table of contents. 
    -->
      
  <!-- START OF <xsl:include href="SunRBYHtmlHeading.xsl"/> -->
  <!-- 
      This is BAD. Should be included as above. If any change has been 
      make here or in "SunRBYHtmlHeading.xsl", they should be synchronized 
      in both places.
  -->
  <xsl:template name="heading">
    <HEAD>
      <META http-equiv="Content-Type" content="text/html; charset=iso-8859-1"/>
        <xsl:comment>
          This field is automatically generated from checkresults xml file 
          created by suncheckup.
          Call Andy to get more information.
        </xsl:comment>
	<TITLE>Sun(TM) Embedded Knowledge Engine System Check Results</TITLE>
	<style type="text/css">
	  &lt;!-- 
	  body,th,td,p,div,span,a,input,select,textarea,form,ul,ol,dl,li{
            font-family:geneva,helvetica,arial,lucida sans,sans-serif}
	  body,th,td,p,span,a,div,li,ul,ol{
            font-size:12pt}
	  pre{
            font-family: monospace;
	    font-size: 10pt}

	  .sunred{background:#d12124;color:#fff}
	  .sunblue{background:#594fbf;color:#fff}
	  .sunyellow{background:#fbe249;color:#594fbf}

	  body {background:#fff}
	  td {
            background:#f1f1f1;
	    color:#000;
	    vertical-align:top}
	  th {
            background:#000;
            color:#fff;
            font-size:16pt;
	    font-weight:bold;
	    text-align:left;
	    vertical-align:top}
	  td.critical{
            background:#ff0000;
	    color:#000}
	  td.toccritical{
            text-align: center;
            background:#ff0000;
	    color:#000}
	  td.high{
	    background:#ff9999;
            color:#000}
	  td.tochigh{
            text-align: center;
	    background:#ff9999;
            color:#000}
	  td.moderate{
	    background:#ffff33;
	    color:#000}
	  td.tocmoderate{
            text-align: center;
	    background:#ffff33;
	    color:#000}
	  td.low{
	    background:#ffffcc;
	    color:#000}
	  td.toclow{
            text-align: center;
	    background:#ffffcc;
	    color:#000}
	  td.passed, td.notapplicable, td.erroneous {
            background:#66ff00;
            color:#000}
	  td.tocpassed, td.tocnotapplicable, td.tocerroneous {
            text-align: center;
            background:#66ff00;
            color:#000}
	  td.white {
            background:#fff;
	    color:#000}
	  td.checkid {
	    background:#594fbf;
	    color:#fff}
	  td.toccheckid {
	    background:#594fbf;
            text-align: right;
	    color:#fff}

	  .largeblue{
	    font-size:20pt;
	    color:#594fbf;
	    font-weight:bold}
	  .bold{
	    font-weight:bold}

          a:link {
	    color: black;
	    text-decoration: none;
	  }

	  a:active {
	    color: red;
	    font-weight: bold
	  }

	  a:visited {
	    color: red;
	    text-decoration: none
	  }
	  --&gt;
	</style>

    </HEAD>
  </xsl:template>
  <!-- END OF <xsl:include href="SunRBYHtmlHeading.xsl"/>  -->
  

    <xsl:template match="kaeresult">
	<HTML>

	    <xsl:call-template name="heading"/>

	    <BODY>
	    <TABLE BORDER="0" CELLPADDING="5" CELLSPACING="5" WIDTH="800">
		<TR>
		  <TD CLASS="sunblue" VALIGN="top">
              <IMG SRC="http://www.sun.com/im/logo_sun_home.gif" WIDTH="84" 
                   HEIGHT="38" BORDER="0" ALT="Sun Microsystems" /></TD>

		  <TD CLASS="sunyellow" VALIGN="top" NOWRAP="nowrap">
		    <SPAN CLASS="largeblue">System Check Results Using... <BR/>
                                    Sun(TM) Embedded Knowledge Engine</SPAN><BR/>

		    <TABLE BORDER="0">
			  <TR><TD CLASS="sunyellow">Report #:</TD>
			  <TD CLASS="sunyellow"><xsl:value-of select="general_info/report_id/id"/></TD></TR>
		      <TR><TD CLASS="sunyellow">Date:</TD>
		      <TD CLASS="sunyellow"><xsl:value-of select="general_info/report_date/date/@GMT"/></TD></TR>
	        </TABLE>
	      </TD>

	      <TD CLASS="sunred" WIDTH="30%"><BR /></TD>
	    </TR>
	    </TABLE>

	    <xsl:apply-templates select="*"/>

		<HR/>
		  <P>Sun Confidential/Proprietary Information
		<BR/>
		  This report contains Sun(TM) confidential information in which 
          Sun claims trade secrets and other proprietary rights. The content
          is based upon Sun's proprietary technology and is being provided 
          to you pursuant the terms of your SunSpectrum contract. 
          By accepting a copy of this report, you agree to use it for
		  internal purposes only.
		  <BR/>
		    Copyright 2002 Sun Microsystems, Inc.
		  </P>
	    </BODY>
	</HTML>
    </xsl:template>

    <!-- ============================================ -->

    <xsl:template match="generatedBy|field_eng_info|general_info|CRC">
	  <!-- No Info will be shown! -->
    </xsl:template>

    <!-- ============================================ -->

    <xsl:template match="customer_info">
	<P>
	  <TABLE BORDER="0" CELLSPACING="2" CELLPADDING="2" WIDTH="800">
	    <TR><th>Customer</th></TR>
	    <TR><td>
		<span class="bold"><xsl:value-of select="company_name"/></span><BR/>
		  <xsl:apply-templates select="address/*"/>
	      </td></TR>
	  </TABLE>
	</P>
    </xsl:template>

    <xsl:template match="address/*">
	<xsl:value-of select="."/><BR/>
	</xsl:template>

	<!-- ============================================ -->

	<xsl:template match="runresult">
	  <xsl:apply-templates select="run_info"/>
	  </xsl:template>

	  <xsl:template match="run_info">
	    <P>
	      <TABLE BORDER="0" CELLSPACING="2" CELLPADDING="2" WIDTH="800">
		<TR><th COLSPAN="2">System Info</th></TR>
		<TR><td WIDTH="25%">Explorer File:</td><td><xsl:value-of select="input_data/explorerFile"/></td></TR>
		<xsl:apply-templates select="run_system_info/host_info/*"/>
	      </TABLE>
	    </P>

	    <P>
	      <TABLE BORDER="0" CELLSPACING="2" CELLPADDING="2" WIDTH="800">
		<TR><TH COLSPAN="2">Analysis Summary</TH></TR>
		<xsl:apply-templates select="run_summary/*"/>
	      </TABLE>
	    </P>
            <!-- Table of Contents -->
            <A NAME="toc"/>
            <TABLE BORDER="0" CELLSPACING="2" CELLPADDING="2" WIDTH="800">
                <TR>
                  <TH>Check</TH>
                  <TH>Severity</TH>
                  <TH>Description</TH>
                </TR>
                <xsl:apply-templates select="checkresult[@severity='CRITICAL']" mode="toc">
		  <xsl:sort select="check_id/id" data-type="number"/>
		</xsl:apply-templates>
                <xsl:apply-templates select="checkresult[@severity='HIGH']" mode="toc">
		  <xsl:sort select="check_id/id" data-type="number"/>
		</xsl:apply-templates>
                <xsl:apply-templates select="checkresult[@severity='MODERATE']" mode="toc">
		  <xsl:sort select="check_id/id" data-type="number"/>
		</xsl:apply-templates>
                <xsl:apply-templates select="checkresult[@severity='LOW']" mode="toc">
		  <xsl:sort select="check_id/id" data-type="number"/>
		</xsl:apply-templates>
            </TABLE>
	    <P>
	      <TABLE BORDER="0" CELLSPACING="2" CELLPADDING="2" WIDTH="800">
		<TR><TH COLSPAN="2">Analysis Details</TH></TR>
                <xsl:apply-templates select="checkresult[@severity='CRITICAL']" mode="main">
		  <xsl:sort select="check_id/id" data-type="number"/>
		</xsl:apply-templates>
                <xsl:apply-templates select="checkresult[@severity='HIGH']" mode="main">
		  <xsl:sort select="check_id/id" data-type="number"/>
		</xsl:apply-templates>
                <xsl:apply-templates select="checkresult[@severity='MODERATE']" mode="main">
		  <xsl:sort select="check_id/id" data-type="number"/>
		</xsl:apply-templates>
                <xsl:apply-templates select="checkresult[@severity='LOW']" mode="main">
		  <xsl:sort select="check_id/id" data-type="number"/>
		</xsl:apply-templates>
	      </TABLE>
	    </P>
	  </xsl:template>

	  <xsl:template match="host_info/*">
	    <TR><TD WIDTH="25%"><xsl:value-of select="translate(name(),'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')"/></TD>
	      <TD><xsl:value-of select="."/></TD>
	    </TR>
	  </xsl:template>

	  <xsl:template match="run_summary/*">
	    <TR>
	      <xsl:text disable-output-escaping="yes">&lt;TD width="25%" class=</xsl:text>
	      <xsl:value-of select="name()"/>
		<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
		<xsl:value-of select="translate(name(),'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')"/>
		  <xsl:text disable-output-escaping="yes">&lt;/TD&gt;</xsl:text>
		  <TD>
		    <xsl:value-of select="."/>
		  </TD>
	    </TR>
	  </xsl:template>


	  <!-- ............................................ -->

	  <xsl:template match="checkresult" mode="main">
       <xsl:if test="@status = 'FAILED'">
	    <xsl:for-each select=".">
	      <TR>
                <TD class="checkid">
                  <xsl:element name="A">
                    <xsl:attribute name="NAME">check<xsl:value-of select="check_id/id"/></xsl:attribute>
                    <xsl:attribute name="HREF">#toc</xsl:attribute>
                  Check ID
                  </xsl:element>
                </TD>
                <TD class="checkid"><xsl:value-of select="check_id/id"/></TD></TR>
	      <TR>
                <TD>Severity</TD>
		<xsl:text disable-output-escaping="yes">&lt;TD class=</xsl:text>
		<xsl:value-of select="@severity"/>
		  <xsl:text disable-output-escaping="yes">&gt;</xsl:text>
		  <xsl:value-of select="@severity"/>
		    <xsl:text disable-output-escaping="yes">&lt;/TD&gt;</xsl:text>
	      </TR>
	      <TR>
                <TD>Description</TD>
                <TD><xsl:value-of select="description"/></TD>
              </TR>
	      <TR>
                <TD>Analysis ..</TD>
                <TD><xsl:apply-templates select="analysis"/></TD>
              </TR>
	      <TR>
                <TD>Recommendations .</TD>
                <TD><xsl:apply-templates select="recommendations"/></TD>
              </TR>
	    </xsl:for-each>
      </xsl:if>
    </xsl:template>
    
    <xsl:template match="analysis">
        <xsl:value-of disable-output-escaping="yes" select="text()"/>
    </xsl:template>

    <xsl:template match="recommendations">        
        <xsl:value-of disable-output-escaping="yes" select="text()"/>
    </xsl:template>

            
    <!-- Generate just an abbrevated summary and have it link to the longer
               discription with analysis and recommendations.
    -->
    <xsl:template match="checkresult" mode="toc">
       <xsl:if test="@status = 'FAILED'">
	    <xsl:for-each select=".">
	      <TR>
                <TD class="toccheckid">
                  <xsl:element name="A">
                    <xsl:attribute name="HREF">#check<xsl:value-of select="check_id/id"/></xsl:attribute>
                        <xsl:value-of select="check_id/id"/>
                  </xsl:element>
                </TD>
		<xsl:text disable-output-escaping="yes">&lt;TD class=</xsl:text>
		toc<xsl:value-of select="@severity"/>
		  <xsl:text disable-output-escaping="yes">&gt;</xsl:text>
		  <xsl:value-of select="@severity"/>
		    <xsl:text disable-output-escaping="yes">&lt;/TD&gt;</xsl:text>
                <TD><xsl:value-of select="description"/></TD>
              </TR>
	   </xsl:for-each>
      </xsl:if>
    </xsl:template>
    <!-- ============================================ -->
</xsl:stylesheet>
