/*
 * Decompiled with CFR 0.152.
 */
package com.sun.eras.kae.kpl.model;

import com.sun.eras.kae.kpl.model.ConversionException;
import com.sun.eras.kae.kpl.model.KPLBoolean;
import com.sun.eras.kae.kpl.model.KPLDate;
import com.sun.eras.kae.kpl.model.KPLDateTime;
import com.sun.eras.kae.kpl.model.KPLInteger;
import com.sun.eras.kae.kpl.model.KPLList;
import com.sun.eras.kae.kpl.model.KPLObject;
import com.sun.eras.kae.kpl.model.KPLString;
import com.sun.eras.kae.kpl.model.KPLTime;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Vector;

public class KPLReal
extends KPLObject
implements Serializable {
    private static final long serialVersionUID = 3708330421526722298L;
    protected double m_value;

    public KPLReal(kpl.KPLReal kPLReal) {
        this.m_type = kPLReal.getType();
        this.m_value = kPLReal.getValue();
    }

    public KPLReal() {
        super(6);
        this.m_value = 0.0;
    }

    public KPLReal(double d) {
        super(6);
        this.m_value = d;
    }

    public KPLReal(String string) throws ConversionException {
        super(6);
        try {
            this.m_value = Double.parseDouble(string);
        }
        catch (Exception exception) {
            throw new ConversionException(new KPLString(), 6);
        }
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new kpl.KPLReal(this);
    }

    public KPLBoolean convertToBoolean() {
        return new KPLBoolean(this.m_value != 0.0);
    }

    public KPLDate convertToDate() {
        return new KPLDate((long)this.m_value);
    }

    public KPLDateTime convertToDateTime() {
        return new KPLDateTime((long)this.m_value);
    }

    public KPLInteger convertToInteger() {
        return new KPLInteger((long)this.m_value);
    }

    public KPLList convertToList() {
        Vector<KPLReal> vector = new Vector<KPLReal>();
        vector.add(new KPLReal(this.m_value));
        return new KPLList(vector);
    }

    public KPLReal convertToReal() {
        return new KPLReal(this.m_value);
    }

    public KPLString convertToString() {
        return new KPLString(Double.toString(this.m_value));
    }

    public KPLTime convertToTime() {
        return new KPLTime((long)this.m_value);
    }

    public String toString() {
        return Double.toString(this.m_value);
    }

    public double value() {
        return this.m_value;
    }

    public static KPLReal arithmetic(KPLReal kPLReal, String string, KPLReal kPLReal2) {
        double d = kPLReal.value();
        double d2 = kPLReal2.value();
        if (string.equals("+")) {
            return new KPLReal(d + d2);
        }
        if (string.equals("-")) {
            return new KPLReal(d - d2);
        }
        if (string.equals("*")) {
            return new KPLReal(d * d2);
        }
        if (string.equals("/")) {
            return new KPLReal(d / d2);
        }
        if (string.equals("%")) {
            return new KPLReal(d % d2);
        }
        return new KPLReal(0.0);
    }

    public static boolean compare(KPLReal kPLReal, String string, KPLReal kPLReal2) {
        double d = kPLReal.value();
        double d2 = kPLReal2.value();
        if (string.equals("==") || string.equals("=")) {
            return d == d2;
        }
        if (string.equals("!=") || string.equals("<>")) {
            return d != d2;
        }
        if (string.equals("<")) {
            return d < d2;
        }
        if (string.equals("<=")) {
            return d <= d2;
        }
        if (string.equals(">")) {
            return d > d2;
        }
        if (string.equals(">=")) {
            return d >= d2;
        }
        return false;
    }
}

