/*
 * Decompiled with CFR 0.152.
 */
package com.sun.eras.kae.kpl.model;

import com.sun.eras.kae.kpl.model.ConversionException;
import com.sun.eras.kae.kpl.model.KPLBoolean;
import com.sun.eras.kae.kpl.model.KPLDate;
import com.sun.eras.kae.kpl.model.KPLDateTime;
import com.sun.eras.kae.kpl.model.KPLInteger;
import com.sun.eras.kae.kpl.model.KPLObject;
import com.sun.eras.kae.kpl.model.KPLReal;
import com.sun.eras.kae.kpl.model.KPLString;
import com.sun.eras.kae.kpl.model.KPLTime;
import com.sun.eras.kae.kpl.model.lists.ASTListParse;
import com.sun.eras.kae.kpl.model.lists.ASTListParseBooleanNode;
import com.sun.eras.kae.kpl.model.lists.ASTListParseIntegerNode;
import com.sun.eras.kae.kpl.model.lists.ASTListParseListNode;
import com.sun.eras.kae.kpl.model.lists.ASTListParseRealNode;
import com.sun.eras.kae.kpl.model.lists.ASTListParseStringNode;
import com.sun.eras.kae.kpl.model.lists.ListParse;
import com.sun.eras.kae.kpl.model.lists.SimpleNode;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class KPLList
extends KPLObject
implements Serializable {
    private static final long serialVersionUID = -7158875544195445074L;
    protected Vector m_value;

    public KPLList(kpl.KPLList kPLList) {
        this.m_type = kPLList.getType();
        this.m_value = kPLList.getValue();
    }

    public KPLList() {
        super(5);
        this.m_value = new Vector();
    }

    public KPLList(List list) throws IllegalArgumentException {
        super(5);
        if (list == null) {
            this.m_value = new Vector();
        } else {
            Vector<KPLObject> vector = new Vector<KPLObject>(list.size());
            boolean bl = false;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                KPLObject kPLObject;
                Object e = iterator.next();
                if (e != (kPLObject = KPLObject.makeInstance(e))) {
                    bl = true;
                }
                vector.add(kPLObject);
            }
            this.m_value = !bl && list instanceof Vector ? (Vector)list : vector;
        }
    }

    public KPLList(String string) {
        super(5);
        if (string == null || string.equals("")) {
            this.m_value = new Vector();
            return;
        }
        ListParse listParse = new ListParse(new StringReader(string));
        ASTListParse aSTListParse = null;
        try {
            aSTListParse = listParse.ListParse();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (aSTListParse == null) {
            this.m_value = new Vector();
            return;
        }
        try {
            this.m_value = this.createList((ASTListParseListNode)aSTListParse.jjtGetChild(0));
        }
        catch (Exception exception) {
            this.m_value = new Vector();
        }
    }

    private Vector createList(ASTListParseListNode aSTListParseListNode) throws ConversionException {
        Vector<KPLBoolean> vector = new Vector<KPLBoolean>();
        int n = 0;
        while (n < aSTListParseListNode.jjtGetNumChildren()) {
            SimpleNode simpleNode = (SimpleNode)aSTListParseListNode.jjtGetChild(n);
            if (simpleNode != null) {
                SimpleNode simpleNode2;
                KPLObject kPLObject = null;
                if (simpleNode instanceof ASTListParseBooleanNode) {
                    simpleNode2 = (ASTListParseBooleanNode)simpleNode;
                    kPLObject = new KPLString(((ASTListParseBooleanNode)simpleNode2).value()).convertToBoolean();
                } else if (simpleNode instanceof ASTListParseIntegerNode) {
                    simpleNode2 = (ASTListParseIntegerNode)simpleNode;
                    kPLObject = new KPLString(((ASTListParseIntegerNode)simpleNode2).value()).convertToInteger();
                } else if (simpleNode instanceof ASTListParseListNode) {
                    simpleNode2 = (ASTListParseListNode)simpleNode;
                    kPLObject = new KPLList(this.createList((ASTListParseListNode)simpleNode2));
                } else if (simpleNode instanceof ASTListParseRealNode) {
                    simpleNode2 = (ASTListParseRealNode)simpleNode;
                    kPLObject = new KPLString(((ASTListParseRealNode)simpleNode2).value()).convertToReal();
                } else if (simpleNode instanceof ASTListParseStringNode) {
                    simpleNode2 = (ASTListParseStringNode)simpleNode;
                    kPLObject = new KPLString(((ASTListParseStringNode)simpleNode2).value());
                }
                if (kPLObject != null) {
                    vector.add((KPLBoolean)kPLObject);
                }
            }
            ++n;
        }
        return vector;
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new kpl.KPLList(this);
    }

    public KPLBoolean convertToBoolean() throws ConversionException {
        if (this.m_value.size() == 1) {
            return ((KPLObject)this.m_value.elementAt(0)).convertToBoolean();
        }
        throw new ConversionException(this, 1);
    }

    public KPLDate convertToDate() throws ConversionException {
        if (this.m_value.size() == 1) {
            return ((KPLObject)this.m_value.elementAt(0)).convertToDate();
        }
        throw new ConversionException(this, 2);
    }

    public KPLDateTime convertToDateTime() throws ConversionException {
        if (this.m_value.size() == 1) {
            return ((KPLObject)this.m_value.elementAt(0)).convertToDateTime();
        }
        throw new ConversionException(this, 3);
    }

    public KPLInteger convertToInteger() throws ConversionException {
        if (this.m_value.size() == 1) {
            return ((KPLObject)this.m_value.elementAt(0)).convertToInteger();
        }
        throw new ConversionException(this, 4);
    }

    public KPLList convertToList() {
        return new KPLList(this.m_value);
    }

    public KPLReal convertToReal() throws ConversionException {
        if (this.m_value.size() == 1) {
            return ((KPLObject)this.m_value.elementAt(0)).convertToReal();
        }
        throw new ConversionException(this, 6);
    }

    public KPLString convertToString() {
        return new KPLString(this.toString());
    }

    public KPLTime convertToTime() throws ConversionException {
        if (this.m_value.size() == 1) {
            return ((KPLObject)this.m_value.elementAt(0)).convertToTime();
        }
        throw new ConversionException(this, 8);
    }

    public KPLObject elementAt(int n) {
        if (n <= 0) {
            n = 0;
        }
        if (n >= this.m_value.size()) {
            n = this.m_value.size();
        }
        return (KPLObject)this.m_value.elementAt(n);
    }

    public int size() {
        if (this.m_value == null) {
            return 0;
        }
        return this.m_value.size();
    }

    public String toString() {
        if (this.m_value == null) {
            return "[ ]";
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        if (this.m_value.size() > 1) {
            stringBuffer.append("[");
        }
        int n = 0;
        while (n < this.m_value.size()) {
            KPLObject kPLObject = (KPLObject)this.m_value.elementAt(n);
            if (this.m_value.size() > 1) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(kPLObject.toString());
            ++n;
        }
        if (this.m_value.size() > 1) {
            stringBuffer.append(" ]");
        }
        return stringBuffer.toString();
    }

    public Vector value() {
        return this.m_value;
    }

    public static boolean compare(KPLList kPLList, String string, KPLList kPLList2) {
        return false;
    }
}

