/*
 * Decompiled with CFR 0.152.
 */
package com.sun.eras.kae.kpl.model;

import com.sun.eras.kae.kpl.model.ConversionException;
import com.sun.eras.kae.kpl.model.KPLBoolean;
import com.sun.eras.kae.kpl.model.KPLDate;
import com.sun.eras.kae.kpl.model.KPLInteger;
import com.sun.eras.kae.kpl.model.KPLList;
import com.sun.eras.kae.kpl.model.KPLObject;
import com.sun.eras.kae.kpl.model.KPLReal;
import com.sun.eras.kae.kpl.model.KPLString;
import com.sun.eras.kae.kpl.model.KPLTime;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;

public class KPLDateTime
extends KPLObject
implements Serializable {
    private static final long serialVersionUID = 2902287726808117426L;
    protected Date m_value;

    public KPLDateTime(kpl.KPLDateTime kPLDateTime) {
        this.m_type = kPLDateTime.getType();
        this.m_value = kPLDateTime.getValue();
    }

    public KPLDateTime() {
        super(3);
        this.m_value = new Date(0L);
    }

    public KPLDateTime(Date date) {
        super(3);
        this.m_value = date;
    }

    public KPLDateTime(long l) {
        super(3);
        this.m_value = new Date(l);
    }

    public KPLDateTime(String string) throws ConversionException {
        super(3);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM dd hh:mm:ss");
        ParsePosition parsePosition = new ParsePosition(0);
        Date date = simpleDateFormat.parse(string, parsePosition);
        if (date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.set(1, KPLObject.defaultYear);
            this.m_value = calendar.getTime();
            return;
        }
        throw new ConversionException(new KPLString(), 3);
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new kpl.KPLDateTime(this);
    }

    public KPLBoolean convertToBoolean() throws ConversionException {
        throw new ConversionException(this, 1);
    }

    public KPLDate convertToDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.m_value);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return new KPLDate(calendar.getTime());
    }

    public KPLDateTime convertToDateTime() {
        return new KPLDateTime(this.m_value);
    }

    public KPLInteger convertToInteger() {
        return new KPLInteger(this.m_value.getTime());
    }

    public KPLList convertToList() {
        Vector<KPLDateTime> vector = new Vector<KPLDateTime>();
        vector.add(new KPLDateTime(this.m_value));
        return new KPLList(vector);
    }

    public KPLReal convertToReal() {
        return new KPLReal(this.m_value.getTime());
    }

    public KPLString convertToString() {
        return new KPLString(this.toString());
    }

    public KPLTime convertToTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.m_value);
        calendar.set(1, 1970);
        calendar.set(2, 0);
        calendar.set(5, 1);
        calendar.set(5, 1);
        return new KPLTime(calendar.getTime());
    }

    public String toString() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.m_value);
        SimpleDateFormat simpleDateFormat = calendar.get(14) != 0 ? new SimpleDateFormat("EEE MMM dd HH:mm:ss.SSS zzz yyyy") : new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
        return simpleDateFormat.format(this.m_value);
    }

    public Date value() {
        return this.m_value;
    }

    public static KPLDateTime arithmetic(KPLDateTime kPLDateTime, String string, KPLDateTime kPLDateTime2) {
        try {
            return new KPLDateTime(KPLInteger.arithmetic(kPLDateTime.convertToInteger(), string, kPLDateTime2.convertToInteger()).value());
        }
        catch (Exception exception) {
            return new KPLDateTime(0L);
        }
    }

    public static boolean compare(KPLDateTime kPLDateTime, String string, KPLDateTime kPLDateTime2) {
        try {
            return KPLInteger.compare(kPLDateTime.convertToInteger(), string, kPLDateTime2.convertToInteger());
        }
        catch (Exception exception) {
            return false;
        }
    }
}

