/*
 * Decompiled with CFR 0.152.
 */
package com.sun.eras.kae.io;

import com.sun.eras.common.logging4.Logger;
import com.sun.eras.common.util.MessageKey;
import com.sun.eras.kae.io.KPLLibrary;
import com.sun.eras.kae.io.LibraryException;
import com.sun.eras.kae.io.LibraryFunction;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class KPLJARLibrary
implements KPLLibrary {
    private JarInputStream for;
    private Manifest a;
    private String if;
    private int try;
    private Hashtable byte;
    private static Logger case = Logger.getLogger((String)"com.sun.eras.eke.io");
    private static final String do = "library_name";
    private static final String new = "library_version";
    private static final String int = "_toc.txt";

    public KPLJARLibrary(String string, int n) throws LibraryException {
        String string2 = KPLJARLibrary.a(string, n);
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(string2);
        if (inputStream == null) {
            throw new LibraryException(new MessageKey("NoLibrary"), "Cant find/open library: " + string2, string2);
        }
        try {
            this.for = new JarInputStream(inputStream);
        }
        catch (IOException iOException) {
            throw new LibraryException(new MessageKey("NoLibrary"), "Cant find/open library: " + string2, string2, iOException);
        }
        Properties properties = null;
        try {
            properties = KPLJARLibrary.a(this.for);
        }
        catch (IOException iOException) {
            throw new LibraryException(new MessageKey("TOCProblem"), "Cant read TOC in library: " + string2, string2, iOException);
        }
        String string3 = properties.getProperty(do);
        String string4 = properties.getProperty(new);
        if (!string.equals(string3)) {
            throw new LibraryException(new MessageKey("LibraryNameMismatch"), "Name in library does not match library name: " + string2, string2);
        }
        this.byte = new Hashtable();
        ZipEntry zipEntry = null;
        try {
            while ((zipEntry = this.for.getNextEntry()) != null) {
                ObjectInputStream objectInputStream = new ObjectInputStream(this.for);
                LibraryFunction libraryFunction = (LibraryFunction)objectInputStream.readObject();
                this.byte.put(libraryFunction.getFunctionName(), libraryFunction);
                case.finest("read define from library: " + libraryFunction.getFunctionName());
            }
        }
        catch (Exception exception) {
            throw new LibraryException(new MessageKey("LibraryDefinitionError"), "Could not read definition from library: " + string, string, exception);
        }
    }

    public KPLJARLibrary(String string) throws LibraryException {
        this(string, -1);
    }

    public LibraryFunction getDefinition(String string) {
        return (LibraryFunction)this.byte.get(string);
    }

    public String[] getDefinitionsNames() {
        ArrayList arrayList = new ArrayList(this.byte.keySet());
        return arrayList.toArray(new String[0]);
    }

    public String getLibraryName() {
        return this.if;
    }

    public int getLibraryVersion() {
        return this.try;
    }

    public LibraryFunction[] getDefinitions() {
        ArrayList arrayList = new ArrayList(this.byte.values());
        return arrayList.toArray(new LibraryFunction[0]);
    }

    public static void createKPLLibraryJAR(KPLLibrary kPLLibrary, File file) throws IOException {
        String string = kPLLibrary.getLibraryName();
        int n = kPLLibrary.getLibraryVersion();
        String string2 = KPLJARLibrary.a(string, -1);
        File file2 = new File(file, string2);
        case.finer("new library file will be: " + file2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Properties properties = new Properties();
        properties.setProperty(do, string);
        properties.setProperty(new, n + "");
        properties.store(byteArrayOutputStream, "KPL Library TOC Properties");
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        JarOutputStream jarOutputStream = new JarOutputStream(fileOutputStream);
        ZipEntry zipEntry = new ZipEntry(int);
        jarOutputStream.putNextEntry(zipEntry);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        case.finer("toc write size: " + byArray.length);
        jarOutputStream.write(byArray);
        LibraryFunction[] libraryFunctionArray = kPLLibrary.getDefinitions();
        int n2 = 0;
        while (n2 < libraryFunctionArray.length) {
            zipEntry = new ZipEntry(libraryFunctionArray[n2].getFunctionName());
            byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(libraryFunctionArray[n2]);
            objectOutputStream.close();
            jarOutputStream.putNextEntry(zipEntry);
            jarOutputStream.write(byteArrayOutputStream.toByteArray());
            ++n2;
        }
        jarOutputStream.close();
        fileOutputStream.close();
    }

    private static Properties a(JarInputStream jarInputStream) throws LibraryException, IOException {
        ZipEntry zipEntry = jarInputStream.getNextEntry();
        case.finer("got entry: " + zipEntry.getName());
        if (!zipEntry.getName().equals(int)) {
            throw new LibraryException(new MessageKey("TOCProblem"), "Cant read TOC in library");
        }
        Properties properties = new Properties();
        properties.load(jarInputStream);
        return properties;
    }

    private static String a(String string, int n) {
        if (n == -1) {
            return "lib" + string + ".jar";
        }
        return "lib" + string + "_" + n + ".jar";
    }
}

