/*
 * Decompiled with CFR 0.152.
 */
package com.sun.eras.kae.facts.pcmrun;

import com.sun.eras.common.util.MessageKey;
import com.sun.eras.kae.facts.Fact;
import com.sun.eras.kae.facts.Slot;
import com.sun.eras.kae.facts.pcmrun.FactStoreInconsistentException;
import com.sun.eras.kae.facts.pcmrun.PCMRunAssociation;
import com.sun.eras.kae.facts.pcmrun.PCMUnknownException;
import com.sun.eras.kae.facts.store.IFactStorage;
import com.sun.eras.kae.kpl.model.KPLBoolean;
import com.sun.eras.kae.kpl.model.KPLInteger;
import com.sun.eras.kae.kpl.model.KPLObject;
import com.sun.eras.kae.kpl.model.KPLString;
import java.util.Vector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PCMRunPatchEntry {
    private Vector if = null;
    private String for;
    private int a;
    private int do = 0;
    private String byte;
    private String int;
    private String new;
    private int case;
    private boolean try;

    public PCMRunPatchEntry(String string, IFactStorage iFactStorage) throws PCMUnknownException {
        this.int = string;
        try {
            Fact fact = iFactStorage.get("MasterPatch", string);
            if (fact == null) {
                throw new FactStoreInconsistentException(FactStoreInconsistentException.MISSING_PATCH_MASTERPATCH, "Fact store is inconsistent: master patch entry is missing for patch number " + string, new Object[]{string}, null, null);
            }
            String string2 = null;
            Slot slot = fact.getSlot("synopsis");
            if (slot == null) {
                throw new PCMUnknownException(new MessageKey("masterPatchNotInFS"), string);
            }
            KPLObject kPLObject = (KPLString)slot.value();
            string2 = ((KPLString)kPLObject).value();
            slot = fact.getSlot("patchRevision");
            if (slot != null) {
                kPLObject = (KPLInteger)slot.value();
                this.a = (int)((KPLInteger)kPLObject).value();
            }
            if ((slot = fact.getSlot("releasedDate")) != null) {
                kPLObject = (KPLString)slot.value();
                this.new = ((KPLString)kPLObject).value();
            }
            if ((slot = (fact = iFactStorage.get("PatchInfo", string)).getSlot("description")) != null) {
                kPLObject = (KPLString)slot.value();
                this.for = ((KPLString)kPLObject).value();
            }
            if ((slot = fact.getSlot("isUserDescription")) != null) {
                kPLObject = (KPLBoolean)slot.value();
                this.try = ((KPLBoolean)kPLObject).value();
                if (!this.try) {
                    this.for = string2;
                }
            }
            if ((slot = fact.getSlot("notes")) != null) {
                kPLObject = (KPLString)slot.value();
                this.byte = ((KPLString)kPLObject).value();
            }
            if ((slot = fact.getSlot("severity")) != null) {
                kPLObject = (KPLInteger)slot.value();
                this.case = (int)((KPLInteger)kPLObject).value();
            }
        }
        catch (PCMUnknownException pCMUnknownException) {
            throw pCMUnknownException;
        }
        catch (Exception exception) {
            throw new PCMUnknownException(new MessageKey("notInFS"), string);
        }
    }

    public Vector getAssociations() {
        return this.if;
    }

    public String getDescription() {
        return this.for == null ? "" : this.for;
    }

    public int getLatestRev() {
        return this.a;
    }

    public int getMinRev() {
        return this.do;
    }

    public String getNotes() {
        return this.byte == null ? "" : this.byte;
    }

    public String getPatchLatest() {
        return this.getPatchNum() + "-" + KPLInteger.padInteger(this.getLatestRev(), 2, '0');
    }

    public String getPatchMin() {
        return this.getPatchNum() + "-" + KPLInteger.padInteger(this.getMinRev(), 2, '0');
    }

    public String getPatchNum() {
        return this.int;
    }

    public String getReleaseDate() {
        return this.new == null ? "" : this.new;
    }

    public int getSeverity() {
        return this.case;
    }

    public boolean isDescUser() {
        return this.try;
    }

    public void setAssociations(Vector vector) {
        this.if = vector;
    }

    public void setMinRev(int n) {
        this.do = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Patch: ");
        stringBuffer.append(this.getPatchLatest());
        stringBuffer.append(" ");
        stringBuffer.append("Rel: ");
        stringBuffer.append(this.getReleaseDate());
        stringBuffer.append(" ");
        stringBuffer.append("Min: ");
        if (this.getMinRev() == 0) {
            stringBuffer.append("   N/A   ");
        } else {
            stringBuffer.append(this.getPatchMin());
        }
        stringBuffer.append(" ");
        stringBuffer.append("Sev: ");
        try {
            stringBuffer.append(this.getSeverity());
        }
        catch (Exception exception) {
            stringBuffer.append("UNKNOWN");
        }
        stringBuffer.append(" ");
        try {
            if (this.isDescUser()) {
                stringBuffer.append("User");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        stringBuffer.append("Desc: ");
        try {
            stringBuffer.append(this.getDescription());
        }
        catch (Exception exception) {
            stringBuffer.append("UNKNOWN");
        }
        stringBuffer.append(" ");
        stringBuffer.append("Notes: ");
        try {
            stringBuffer.append(this.getNotes());
        }
        catch (Exception exception) {
            stringBuffer.append("UNKNOWN");
        }
        Vector vector = this.getAssociations();
        if (vector == null || vector.size() <= 0) {
            return stringBuffer.toString();
        }
        int n = 0;
        while (n < vector.size()) {
            PCMRunAssociation pCMRunAssociation = (PCMRunAssociation)vector.elementAt(n);
            stringBuffer.append("\n  ");
            stringBuffer.append(pCMRunAssociation.toString());
            ++n;
        }
        return stringBuffer.toString();
    }
}

