/*
 * Decompiled with CFR 0.152.
 */
package com.sun.eras.kae.facts.pcmrun;

import com.sun.eras.kae.facts.pcmrun.PCMFailure;
import com.sun.eras.kae.facts.pcmrun.PCMFailureBug;
import com.sun.eras.kae.facts.pcmrun.PCMFailureFile;
import com.sun.eras.kae.facts.pcmrun.PCMFailurePackage;
import com.sun.eras.kae.facts.pcmrun.PCMRunAssociation;
import com.sun.eras.kae.facts.pcmrun.PCMRunBugEntry;
import com.sun.eras.kae.facts.pcmrun.PCMRunFileEntry;
import com.sun.eras.kae.facts.pcmrun.PCMRunPackageEntry;
import com.sun.eras.kae.facts.pcmrun.PCMRunPatchEntry;
import com.sun.eras.kae.kpl.model.KPLInteger;
import java.util.Vector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PCMFailurePatch {
    private Vector int;
    private int do;
    private int a;
    private String for;
    private int if;

    public PCMFailurePatch(PCMRunPatchEntry pCMRunPatchEntry) {
        this.do = pCMRunPatchEntry.getLatestRev();
        this.a = pCMRunPatchEntry.getMinRev();
        this.for = pCMRunPatchEntry.getPatchNum();
        this.if = pCMRunPatchEntry.getSeverity();
        this.int = new Vector();
        Vector vector = pCMRunPatchEntry.getAssociations();
        if (vector != null && vector.size() > 0) {
            int n = 0;
            while (n < vector.size()) {
                PCMRunAssociation pCMRunAssociation = (PCMRunAssociation)vector.elementAt(n);
                PCMFailure pCMFailure = null;
                switch (pCMRunAssociation.type()) {
                    case 1: {
                        pCMFailure = new PCMFailureBug((PCMRunBugEntry)pCMRunAssociation);
                        break;
                    }
                    case 2: {
                        pCMFailure = new PCMFailureFile((PCMRunFileEntry)pCMRunAssociation);
                        break;
                    }
                    case 3: {
                        pCMFailure = new PCMFailurePackage((PCMRunPackageEntry)pCMRunAssociation);
                        break;
                    }
                }
                if (pCMFailure != null) {
                    this.int.add(pCMFailure);
                }
                ++n;
            }
        }
    }

    public Vector getAssociations() {
        return this.int;
    }

    public int getLatestRev() {
        return this.do;
    }

    public int getMinRev() {
        return this.a;
    }

    public String getPatchLatest() {
        return this.getPatchNum() + "-" + KPLInteger.padInteger(this.getLatestRev(), 2, '0');
    }

    public String getPatchMin() {
        return this.getPatchNum() + "-" + KPLInteger.padInteger(this.getMinRev(), 2, '0');
    }

    public String getPatchNum() {
        return this.for;
    }

    public int getSeverity() {
        return this.if;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Patch: ");
        stringBuffer.append(this.getPatchLatest());
        stringBuffer.append(" ");
        stringBuffer.append("Min: ");
        if (this.getMinRev() == 0) {
            stringBuffer.append("   N/A   ");
        } else {
            stringBuffer.append(this.getPatchMin());
        }
        stringBuffer.append(" ");
        stringBuffer.append("Sev: ");
        try {
            stringBuffer.append(this.getSeverity());
        }
        catch (Exception exception) {
            stringBuffer.append("UNKNOWN");
        }
        Vector vector = this.getAssociations();
        if (vector == null || vector.size() <= 0) {
            return stringBuffer.toString();
        }
        int n = 0;
        while (n < vector.size()) {
            PCMRunAssociation pCMRunAssociation = (PCMRunAssociation)vector.elementAt(n);
            stringBuffer.append("\n  ");
            stringBuffer.append(pCMRunAssociation.toString());
            ++n;
        }
        return stringBuffer.toString();
    }
}

