/*
 * Decompiled with CFR 0.152.
 */
package com.sun.eras.kae.facts;

import com.sun.eras.kae.kpl.model.KPLObject;
import java.io.ObjectStreamException;
import java.io.Serializable;
import kce.KCESlot;

public class Slot
implements Serializable {
    private static final long serialVersionUID = 8991625974213693830L;
    private String m_name;
    private String m_description;
    private int m_type;
    private KPLObject m_value;
    private boolean m_isDefault;
    private boolean m_readOnly;

    public Slot(KCESlot kCESlot) {
        this.m_name = kCESlot.getName();
        this.m_description = kCESlot.getDescription();
        this.m_type = kCESlot.getType();
        this.m_value = kCESlot.getValue();
        this.m_isDefault = kCESlot.getIsDefault();
        this.m_readOnly = kCESlot.getReadOnly();
    }

    public Slot(String string, int n, boolean bl, KPLObject kPLObject) {
        this.m_name = string;
        this.m_description = null;
        this.m_type = n;
        this.m_readOnly = bl;
        if (kPLObject != null) {
            this.m_value = kPLObject;
            this.m_isDefault = !bl;
        } else {
            this.m_value = null;
        }
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new KCESlot(this);
    }

    public String description() {
        return this.m_description;
    }

    public boolean isDefault() {
        return this.m_isDefault;
    }

    public boolean isReadOnly() {
        return this.m_readOnly;
    }

    public String name() {
        return this.m_name;
    }

    public void set(KPLObject kPLObject) {
        if (this.m_readOnly) {
            return;
        }
        this.m_value = kPLObject;
        this.m_isDefault = false;
    }

    public void setDescription(String string) {
        this.m_description = string;
    }

    public void setOverride(KPLObject kPLObject) {
        this.m_value = kPLObject;
        this.m_isDefault = false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("slot ");
        stringBuffer.append(this.m_name);
        stringBuffer.append(", ");
        String string = KPLObject.typeToString(this.m_type);
        if (string != null) {
            stringBuffer.append("type ");
            stringBuffer.append(string);
            stringBuffer.append(", ");
        }
        if (this.m_value == null) {
            stringBuffer.append("no value");
        } else {
            stringBuffer.append(this.m_value.toString());
        }
        if (this.m_readOnly) {
            stringBuffer.append(" [read-only]");
        }
        if (this.m_isDefault) {
            stringBuffer.append(" (default)");
        }
        if (this.m_description != null && !this.m_description.equals("")) {
            stringBuffer.append("\n");
            stringBuffer.append(this.m_description);
        }
        return stringBuffer.toString();
    }

    public int type() {
        return this.m_type;
    }

    public KPLObject value() {
        return this.m_value;
    }
}

