/*
 * Decompiled with CFR 0.152.
 */
package com.sun.eras.common.validator;

import com.sun.eras.common.util.Config;
import com.sun.eras.common.util.ConfigPropertyNotFoundException;
import com.sun.eras.common.validator.ValidatorFactoryInitializationException;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

class ValidatorConfig
extends Config {
    public static final String BASE_CONFIG_FILE_NAME = "validator";
    public static final String PROPERTY_PREFIX = "validator.";
    public static final String CML_OUTPUT_FORMAT = "CML";
    public static final String VALIDATOR_CLASS_PROPERTY_PREFIX = "validator.validatorClass.";
    public static final String DTD_PROPERTY_PREFIX = "validator.dtd.";
    private static String[][] defaultsArray = new String[][]{{"validator.validatorClass.CML", "com.sun.eras.common.validator.CmlSaxValidator"}, {"validator.dtd.CML", "/com/sun/eras/common/validator/textbody.dtd"}};
    private static ResourceBundle defaultsBundle = Config.makeDefaultsBundle(defaultsArray);
    private static ValidatorConfig instance = null;
    private Map cache = new HashMap();

    private ValidatorConfig() {
        super(BASE_CONFIG_FILE_NAME, defaultsBundle);
    }

    public static synchronized ValidatorConfig getInstance() {
        if (instance == null) {
            instance = new ValidatorConfig();
        }
        return instance;
    }

    protected Object handleGetObject(String string) {
        if (this.cache.containsKey(string)) {
            return (String)this.cache.get(string);
        }
        Map map = this.cache;
        synchronized (map) {
            if (this.cache.containsKey(string)) {
                String string2 = (String)this.cache.get(string);
                return string2;
            }
            Object object = null;
            try {
                object = super.handleGetObject(string);
            }
            catch (ConfigPropertyNotFoundException configPropertyNotFoundException) {
                // empty catch block
            }
            this.cache.put(string, object);
            Object object2 = object;
            return object2;
        }
    }

    public String getValidatorClassName(String string) throws ValidatorFactoryInitializationException {
        return this.getString(VALIDATOR_CLASS_PROPERTY_PREFIX + string, null);
    }

    public String getDtdFileName(String string) throws ValidatorFactoryInitializationException {
        return this.getString(DTD_PROPERTY_PREFIX + string, null);
    }
}

