/*
 * Decompiled with CFR 0.152.
 */
package com.sun.eras.common.validator;

import com.sun.eras.common.util.EntityResolverHelper;
import com.sun.eras.common.util.MessageKey;
import com.sun.eras.common.validator.ValidationException;
import com.sun.eras.common.validator.ValidationFailureException;
import com.sun.eras.common.validator.Validator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class CmlSaxValidator
extends Validator {
    public CmlSaxValidator() {
        super("CML");
    }

    public void validate(String string) throws ValidationFailureException, ValidationException {
        if (string == null) {
            throw new ValidationFailureException(new MessageKey("CMLNull"), "null is not a valid CML.", null, null, null);
        }
        String string2 = this.wrapCml(string);
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(true);
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes("UTF8"));
            DefaultHandler defaultHandler = new DefaultHandler(){
                private EntityResolverHelper entityHelper = new EntityResolverHelper();

                public InputSource resolveEntity(String string, String string2) throws SAXException {
                    try {
                        return this.entityHelper.resolveEntity(string, string2);
                    }
                    catch (IOException iOException) {
                        throw new SAXException("io exception", iOException);
                    }
                }

                public void error(SAXParseException sAXParseException) throws SAXException {
                    throw sAXParseException;
                }
            };
            sAXParser.parse((InputStream)byteArrayInputStream, defaultHandler);
        }
        catch (SAXParseException sAXParseException) {
            throw new ValidationFailureException(sAXParseException);
        }
        catch (SAXException sAXException) {
            throw new ValidationFailureException(sAXException);
        }
        catch (IOException iOException) {
            throw new ValidationException(iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ValidationException(parserConfigurationException);
        }
    }
}

