/*
 * Decompiled with CFR 0.152.
 */
package com.sun.eras.common.util;

import java.util.ArrayList;
import java.util.List;

public abstract class ObjectPool {
    private List availableObjects = new ArrayList();
    private List busyObjects = new ArrayList();
    private static final boolean debug = false;

    public ObjectPool() {
    }

    public ObjectPool(int n) {
        this();
        int n2 = 0;
        while (n2 < n) {
            this.availableObjects.add(this.create());
            ++n2;
        }
    }

    protected synchronized Object checkout() {
        this.log("Client is trying to checkout an object from the pool");
        Object var1_1 = null;
        while (!this.availableObjects.isEmpty()) {
            var1_1 = this.availableObjects.remove(this.availableObjects.size() - 1);
            if (this.validate(var1_1)) {
                this.busyObjects.add(var1_1);
                this.log("Returning a pooled object: " + var1_1);
                return var1_1;
            }
            this.log("Object did not pass validation: " + var1_1);
            var1_1 = null;
        }
        Object object = this.create();
        this.log("Created a new object instance: " + object);
        this.busyObjects.add(object);
        return object;
    }

    protected synchronized void release(Object object) {
        boolean bl = this.busyObjects.remove(object);
        if (bl) {
            this.availableObjects.add(object);
        } else {
            this.log("Unknown object returned to pool: " + object);
        }
    }

    public String toString() {
        float f = (float)this.busyObjects.size() / (float)this.availableObjects.size();
        return "ObjectPool of " + this.busyObjects.size() + " objects, " + f + "% full";
    }

    protected abstract Object create();

    protected abstract boolean validate(Object var1);

    private void log(String string) {
    }
}

