/*
 * Decompiled with CFR 0.152.
 */
package com.sun.eras.common.util;

import java.text.Format;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class MessageBase {
    protected abstract Object[] getArguments();

    protected abstract String getBundleName();

    protected String getDefaultMessage() {
        return null;
    }

    protected Format[] getFormats() {
        Object[] objectArray = this.getArguments();
        if (objectArray == null || objectArray.length == 0) {
            return null;
        }
        Format[] formatArray = new Format[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            formatArray[n] = null;
            ++n;
        }
        return formatArray;
    }

    protected Locale getLocale() {
        return null;
    }

    protected abstract String getPatternName();

    protected ResourceBundle getBundle() throws MissingResourceException {
        Locale locale = this.getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(this.getBundleName(), locale);
    }

    public String getMessage() {
        String string = this.getBundleName();
        String string2 = this.getPatternName();
        Object[] objectArray = this.getArguments();
        Locale locale = this.getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = this.getBundle();
        }
        catch (MissingResourceException missingResourceException) {
            return this.makeMissingResourceMessage("bundle");
        }
        MessageFormat messageFormat = new MessageFormat("");
        messageFormat.setLocale(locale);
        String string3 = null;
        try {
            string3 = resourceBundle.getString(string2);
        }
        catch (MissingResourceException missingResourceException) {
            return this.makeMissingResourceMessage("key");
        }
        messageFormat.applyPattern(string3);
        Format[] formatArray = this.getFormats();
        if (formatArray != null) {
            messageFormat.setFormats(formatArray);
        }
        String string4 = messageFormat.format(objectArray);
        return string4;
    }

    String makeMissingResourceMessage(String string) {
        String string2 = this.getBundleName();
        String string3 = this.getPatternName();
        Object[] objectArray = this.getArguments();
        String string4 = "";
        String string5 = this.getDefaultMessage();
        if (string5 != null && string5.trim().length() != 0) {
            string4 = string4 + string5;
        }
        if (objectArray != null && objectArray.length > 0) {
            string4 = string4 + " [";
            int n = 0;
            while (n < objectArray.length) {
                string4 = string4 + (objectArray[n] instanceof String ? "\"" + objectArray[n] + "\"" : objectArray[n].toString());
                if (n < objectArray.length - 1) {
                    string4 = string4 + ", ";
                }
                ++n;
            }
            string4 = string4 + "]";
        }
        string4 = string4 + "\n(Localization of this message failed: Bundle=\"" + string2 + "\", key=\"" + string3 + "\".";
        string4 = string4 + " The " + string + " is missing.)";
        return string4;
    }
}

