/*
 * Decompiled with CFR 0.152.
 */
package com.sun.eras.common.util;

import com.sun.eras.common.logging4.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EntityResolverHelper
implements EntityResolver {
    static final Logger logger = Logger.getLogger((class$com$sun$eras$common$util$EntityResolverHelper == null ? (class$com$sun$eras$common$util$EntityResolverHelper = EntityResolverHelper.class$("com.sun.eras.common.util.EntityResolverHelper")) : class$com$sun$eras$common$util$EntityResolverHelper).getName());
    private static Hashtable entities = null;
    private static Hashtable publicIds = null;
    private static Set alreadyLogged = new HashSet();
    static /* synthetic */ Class class$com$sun$eras$common$util$EntityResolverHelper;

    public EntityResolverHelper() {
        if (entities == null) {
            EntityResolverHelper.initializeEntities();
        }
    }

    private static synchronized void initializeEntities() {
        if (entities != null) {
            return;
        }
        entities = new Hashtable();
        publicIds = new Hashtable();
        EntityResolverHelper.register("-//Sun Microsystems, Inc.//DTD eRAS Checklist 1.0//EN", "http://mcnealy.central.sun.com/dtd/checklist.dtd", null, "/com/sun/eras/common/checks/checklist.dtd");
        EntityResolverHelper.reverseRegister("-//Sun Microsystems, Inc.//DTD eRAS Checklist 1.0//EN", "Entity-Resolver-Required:eras-common.jar!checklist.dtd");
        EntityResolverHelper.register("-//Sun Microsystems, Inc.//DTD eRAS Checklist 1_1//EN", "http://mcnealy.central.sun.com/dtd/checklist1_1.dtd", null, "/com/sun/eras/common/checks/checklist1_1.dtd");
        EntityResolverHelper.reverseRegister("-//Sun Microsystems, Inc.//DTD eRAS Checklist 1_1//EN", "Entity-Resolver-Required:eras-common.jar!checklist1_1.dtd");
        EntityResolverHelper.register("-//Sun Microsystems, Inc.//DTD eRAS Textbody//EN", "http://mcnealy.central.sun.com/dtd/textbody.dtd", null, "/com/sun/eras/common/validator/textbody.dtd");
        EntityResolverHelper.reverseRegister("-//Sun Microsystems, Inc.//DTD eRAS Textbody//EN", "Entity-Resolver-Required:eras-common.jar!textbody.dtd");
        EntityResolverHelper.register("-//Sun Microsystems, Inc.//DTD eRAS Textbodyfrag//EN", "http://mcnealy.central.sun.com/dtd/textbodyfrag.dtd", null, "/com/sun/eras/common/validator/textbodyfrag.dtd");
        EntityResolverHelper.register("-//Sun Microsystems, Inc.//DTD eRAS Result 1.0//EN", "http://mcnealy.central.sun.com/dtd/kaeresult.dtd", null, "/com/sun/eras/common/kaeresult/kaeresult.dtd");
        EntityResolverHelper.reverseRegister("-//Sun Microsystems, Inc.//DTD eRAS Result 1.0//EN", "Entity-Resolver-Required:eras-common.jar!kaeresult.dtd");
        EntityResolverHelper.register("-//Sun Microsystems, Inc.//DTD eRAS Result 1.1//EN", "http://mcnealy.central.sun.com/dtd/1.1/kaeresult.dtd", null, "/com/sun/eras/common/kaeresult/1.1/kaeresult.dtd");
        EntityResolverHelper.reverseRegister("-//Sun Microsystems, Inc.//DTD eRAS Result 1.1//EN", "Entity-Resolver-Required:eras-common.jar!1.1/kaeresult.dtd");
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
        String string3 = this.lookup(string, string2);
        String string4 = string + "|||" + string2;
        Set set = alreadyLogged;
        synchronized (set) {
            if (!alreadyLogged.contains(string4)) {
                logger.fine("resolveEntity(\"" + string + "\", \"" + string2 + "\") = " + "\"" + string3 + "\"");
                alreadyLogged.add(string4);
            }
        }
        if (string3 == null) {
            return null;
        }
        try {
            URL uRL = new URL(string3);
            InputStream inputStream = uRL.openStream();
            return new InputSource(inputStream);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    final String lookup(String string, String string2) {
        String string3 = null;
        if (string != null) {
            string3 = (String)entities.get(string);
        }
        if (string3 == null && string2 != null) {
            string3 = (String)entities.get(string2);
        }
        return string3;
    }

    protected static final void register(String string, String string2) {
        URL uRL = (class$com$sun$eras$common$util$EntityResolverHelper == null ? (class$com$sun$eras$common$util$EntityResolverHelper = EntityResolverHelper.class$("com.sun.eras.common.util.EntityResolverHelper")) : class$com$sun$eras$common$util$EntityResolverHelper).getResource(string2);
        entities.put(string, uRL.toString());
    }

    private static final void register(String string, String string2, String string3, String string4) {
        EntityResolverHelper.register(string, string4);
        if (string2 != null) {
            EntityResolverHelper.register(string2, string4);
        }
        if (string3 != null) {
            EntityResolverHelper.register(string3, string4);
        }
    }

    protected static final void reverseRegister(String string, String string2) {
        if (string2 != null) {
            publicIds.put(string2, string);
        }
    }

    public String publicIdForSystemId(String string) {
        Object v = publicIds.get(string);
        String string2 = "publicIdForSystemId--" + string;
        if (!alreadyLogged.contains(string2)) {
            logger.fine("publicIdForSystemId(\"" + string + "\") = " + "\"" + v + "\"");
            alreadyLogged.add(string2);
        }
        if (v != null) {
            return (String)v;
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("EntityResolverHelper[");
        stringBuffer.append("entities=");
        stringBuffer.append(entities.toString());
        stringBuffer.append("; publicIds=");
        stringBuffer.append(publicIds);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    Hashtable getPrivateEntitiesMapForTestingOnly() {
        return entities;
    }

    Hashtable getPrivatePublicIdMapForTestingOnly() {
        return publicIds;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

