/*
 * Decompiled with CFR 0.152.
 */
package com.sun.eras.common.translator.cml;

import java.util.ArrayList;
import java.util.List;

public class LineWrapper {
    StringBuffer sb = new StringBuffer();
    private int currentCol = 0;
    private boolean prevWhitespace = false;
    private int stopper = 0;
    private String lineWrapPrefix = "";

    public LineWrapper() {
    }

    LineWrapper(String string, int n, boolean bl) {
        this.sb.append(string);
        this.currentCol = n;
        this.prevWhitespace = bl;
    }

    int getCurrentCol() {
        return this.currentCol;
    }

    boolean isPrevWhitespace() {
        return this.prevWhitespace;
    }

    boolean isPrevNewline() {
        int n = this.sb.length();
        if (n == 0) {
            return false;
        }
        return '\n' == this.sb.charAt(n - 1);
    }

    int getStopper() {
        return this.stopper;
    }

    public void setLineWrapPrefix(String string) {
        if (string == null) {
            string = "";
        }
        this.lineWrapPrefix = string;
    }

    public String getLineWrapPrefix() {
        return this.lineWrapPrefix;
    }

    public LineWrapper append(String string) {
        if (string == null) {
            return this;
        }
        int n = string.length();
        if (n == 0) {
            return this;
        }
        this.sb.append(string);
        this.prevWhitespace = Character.isWhitespace(string.charAt(n - 1));
        int n2 = string.lastIndexOf(10);
        this.currentCol = n2 >= 0 ? n - n2 - 1 : (this.currentCol += n);
        this.stopper = this.length() - 1;
        return this;
    }

    public LineWrapper needNewline() {
        if (!this.isPrevNewline()) {
            this.append("\n");
        }
        return this;
    }

    public LineWrapper lineWrap(String string, int n) {
        if (string == null) {
            return this;
        }
        int n2 = string.length();
        if (n2 == 0) {
            return this;
        }
        int n3 = 0;
        int n4 = 0;
        char c = ' ';
        boolean bl = true;
        while (n3 < n2) {
            c = string.charAt(n3);
            bl = Character.isWhitespace(c);
            if (bl) {
                if (n4 != n3) {
                    this.wrapWord(string, n4, n3, n);
                }
                if (!this.prevWhitespace) {
                    this.wrapSpace(n);
                }
                n4 = ++n3;
                continue;
            }
            ++n3;
        }
        if (n4 != n2) {
            this.wrapWord(string, n4, n2, n);
        }
        return this;
    }

    private void wrapWord(String string, int n, int n2, int n3) {
        int n4 = n2 - n;
        if (this.currentCol + n4 > n3) {
            this.backup();
        }
        this.sb.append(string.substring(n, n2));
        this.currentCol += n4;
        this.prevWhitespace = false;
    }

    void backup() {
        int n = this.sb.length();
        int n2 = n - 1;
        while (n2 > this.stopper) {
            char c = this.sb.charAt(n2);
            if (c == ' ') {
                this.wrapNewline(n2);
                return;
            }
            if (Character.isWhitespace(c)) {
                this.stopper = n - 1;
                return;
            }
            --n2;
        }
    }

    LineWrapper wrapSpace(int n) {
        if (this.currentCol >= n) {
            this.sb.append(" ");
            this.wrapNewline(this.sb.length() - 1);
            this.prevWhitespace = true;
        } else if (!this.prevWhitespace) {
            this.sb.append(" ");
            ++this.currentCol;
            this.prevWhitespace = true;
        }
        return this;
    }

    private void wrapNewline(int n) {
        int n2 = this.sb.length();
        this.sb.setCharAt(n, '\n');
        this.sb.insert(n + 1, this.lineWrapPrefix);
        this.currentCol = n2 - n - 1 + this.lineWrapPrefix.length();
        this.stopper = n;
    }

    public List getLines() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.toString();
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        while ((n3 = string.indexOf(10, n2)) >= 0) {
            arrayList.add(string.substring(n2, n3 + 1));
            n2 = n3 + 1;
        }
        if (n2 < n) {
            arrayList.add(string.substring(n2, n));
        }
        return arrayList;
    }

    public int length() {
        return this.sb.length();
    }

    public String toString() {
        return this.sb.toString();
    }

    protected String dbgToString() {
        StringBuffer stringBuffer = new StringBuffer("LineWrapper[");
        stringBuffer.append("currentCol=").append(this.currentCol).append(",");
        stringBuffer.append("prevWhitespace=").append(this.prevWhitespace).append(",");
        stringBuffer.append("sb=\"");
        String string = this.sb.toString();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        stringBuffer.append("\"").append(",");
        stringBuffer.append("stopper=").append(this.stopper);
        if (this.lineWrapPrefix.length() > 0) {
            stringBuffer.append(",").append("lineWrapPrefix=\"").append(this.lineWrapPrefix).append("\"");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

